/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.controls.SingleRowTabbedPaneUI;

public class SingleRowTabbedPane
extends JTabbedPane {
    public static final String SCROLL_MENU_SORT_PROPERTY = "scrollMenuSorted";
    public static final String SCROLL_MENU_SHOW_VISIBLE_PROPERTY = "scrollMenuShowVisible";
    private static final String uiClassID = "SingleRowTabbedPaneUI";
    private static final int MAX_HOTKEYS = 9;
    protected int[] hotkeys;
    protected boolean swapping;

    void $init$() {
        this.hotkeys = new int[9];
    }

    public SingleRowTabbedPane() {
        this.$init$();
        this.setOpaque(true);
        int n = 0;
        while (n < this.hotkeys.length) {
            this.hotkeys[n] = -1;
            ++n;
        }
    }

    public SingleRowTabbedPane(int n) {
        super(n);
        this.$init$();
    }

    public void showScrollMenu() {
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof SingleRowTabbedPaneUI) {
            ((SingleRowTabbedPaneUI)tabbedPaneUI).showScrollMenu();
        }
    }

    public boolean isScrollMenuSorted() {
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof SingleRowTabbedPaneUI) {
            return ((SingleRowTabbedPaneUI)tabbedPaneUI).isScrollMenuSorted();
        }
        return false;
    }

    public void setScrollMenuSorted(boolean bl) {
        TabbedPaneUI tabbedPaneUI = this.getUI();
        if (tabbedPaneUI instanceof SingleRowTabbedPaneUI) {
            ((SingleRowTabbedPaneUI)tabbedPaneUI).setScrollMenuSorted(bl);
        }
    }

    public void setHotkeyAt(int n, int n2) {
        if (n < 0 || n >= this.getTabCount() || n2 < 1 || n2 > 9) {
            throw new IllegalArgumentException();
        }
        --n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.hotkeys.length) {
            int n6 = this.hotkeys[n5];
            if (n6 == -1) {
                if (n2 == n5 && n4 == -1) {
                    n4 = n5;
                }
            } else if (n6 == n) {
                if (n2 == n5) {
                    return;
                }
                n3 = n5;
                if (n5 <= n2) {
                    n4 = n;
                }
            } else if (n6 < n) {
                if (n5 < n2) {
                    n4 = n6 + 1;
                } else if (n5 == n2) {
                    n4 = n6;
                }
            } else if (n5 <= n2) {
                n4 = n6;
            }
            ++n5;
        }
        if (n4 == -1) {
            n4 = this.getTabCount() - 1;
        }
        if (n == n4) {
            if (n3 != -1) {
                this.hotkeys[n3] = -1;
            }
            this.hotkeys[n2] = n;
            this.repaint();
            return;
        }
        if (this.hotkeys[n2] == -1) {
            this.moveTab(n, n4);
        } else {
            this.swapTabs(n, n4);
        }
        int n7 = 0;
        while (n7 < this.hotkeys.length) {
            if (this.hotkeys[n7] == n4) {
                this.hotkeys[n7] = -1;
            }
            ++n7;
        }
        this.hotkeys[n2] = n4;
        this.repaint();
    }

    public int getHotkeyAt(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < this.hotkeys.length) {
            if (this.hotkeys[n2] == n) {
                return n2 + 1;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndexOfHotkey(int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException();
        }
        return this.hotkeys[n - 1];
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public void setTabPlacement(int n) {
        if (n != 1) {
            throw new UnsupportedOperationException();
        }
        super.setTabPlacement(n);
    }

    public void addImpl(Component component, Object object, int n) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(null);
        }
        super.addImpl(component, object, n);
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        if (this.swapping) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.hotkeys.length) {
            int n6 = this.hotkeys[n5];
            if (n6 == -1) {
                if (n4 == -1 || n4 < n2) {
                    n4 = n5;
                }
            } else if (n6 < n) {
                n2 = n5;
            } else if (n3 == -1) {
                n3 = n5;
            }
            ++n5;
        }
        if (n4 == -1) {
            return;
        }
        if (n3 == -1) {
            this.hotkeys[n2 + 1] = n;
            return;
        }
        if (n2 != -1 && n4 < n2) {
            int n7 = n4;
            while (n7 < n2) {
                this.hotkeys[n7] = this.hotkeys[n7 + 1];
                ++n7;
            }
            this.hotkeys[n2] = n;
        } else if (n4 > n3) {
            int n8 = n4;
            while (n8 > n3) {
                this.hotkeys[n8] = this.hotkeys[n8 - 1] + 1;
                --n8;
            }
            this.hotkeys[n3] = n;
            n3 = n4 + 1;
        } else {
            this.hotkeys[n4] = n;
        }
        int n9 = n3;
        while (n9 < this.hotkeys.length) {
            if (this.hotkeys[n9] != -1) {
                int n10 = n9;
                this.hotkeys[n10] = this.hotkeys[n10] + 1;
            }
            ++n9;
        }
    }

    public void removeTabAt(int n) {
        super.removeTabAt(n);
        if (this.swapping) {
            return;
        }
        int n2 = 0;
        while (n2 < this.hotkeys.length) {
            if (this.hotkeys[n2] == n) {
                this.hotkeys[n2] = -1;
            } else if (this.hotkeys[n2] > n) {
                int n3 = n2;
                this.hotkeys[n3] = this.hotkeys[n3] - 1;
            }
            ++n2;
        }
    }

    public void removeAll() {
        super.removeAll();
        int n = 0;
        while (n < this.hotkeys.length) {
            this.hotkeys[n] = -1;
            ++n;
        }
    }

    protected void moveTab(int n, int n2) {
        int n3 = this.getTabCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException();
        }
        if (n == n2) {
            return;
        }
        String string = this.getTitleAt(n);
        Icon icon = this.getIconAt(n);
        Component component = this.getComponentAt(n);
        String string2 = this.getToolTipTextAt(n);
        this.removeTabAt(n);
        this.insertTab(string, icon, component, string2, n2);
        this.setSelectedComponent(component);
        component.setVisible(true);
    }

    protected void swapTabs(int n, int n2) {
        int n3 = this.getTabCount();
        if (n < 0 || n >= n3 || n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException();
        }
        if (n == n2) {
            return;
        }
        String string = this.getTitleAt(n);
        Icon icon = this.getIconAt(n);
        Component component = this.getComponentAt(n);
        String string2 = this.getToolTipTextAt(n);
        String string3 = this.getTitleAt(n2);
        Icon icon2 = this.getIconAt(n2);
        Component component2 = this.getComponentAt(n2);
        String string4 = this.getToolTipTextAt(n2);
        this.swapping = true;
        this.removeTabAt(Math.max(n, n2));
        this.removeTabAt(Math.min(n, n2));
        this.insertTab(string3, icon2, component2, string4, n2 > n ? n : n - 1);
        this.insertTab(string, icon, component, string2, n2);
        this.swapping = false;
        this.setSelectedComponent(component);
        component.setVisible(true);
    }
}

