/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.accessibility.Accessible;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controls.SingleRowTabbedPane;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeIcons;

public class SingleRowTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Insets _tabAreaInsets = new Insets(0, 0, 0, 0);
    private static final Insets _contentBorderInsets = new Insets(2, 0, 0, 0);
    private static final Insets _selectedTabPadInsets = new Insets(0, 0, 0, 0);
    protected static final Comparator scrollMenuItemComparator = new ScrollMenuItemComparator();
    protected static final Icon blankIcon = IdeIcons.getIcon(0);
    protected static final Icon scrollBothIcon = ControlsArb.getIcon(3);
    protected static final Icon scrollLeftIcon = ControlsArb.getIcon(4);
    protected static final Icon scrollRightIcon = ControlsArb.getIcon(5);
    protected static final int scrollButtonWidth = Math.max(scrollBothIcon.getIconWidth(), Math.max(scrollLeftIcon.getIconWidth(), scrollRightIcon.getIconWidth()));
    protected static final int scrollButtonHeight = Math.max(scrollBothIcon.getIconHeight(), Math.max(scrollLeftIcon.getIconHeight(), scrollRightIcon.getIconHeight()));
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected EventHandler eventHandler;
    protected JPopupMenu scrollMenu;
    protected Font scrollMenuBoldFont;
    protected ToggleAction scrollMenuSortAction;
    protected ToggleAction scrollMenuShowVisibleAction;
    protected int mouseOverIndex;
    protected int firstVisibleIndex;
    protected int lastVisibleIndex;
    protected boolean lockFirstVisible;

    private SingleRowTabbedPaneUI() {
    }

    public void showScrollMenu() {
        if (this.isScrollButtonVisible() && !this.isScrollMenuVisible()) {
            this.setScrollMenuVisible(true);
        }
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        return super.tabForCoordinate(jTabbedPane, n, n2);
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        return super.getTabBounds(jTabbedPane, n);
    }

    public int getTabRunCount() {
        return 1;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.runCount = 1;
        this.scrollMenu = new JPopupMenu();
        this.scrollMenu.addPopupMenuListener(this.eventHandler);
        this.scrollMenuBoldFont = this.getScrollMenuBoldFont(this.scrollMenu);
        this.scrollMenuSortAction = new ScrollMenuSortAction();
        this.scrollMenuShowVisibleAction = new ScrollMenuShowVisibleAction();
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.runCount = 0;
        this.scrollMenu = null;
        this.scrollMenu.removePopupMenuListener(this.eventHandler);
        this.scrollMenuSortAction = null;
        this.scrollMenuShowVisibleAction = null;
        this.mouseOverIndex = -1;
        this.firstVisibleIndex = -1;
        this.lastVisibleIndex = -1;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.ensureCurrentLayout();
        int n = this.tabPane.getTabPlacement();
        int n2 = this.tabPane.getTabCount();
        int n3 = this.tabPane.getSelectedIndex();
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        int n4 = 0;
        while (n4 < n2) {
            if (this.rects[n4].intersects(rectangle)) {
                this.paintTab(graphics, n, this.rects, n4, rectangle2, rectangle3);
            }
            ++n4;
        }
        if (this.isScrollButtonVisible() && this.rects[n2].intersects(rectangle)) {
            this.paintScrollButton(graphics, n, this.rects[n2]);
        }
        this.paintContentBorder(graphics, n, n3);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (this.tabAreaBackground != null) {
            if (jComponent.isOpaque()) {
                graphics.setColor(this.tabAreaBackground);
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            }
            this.paint(graphics, jComponent);
        } else {
            super.update(graphics, jComponent);
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return super.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return super.getMinimumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return super.getMaximumSize(jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        return super.contains(jComponent, n, n2);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SingleRowTabbedPaneUI();
    }

    public int getAccessibleChildrenCount(JComponent jComponent) {
        return super.getAccessibleChildrenCount(jComponent);
    }

    public Accessible getAccessibleChild(JComponent jComponent, int n) {
        return super.getAccessibleChild(jComponent, n);
    }

    protected void installListeners() {
        super.installListeners();
        this.eventHandler = this.createEventHandler();
        if (this.eventHandler != null) {
            this.tabPane.addMouseListener(this.eventHandler);
            this.tabPane.addMouseMotionListener(this.eventHandler);
            this.tabPane.addChangeListener(this.eventHandler);
            this.tabPane.addFocusListener(this.eventHandler);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.eventHandler != null) {
            this.tabPane.removeMouseListener(this.eventHandler);
            this.tabPane.removeMouseMotionListener(this.eventHandler);
            this.tabPane.removeChangeListener(this.eventHandler);
            this.tabPane.removeFocusListener(this.eventHandler);
            this.eventHandler = null;
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = UIManager.getColor("TabbedPane.tabAreaBackground");
        this.selectColor = UIManager.getColor("TabbedPane.selected");
        this.tabAreaInsets = _tabAreaInsets;
        this.contentBorderInsets = _contentBorderInsets;
        this.selectedTabPadInsets = _selectedTabPadInsets;
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.tabAreaBackground = null;
        this.selectColor = null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return null;
    }

    protected ChangeListener createChangeListener() {
        return null;
    }

    protected FocusListener createFocusListener() {
        return null;
    }

    protected LayoutManager createLayoutManager() {
        return new SingleRowTabbedPaneLayout();
    }

    protected Icon getIconForTab(int n) {
        Icon icon;
        if ((!this.isTabEnabled(n) || n != this.tabPane.getSelectedIndex() && n != this.mouseOverIndex) && (icon = this.tabPane.getDisabledIconAt(n)) != null) {
            return icon;
        }
        return this.tabPane.getIconAt(n);
    }

    protected Icon getIconForMenu(int n) {
        Icon icon = this.tabPane.getIconAt(n);
        return icon != null ? icon : blankIcon;
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        if (!this.isTabVisible(n2)) {
            return;
        }
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        String string = this.tabPane.getTitleAt(n2);
        string = this.layoutCompoundLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle2, bl);
        this.paintIcon(graphics, n, font, fontMetrics, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    protected void paintIcon(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, Icon icon, Rectangle rectangle, boolean bl) {
        int n3;
        super.paintIcon(graphics, n, n2, icon, rectangle, bl);
        if (icon != null && (n3 = this.getHotkeyAt(n2)) != -1) {
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            String string = Integer.toString(n3);
            this.layoutCompoundLabel(n, fontMetrics, n2, string, null, rectangle, rectangle2, rectangle3, false);
            Color color = this.selectColor != null ? this.selectColor : this.tabPane.getBackgroundAt(n2);
            graphics.setColor(color);
            if (bl || n2 == this.mouseOverIndex) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                TextLayout textLayout = new TextLayout(string, graphics.getFont(), graphics2D.getFontRenderContext());
                AffineTransform affineTransform = new AffineTransform();
                Rectangle2D rectangle2D = textLayout.getBounds();
                affineTransform.setToTranslation((double)rectangle3.x - rectangle2D.getX() + (rectangle3.getWidth() - rectangle2D.getWidth()) / 2.0, (double)rectangle3.y - rectangle2D.getY() + (rectangle3.getHeight() - rectangle2D.getHeight()) / 2.0);
                graphics2D.draw(textLayout.getOutline(affineTransform));
                graphics.setColor(this.tabPane.getForegroundAt(n2));
                this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle3, bl);
                graphics2D.setRenderingHints(renderingHints);
            } else {
                this.paintText(graphics, n, font, fontMetrics, n2, string, rectangle3, bl);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.selectColor != null) {
            graphics.setColor(this.selectColor);
        } else {
            graphics.setColor(this.tabPane.getBackgroundAt(n2));
        }
        switch (n) {
            case 2: {
                graphics.fillRect(n3, n4, n5, n6 - 1);
                break;
            }
            case 4: {
                graphics.fillRect(n3, n4, n5, n6 - 1);
                break;
            }
            case 3: {
                graphics.fillRect(n3, n4, n5 - 1, n6);
                break;
            }
            default: {
                graphics.fillRect(n3, n4, n5 - 1, n6);
            }
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Color color;
        boolean bl2 = n2 == this.mouseOverIndex;
        Color color2 = bl ? this.shadow : this.lightHighlight;
        Color color3 = color = bl ? this.lightHighlight : this.shadow;
        if (bl || bl2) {
            graphics.setColor(color2);
            graphics.drawLine(n3, n4 + n6 - 1, n3, n4);
            graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
        }
        graphics.setColor(color);
        graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 1);
        if (bl2 && !bl) {
            graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
        }
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.lightHighlight);
        graphics.drawLine(n3, n4 + 1, n3 + n5 - 1, n4 + 1);
        graphics.setColor(this.shadow);
        graphics.drawLine(n3, n4, n3 + n5 - 1, n4);
        if (n2 != -1) {
            Rectangle rectangle = this.rects[n2];
            if (this.selectColor != null) {
                graphics.setColor(this.selectColor);
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2));
            }
            graphics.drawLine(rectangle.x + 1, n4, rectangle.x + rectangle.width - 2, n4);
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
    }

    protected String layoutCompoundLabel(int n, FontMetrics fontMetrics, int n2, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        string = SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        int n3 = this.getTabLabelShiftX(n, n2, bl);
        int n4 = this.getTabLabelShiftY(n, n2, bl);
        rectangle2.x += n3;
        rectangle2.y += n4;
        rectangle3.x += n3;
        rectangle3.y += n4;
        return string;
    }

    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 1: 
            case 2: {
                return bl ? 1 : 0;
            }
            case 3: 
            case 4: {
                return bl ? 0 : -1;
            }
        }
        return 0;
    }

    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        Rectangle rectangle = this.rects[n2];
        switch (n) {
            case 1: 
            case 2: {
                return bl ? 1 : 0;
            }
            case 3: 
            case 4: {
                return bl ? 0 : -1;
            }
        }
        return 0;
    }

    protected int calculateMaxTabHeight(int n) {
        int n2 = super.calculateMaxTabHeight(n);
        return Math.max(n2, scrollButtonHeight);
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    protected int getHotkeyAt(int n) {
        return ((SingleRowTabbedPane)this.tabPane).getHotkeyAt(n);
    }

    protected void paintScrollButton(Graphics graphics, int n, Rectangle rectangle) {
        Icon icon;
        int n2 = this.tabPane.getTabCount();
        if (this.firstVisibleIndex > 0 && this.lastVisibleIndex < n2 - 1) {
            icon = scrollBothIcon;
        } else if (this.firstVisibleIndex > 0) {
            icon = scrollLeftIcon;
        } else if (this.lastVisibleIndex < n2 - 1) {
            icon = scrollRightIcon;
        } else {
            return;
        }
        boolean bl = this.isScrollMenuVisible();
        boolean bl2 = this.mouseOverIndex == n2;
        int n3 = rectangle.x + (rectangle.width - icon.getIconWidth()) / 2 + this.getTabLabelShiftX(n, n2, bl);
        int n4 = rectangle.y + (rectangle.height - icon.getIconHeight()) / 2 + this.getTabLabelShiftY(n, n2, bl);
        if (bl || bl2) {
            this.paintTabBorder(graphics, n, n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl);
        }
        icon.paintIcon(this.tabPane, graphics, n3, n4);
    }

    protected void setMouseOver(int n) {
        if (this.mouseOverIndex != n) {
            int n2 = this.tabPane.getTabPlacement();
            if (this.mouseOverIndex != -1) {
                this.repaintTab(this.mouseOverIndex);
            }
            this.mouseOverIndex = n;
            if (n != -1) {
                this.repaintTab(n);
            }
        }
    }

    protected void repaintTab(int n) {
        if (n >= 0 && n < this.rects.length) {
            this.tabPane.repaint(this.rects[n]);
        }
    }

    protected boolean isTabEnabled(int n) {
        return this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n);
    }

    protected boolean isTabVisible(int n) {
        return n >= 0 && n < this.tabPane.getTabCount() && this.rects[n].width != 0;
    }

    protected boolean isInScrollButton(int n, int n2) {
        if (!this.isScrollButtonVisible()) {
            return false;
        }
        int n3 = this.tabPane.getTabCount();
        return this.rects[n3].contains(n, n2);
    }

    protected boolean isScrollButtonVisible() {
        if (this.firstVisibleIndex > 0) {
            return true;
        }
        int n = this.tabPane.getTabCount();
        return this.lastVisibleIndex < n - 1;
    }

    protected boolean isScrollMenuSorted() {
        return this.scrollMenuSortAction.getState();
    }

    protected void setScrollMenuSorted(boolean bl) {
        this.scrollMenuSortAction.setState(bl);
    }

    protected boolean isScrollMenuShowVisible() {
        return this.scrollMenuShowVisibleAction.getState();
    }

    protected void setScrollMenuShowVisible(boolean bl) {
        this.scrollMenuShowVisibleAction.setState(bl);
    }

    protected boolean isScrollMenuVisible() {
        return this.scrollMenu.isVisible();
    }

    protected void setScrollMenuVisible(boolean bl) {
        if (bl == this.isScrollMenuVisible()) {
            return;
        }
        int n = this.tabPane.getTabCount();
        this.repaintTab(n);
        if (bl) {
            int n2;
            int n3;
            this.scrollMenu.removeAll();
            boolean bl2 = this.isScrollMenuShowVisible();
            boolean bl3 = this.isScrollMenuSorted();
            ArrayList<JComponent> arrayList = new ArrayList<JComponent>(n);
            int n4 = 0;
            while (n4 < n) {
                if (bl2 || !this.isTabVisible(n4)) {
                    arrayList.add(this.createScrollMenuItem(n4));
                }
                if (!bl3 && !bl2 && n4 == this.firstVisibleIndex && this.firstVisibleIndex > 0 && this.lastVisibleIndex < n - 1) {
                    arrayList.add(new JSeparator());
                }
                ++n4;
            }
            if (bl3) {
                Collections.sort(arrayList, scrollMenuItemComparator);
            }
            for (Object e : arrayList) {
                if (e instanceof JMenuItem) {
                    this.scrollMenu.add((JMenuItem)e);
                    continue;
                }
                this.scrollMenu.addSeparator();
            }
            this.scrollMenu.addSeparator();
            this.scrollMenu.add(new ToggleMenuItem(this.scrollMenuSortAction));
            Rectangle rectangle = this.rects[n];
            Dimension dimension = this.scrollMenu.getPreferredSize();
            int n5 = rectangle.x + rectangle.width - 1;
            int n6 = rectangle.y + rectangle.height - 1;
            switch (this.tabPane.getTabPlacement()) {
                case 2: {
                    n3 = n5;
                    n2 = n6 - dimension.height;
                    break;
                }
                case 4: {
                    n3 = rectangle.x - dimension.width;
                    n2 = n6 - dimension.height;
                    break;
                }
                case 3: {
                    n3 = n5 - dimension.width;
                    n2 = rectangle.y - dimension.height;
                    break;
                }
                default: {
                    n3 = n5 - dimension.width;
                    n2 = n6;
                }
            }
            MenuUtils.showPopupMenu((JPopupMenu)this.scrollMenu, (Component)this.tabPane, (int)n3, (int)n2);
        } else {
            this.scrollMenu.setVisible(false);
        }
    }

    protected JMenuItem createScrollMenuItem(int n) {
        String string = this.tabPane.getTitleAt(n);
        Icon icon = this.getIconForMenu(n);
        JMenuItem jMenuItem = new JMenuItem(string, icon);
        if (this.isTabVisible(n)) {
            jMenuItem.setFont(this.scrollMenuBoldFont);
        }
        jMenuItem.setActionCommand(Integer.toString(n));
        jMenuItem.addActionListener(this.eventHandler);
        return jMenuItem;
    }

    protected Font getScrollMenuBoldFont(Component component) {
        Font font = component.getFont();
        component.setFont(font.deriveFont(0));
        return font.deriveFont(1);
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    static FontMetrics mav$getFontMetrics(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.getFontMetrics();
    }

    static JTabbedPane ra$tabPane(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.tabPane;
    }

    static Insets mav$getTabAreaInsets(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        return singleRowTabbedPaneUI.getTabAreaInsets(n);
    }

    static void wa$maxTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.maxTabHeight = n;
    }

    static void wa$maxTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.maxTabWidth = n;
    }

    static int mav$calculateTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n, int n2, FontMetrics fontMetrics) {
        return singleRowTabbedPaneUI.calculateTabWidth(n, n2, fontMetrics);
    }

    static Rectangle[] ra$rects(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.rects;
    }

    static int mav$calculateTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n, int n2, int n3) {
        return singleRowTabbedPaneUI.calculateTabHeight(n, n2, n3);
    }

    static int ra$maxTabHeight(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.maxTabHeight;
    }

    static int ra$maxTabWidth(SingleRowTabbedPaneUI singleRowTabbedPaneUI) {
        return singleRowTabbedPaneUI.maxTabWidth;
    }

    static void mav$assureRectsCreated(SingleRowTabbedPaneUI singleRowTabbedPaneUI, int n) {
        singleRowTabbedPaneUI.assureRectsCreated(n);
    }

    static void mav$setVisibleComponent(SingleRowTabbedPaneUI singleRowTabbedPaneUI, Component component) {
        singleRowTabbedPaneUI.setVisibleComponent(component);
    }

    protected class SingleRowTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public void calculateLayoutInfo() {
            int n = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabCount();
            SingleRowTabbedPaneUI.mav$assureRectsCreated(SingleRowTabbedPaneUI.this, n + 1);
            this.calculateTabRects(SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabPlacement(), n);
        }

        protected void calculateTabRects(int n, int n2) {
            FontMetrics fontMetrics = SingleRowTabbedPaneUI.mav$getFontMetrics(SingleRowTabbedPaneUI.this);
            int n3 = fontMetrics.getHeight();
            Insets insets = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getInsets();
            Insets insets2 = SingleRowTabbedPaneUI.mav$getTabAreaInsets(SingleRowTabbedPaneUI.this, n);
            Dimension dimension = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getSize();
            int n4 = SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getSelectedIndex();
            SingleRowTabbedPaneUI.wa$maxTabHeight(SingleRowTabbedPaneUI.this, SingleRowTabbedPaneUI.this.calculateMaxTabHeight(n));
            SingleRowTabbedPaneUI.wa$maxTabWidth(SingleRowTabbedPaneUI.this, 0);
            int n5 = insets.left + insets2.left;
            int n6 = insets.top + insets2.top;
            int n7 = dimension.width - (insets.right + insets2.right);
            if (SingleRowTabbedPaneUI.this.lockFirstVisible) {
                SingleRowTabbedPaneUI.this.lastVisibleIndex = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = 0;
                SingleRowTabbedPaneUI.this.firstVisibleIndex = 0;
            }
            int n8 = SingleRowTabbedPaneUI.this.firstVisibleIndex;
            while (n8 < n2) {
                int n9;
                int n10 = SingleRowTabbedPaneUI.mav$calculateTabWidth(SingleRowTabbedPaneUI.this, n, n8, fontMetrics);
                if (n5 + n10 > (n9 = n7 - (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || n8 < n2 - 1 ? scrollButtonWidth : 0))) {
                    if (n8 > n4) {
                        int n11 = n8;
                        while (n11 < n2) {
                            SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[n11].width = 0;
                            ++n11;
                        }
                        break;
                    }
                    int n12 = n5 + n10 - n9;
                    int n13 = 0;
                    int n14 = 0;
                    while (n14 < n8) {
                        SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[n14].width = 0;
                        if ((n13 += SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[n14].width) >= n12) break;
                        ++n14;
                    }
                    if (n13 != 0) {
                        SingleRowTabbedPaneUI.this.firstVisibleIndex = ++n14;
                        while (n14 < n8) {
                            SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[n14++].x -= n13;
                        }
                        n5 -= n13;
                    }
                }
                Rectangle rectangle = SingleRowTabbedPaneUI.ra$rects(SingleRowTabbedPaneUI.this)[n8];
                rectangle.width = Math.min(n10, n9 - n5 - insets.left - insets2.left);
                rectangle.height = SingleRowTabbedPaneUI.mav$calculateTabHeight(SingleRowTabbedPaneUI.this, n, n8, n3);
                rectangle.x = n5;
                rectangle.y = n6 - (rectangle.height - SingleRowTabbedPaneUI.ra$maxTabHeight(SingleRowTabbedPaneUI.this));
                SingleRowTabbedPaneUI.wa$maxTabWidth(SingleRowTabbedPaneUI.this, Math.max(SingleRowTabbedPaneUI.ra$maxTabWidth(SingleRowTabbedPaneUI.this), n10));
                n5 += rectangle.width;
                SingleRowTabbedPaneUI.this.lastVisibleIndex = n8++;
            }
            if (SingleRowTabbedPaneUI.this.firstVisibleIndex > 0 || SingleRowTabbedPaneUI.this.lastVisibleIndex < n2 - 1) {
                Rectangle rectangle = SingleRowTabbedPaneUI.ra$rects(SingleRowTabbedPaneUI.this)[n2];
                rectangle.x = n7 - scrollButtonWidth;
                rectangle.y = n6;
                rectangle.width = scrollButtonWidth;
                rectangle.height = SingleRowTabbedPaneUI.ra$maxTabHeight(SingleRowTabbedPaneUI.this);
                SingleRowTabbedPaneUI.this.repaintTab(n2);
            } else {
                SingleRowTabbedPaneUI.ra$rects((SingleRowTabbedPaneUI)SingleRowTabbedPaneUI.this)[n2].width = 0;
            }
            this.padSelectedTab(n, n4);
        }

        protected SingleRowTabbedPaneLayout() {
            super(SingleRowTabbedPaneUI.this);
        }
    }

    protected class EventHandler
    implements ActionListener,
    PopupMenuListener,
    FocusListener,
    ChangeListener,
    MouseMotionListener,
    MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if (!jTabbedPane.isEnabled()) {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
                return;
            }
            int n = SingleRowTabbedPaneUI.this.tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                SingleRowTabbedPaneUI.this.setMouseOver(n);
            } else if (SingleRowTabbedPaneUI.this.isInScrollButton(mouseEvent.getX(), mouseEvent.getY())) {
                SingleRowTabbedPaneUI.this.setMouseOver(jTabbedPane.getTabCount());
            } else {
                SingleRowTabbedPaneUI.this.setMouseOver(-1);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            SingleRowTabbedPaneUI.this.setMouseOver(-1);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SingleRowTabbedPaneUI.this.isInScrollButton(mouseEvent.getX(), mouseEvent.getY())) {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(SingleRowTabbedPaneUI.this.isScrollMenuVisible() ^ true);
            } else {
                SingleRowTabbedPaneUI.this.setScrollMenuVisible(false);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEntered(mouseEvent);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            int n = jTabbedPane.getSelectedIndex();
            if (n < SingleRowTabbedPaneUI.this.firstVisibleIndex || n > SingleRowTabbedPaneUI.this.lastVisibleIndex) {
                SingleRowTabbedPaneUI.this.lockFirstVisible = false;
                jTabbedPane.revalidate();
            } else {
                SingleRowTabbedPaneUI.this.lockFirstVisible = true;
                SingleRowTabbedPaneUI.mav$setVisibleComponent(SingleRowTabbedPaneUI.this, jTabbedPane.getComponentAt(n));
            }
            jTabbedPane.repaint();
        }

        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(jTabbedPane.getSelectedIndex());
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            SingleRowTabbedPaneUI.this.repaintTab(jTabbedPane.getSelectedIndex());
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            SingleRowTabbedPaneUI.this.repaintTab(SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).getTabCount());
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = Integer.parseInt(string);
            SingleRowTabbedPaneUI.ra$tabPane(SingleRowTabbedPaneUI.this).setSelectedIndex(n);
        }

        protected EventHandler() {
        }
    }

    protected static class ScrollMenuSortAction
    extends ScrollMenuAction {
        public ScrollMenuSortAction() {
            super(ControlsArb.getString(6), "scrollMenuSorted");
        }
    }

    protected static class ScrollMenuShowVisibleAction
    extends ScrollMenuAction {
        public ScrollMenuShowVisibleAction() {
            super(ControlsArb.getString(7), "scrollMenuShowVisible");
        }
    }

    protected static class ScrollMenuAction
    extends ToggleAction {
        private String propertyName;

        public ScrollMenuAction(String string, String string2) {
            super(string, null);
            this.propertyName = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setState(this.getState() ^ true);
            if (this.propertyName != null) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
                JComponent jComponent = (JComponent)jPopupMenu.getInvoker();
                boolean bl = this.getState();
                boolean bl2 = bl ^ true;
                jComponent.firePropertyChange(this.propertyName, bl2, bl);
            }
        }

        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null && string == "SmallIcon") {
                return blankIcon;
            }
            return object;
        }
    }

    protected static class ScrollMenuItemComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            JMenuItem jMenuItem = (JMenuItem)object;
            JMenuItem jMenuItem2 = (JMenuItem)object2;
            return jMenuItem.getText().compareToIgnoreCase(jMenuItem2.getText());
        }

        protected ScrollMenuItemComparator() {
        }
    }
}

