/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import oracle.ide.controls.InterceptLookupTable;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;

public class SmallSquareButton
extends JButton
implements PropertyChangeListener,
MouseListener {
    private ArrayResourceBundle _bundle;
    private int _iconId;
    private int _disabledIconId;
    private boolean _rollover;
    private BufferedImage _image;
    private static HashMap _imageCache = new HashMap();

    void $init$() {
        this._iconId = -1;
        this._disabledIconId = -1;
    }

    public SmallSquareButton(ArrayResourceBundle arrayResourceBundle, int n, int n2) {
        this(arrayResourceBundle, n, arrayResourceBundle.getStringImpl(n2));
    }

    public SmallSquareButton(ArrayResourceBundle arrayResourceBundle, int n, String string) {
        this.$init$();
        this._bundle = arrayResourceBundle;
        this._iconId = n;
        this.init(string);
    }

    private void init(String string) {
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.setToolTipText(string);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(this);
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(null);
        this.setForeground(null);
    }

    public void addNotify() {
        super.addNotify();
        this.getParent().addPropertyChangeListener(this);
        this._image = null;
    }

    public void removeNotify() {
        this.getParent().removePropertyChangeListener(this);
        super.removeNotify();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._disabledIconId != -1) {
            this.whenIconChanges();
        }
    }

    public int getIconId() {
        return this._iconId;
    }

    public void setIconId(int n) {
        this._iconId = n;
        if (this.isEnabled() || this._disabledIconId == -1) {
            this.whenIconChanges();
        }
    }

    public int getDisabledIconId() {
        return this._disabledIconId == -1 ? this._iconId : this._disabledIconId;
    }

    public void setDisabledIconId(int n) {
        this._disabledIconId = n;
        if (!this.isEnabled()) {
            this.whenIconChanges();
        }
    }

    private void whenIconChanges() {
        this._image = null;
        this.repaint();
    }

    private void updateImage() {
        if (this._image == null) {
            this._image = this.getCachedImage();
        }
    }

    private void setBorder(boolean bl) {
        this._rollover = bl;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int n;
            int n2;
            this.updateImage();
            if (this._image != null) {
                n2 = this._image.getWidth();
                n = this._image.getHeight();
            } else {
                n = 0;
                n2 = 0;
            }
            Insets insets = this.getInsets();
            int n3 = Math.max(Math.max(n2 += insets.left + insets.right, n += insets.top + insets.bottom) + 2, 14);
            Dimension dimension = new Dimension(n3, n3);
            this.setPreferredSize(dimension);
        }
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setForeground(Color color) {
        if (ModelUtil.areDifferent((Object)color, (Object)this.getForeground())) {
            super.setForeground(color);
            this.whenIconChanges();
        }
    }

    protected void paintComponent(Graphics graphics) {
        this.updateImage();
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isOpaque()) {
            Color color = this.getBackground();
            graphics.setColor(color);
            graphics.fillRect(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
        }
        if (this._image != null) {
            int n3 = (n - this._image.getWidth(null)) / 2;
            int n4 = (n2 - this._image.getHeight(null)) / 2;
            int n5 = this.getModel().isPressed() ? 1 : 0;
            graphics.drawImage(this._image, n3 + n5, n4 + n5, null);
        }
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isEnabled() && (this._rollover || !this.isRolloverEnabled())) {
            Graphics graphics2 = graphics.create();
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = this.getForeground();
            graphics2.setColor(color);
            graphics2.drawLine(2, 0, n - 3, 0);
            graphics2.drawLine(0, 2, 0, n2 - 3);
            graphics2.drawLine(2, n2 - 1, n - 3, n2 - 1);
            graphics2.drawLine(n - 1, 2, n - 1, n2 - 3);
            Color color2 = SmallSquareButton.getCornerColor(color);
            graphics2.setColor(color2);
            graphics2.drawLine(0, 1, 1, 1);
            graphics2.drawLine(1, 0, 1, 1);
            graphics2.drawLine(n - 1, 1, n - 2, 1);
            graphics2.drawLine(n - 2, 0, n - 2, 1);
            graphics2.drawLine(n - 1, n2 - 2, n - 2, n2 - 2);
            graphics2.drawLine(n - 2, n2 - 1, n - 2, n2 - 2);
            graphics2.drawLine(0, n2 - 2, 1, n2 - 2);
            graphics2.drawLine(1, n2 - 1, 1, n2 - 2);
            graphics2.dispose();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setBorder(true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setBorder(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("background".equals(string) || "foreground".equals(string)) {
            this.whenIconChanges();
        }
    }

    private BufferedImage getCachedImage() {
        Image image;
        Color color;
        int n = this.isEnabled() ? this.getIconId() : this.getDisabledIconId();
        ImageCacheEntry imageCacheEntry = new ImageCacheEntry(this._bundle, n, color = this.getForeground());
        BufferedImage bufferedImage = (BufferedImage)_imageCache.get(imageCacheEntry);
        if (bufferedImage == null && (image = this._bundle.getImageImpl(n)) != null) {
            bufferedImage = SmallSquareButton.createImage(this, image, color);
            _imageCache.put(imageCacheEntry, bufferedImage);
        }
        return bufferedImage;
    }

    private static Color getCornerColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * 4 / 7);
    }

    private static BufferedImage createImage(SmallSquareButton smallSquareButton, Image image, Color color) {
        BufferedImage bufferedImage = SmallSquareButton.createBufferedImage(smallSquareButton, image);
        InterceptLookupTable interceptLookupTable = new InterceptLookupTable();
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()};
        interceptLookupTable.add(new int[]{0, 0, 0, 255}, nArray);
        LookupOp lookupOp = new LookupOp(interceptLookupTable, null);
        bufferedImage = lookupOp.filter(bufferedImage, null);
        return bufferedImage;
    }

    private static BufferedImage createBufferedImage(SmallSquareButton smallSquareButton, Image image) {
        BufferedImage bufferedImage;
        MediaTracker mediaTracker = new MediaTracker(smallSquareButton);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            bufferedImage = null;
        }
        if (mediaTracker.isErrorID(0)) {
            bufferedImage = null;
        }
        bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static class ImageCacheEntry {
        ArrayResourceBundle _bundle;
        int _iconID;
        Color _foregroundColor;

        public ImageCacheEntry(ArrayResourceBundle arrayResourceBundle, int n, Color color) {
            this._bundle = arrayResourceBundle;
            this._iconID = n;
            this._foregroundColor = color;
        }

        public int hashCode() {
            return this._bundle.hashCode() ^ this._iconID ^ this._foregroundColor.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ImageCacheEntry) {
                ImageCacheEntry imageCacheEntry = (ImageCacheEntry)object;
                if (this._bundle == imageCacheEntry._bundle && this._iconID == imageCacheEntry._iconID && this._foregroundColor.equals(imageCacheEntry._foregroundColor)) {
                    return true;
                }
            }
            return false;
        }
    }
}

