/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import oracle.ide.IdeConstants;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.ProgressTrackerControl;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.util.ModelUtil;
import oracle.javatools.border.JavatoolsBorderFactory;

public final class StatusBarControl
implements StatusBar {
    private JPanel _gui;
    private JLabel _label;
    private Toolbar _toolbar;
    private JDevStatusBar _statusBar;
    private ProgressTrackerControl _progressTrackerControl;

    void $init$() {
        this._statusBar = new JDevStatusBar();
    }

    public StatusBarControl() {
        this.$init$();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(JavatoolsBorderFactory.createTopBorder((Color)IdeConstants.COLOR_IDE_LINES), BorderFactory.createEmptyBorder(1, 0, 0, 0));
        this._progressTrackerControl = new ProgressTrackerControl();
        this._label = this._statusBar.add(" ");
        this._statusBar.setExpandable(this._label, true);
        this._statusBar.setItemResizeAllowed(false);
        this._gui = new JPanel();
        this._gui.setBorder(compoundBorder);
        this._gui.setLayout(new GridBagLayout());
        this._gui.add((Component)((Object)this._statusBar), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getText() {
        String string = this._label.getText();
        return string.equals(" ") ? "" : string;
    }

    public void setText(String string) {
        String string2 = ModelUtil.hasLength((String)string) ? string : " ";
        this._label.setText(string2);
    }

    public JComponent getGUI() {
        return this._gui;
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setBorder(null);
            this._gui.add((Component)this._toolbar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        }
        return this._toolbar;
    }

    public ProgressTracker getProgressTracker() {
        return this._progressTrackerControl;
    }

    public void add(JComponent jComponent) {
        this._statusBar.add(jComponent);
    }

    public void remove(JComponent jComponent) {
        this._statusBar.remove(jComponent);
    }

    public boolean isExpandable(JComponent jComponent) {
        return this._statusBar.isExpandable(jComponent);
    }

    public void setExpandable(JComponent jComponent, boolean bl) {
        this._statusBar.setExpandable(jComponent, bl);
    }

    public int getStatusCount() {
        return this._statusBar.getComponentCount() - 1;
    }

    public void resetStatus() {
        Component[] componentArray = this._statusBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] != this._label) {
                this._statusBar.remove(componentArray[n]);
            }
            ++n;
        }
    }

    public boolean containsStatusItem(JComponent jComponent) {
        Component[] componentArray = this._statusBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (jComponent == componentArray[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dispose() {
        if (this._toolbar != null) {
            this._toolbar.dispose();
        }
    }

    private static final class JDevStatusBar
    extends oracle.bali.ewt.statusBar.StatusBar {
        public JDevStatusBar() {
            super(1);
            this.setBorder(null);
        }

        public String getUIClassID() {
            return "oracle.ide.controls.StatusBarControlUI";
        }
    }
}

