/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.controls.TabbedWindowEvent;
import oracle.ide.controls.TabbedWindowListener;

public class TabbedWindow
extends JPanel {
    private JTabbedPane2 _tabbedPane;
    private List _pages;

    void $init$() {
        this._pages = new ArrayList();
    }

    public TabbedWindow() {
        this.$init$();
        this.setLayout(new BorderLayout());
    }

    public void add(String string, Icon icon, Component component, String string2, Object object) {
        int n = this._pages.size();
        switch (n) {
            case 0: {
                this.add(component, "Center");
                break;
            }
            case 1: {
                this.installTabbedPane();
                PageInfo pageInfo = (PageInfo)this._pages.get(0);
                this._tabbedPane.addTab(pageInfo._name, pageInfo._icon, pageInfo._gui, pageInfo._tooltip);
                this._tabbedPane.addTab(string, icon, component, string2);
                this._tabbedPane.revalidate();
                break;
            }
            default: {
                this._tabbedPane.addTab(string, icon, component, string2);
                this._tabbedPane.revalidate();
            }
        }
        this._pages.add(new PageInfo(string, icon, component, string2, object));
        this.setActive(component);
    }

    public void removeComponent(Component component) {
        int n = this._pages.size();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                PageInfo pageInfo = (PageInfo)this._pages.get(0);
                if (component != pageInfo._gui) break;
                this.remove(pageInfo._gui);
                this._pages.remove(0);
                break;
            }
            case 2: {
                int n2 = this._tabbedPane.indexOfComponent(component);
                if (n2 < 0) break;
                this._pages.remove(n2);
                this.uninstallTabbedPane();
                this.add(((PageInfo)this._pages.get((int)0))._gui, "Center");
                break;
            }
            default: {
                this.removeTab(component);
            }
        }
    }

    public void setActive(Component component) {
        if (this._tabbedPane == null || this._tabbedPane.getTabCount() == 0) {
            return;
        }
        int n = this._tabbedPane.indexOfComponent(component);
        if (n >= 0) {
            this._tabbedPane.setSelectedIndex(n);
        }
    }

    public Object getActiveData() {
        int n = 0;
        if (this._tabbedPane != null && this._tabbedPane.getTabCount() > 0 && (n = this._tabbedPane.getSelectedIndex()) < 0) {
            n = 0;
        }
        if (this._pages.size() > 0) {
            PageInfo pageInfo = (PageInfo)this._pages.get(n);
            return pageInfo._data;
        }
        return null;
    }

    public int getCount() {
        return this._pages.size();
    }

    public PageInfo[] getPages() {
        PageInfo[] pageInfoArray = new PageInfo[this.getCount()];
        return this._pages.toArray(pageInfoArray);
    }

    public void addTabbedWindowListener(TabbedWindowListener tabbedWindowListener) {
        this.listenerList.add(TabbedWindowListener.class, tabbedWindowListener);
    }

    public void removeTabbedWindowListener(TabbedWindowListener tabbedWindowListener) {
        this.listenerList.remove(TabbedWindowListener.class, tabbedWindowListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.getTabbedPane().addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.getTabbedPane().removeMouseListener(mouseListener);
    }

    private void fireTabbedWindowListener(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        TabbedWindowEvent tabbedWindowEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TabbedWindowListener.class) {
                if (tabbedWindowEvent == null) {
                    tabbedWindowEvent = new TabbedWindowEvent(this, object);
                }
                ((TabbedWindowListener)objectArray[n + 1]).activeChanged(tabbedWindowEvent);
            }
            n -= 2;
        }
    }

    private JTabbedPane getTabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JTabbedPane2(3);
            this._tabbedPane.setBorder(BorderFactory.createEmptyBorder());
            this._tabbedPane.setTabPlacement(1);
            this._tabbedPane.addChangeListener(new 1());
        }
        return this._tabbedPane;
    }

    private void uninstallTabbedPane() {
        this._tabbedPane.removeAll();
        this.remove(this._tabbedPane);
    }

    private void installTabbedPane() {
        this.add((Component)this.getTabbedPane(), "Center");
    }

    private void removeTab(Component component) {
        int n = this._tabbedPane.indexOfComponent(component);
        if (n >= 0) {
            this._tabbedPane.removeTabAt(n);
            this._pages.remove(n);
        }
        if (this._pages.size() == 1) {
            this.uninstallTabbedPane();
        }
    }

    static void mav$fireTabbedWindowListener(TabbedWindow tabbedWindow, Object object) {
        tabbedWindow.fireTabbedWindowListener(object);
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = TabbedWindow.this.getActiveData();
            if (object != null) {
                TabbedWindow.mav$fireTabbedWindowListener(TabbedWindow.this, TabbedWindow.this.getActiveData());
            }
        }
    }

    public static final class PageInfo {
        public final Component _gui;
        public final String _name;
        public final Icon _icon;
        public final String _tooltip;
        public final Object _data;

        public PageInfo(String string, Icon icon, Component component, String string2, Object object) {
            this._gui = component;
            this._name = string;
            this._icon = icon;
            this._tooltip = string2;
            this._data = object;
        }
    }
}

