/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.controls.KeyboardRedirector;
import oracle.ide.nulls.NullIcon;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;

public abstract class ToggleAction
extends AbstractAction {
    private final List _resolvers;
    public static final String ACTION = "Action";
    public static final String MNEMONIC = "MnemonicKey";
    public static final String ACCELERATOR = "Accelerator";
    public static final String USER_DATA = "UserData";
    public static final String DISABLED_ICON = "DisabledIcon";
    public static final String TOGGLES = "Check";
    public static final String RADIO = "Radio";
    public static final String STATE = "State";
    public static final String HIDDEN = "Hidden";
    public static final String BUTTON_GROUP_NAME = "RadioGroupName";
    public static final String ACTION_MENU_ACTIONS = "ActionMenuActions";
    public static final String MENU_WEIGHT = "menu-weight";
    public static final float MENU_WEIGHT_UNASSIGNED = Float.MAX_VALUE;
    public static final String CATEGORY = "Category";
    public static final String CONTEXT_INDEPENDENT_NAME = "NoCtxName";
    protected static final boolean PERFORM_ACTION_LATER = ToggleAction.shouldPerformLater();

    void $init$() {
        this._resolvers = new ArrayList();
    }

    public ToggleAction(String string, Icon icon) {
        super(StringUtils.stripMnemonic((String)string), icon);
        this.$init$();
    }

    public ToggleAction(String string, ResourceBundle resourceBundle, String string2) {
        this(string, null);
        if (resourceBundle != null && string2 != null) {
            this.addPropertyResolver(new ResourceBundleIconResolver(resourceBundle, string2, null));
        }
    }

    public ToggleAction(String string, ArrayResourceBundle arrayResourceBundle, int n) {
        this(string, null);
        if (arrayResourceBundle != null && n >= 0) {
            this.addPropertyResolver(new ArbIconResolver(arrayResourceBundle, n, null));
        }
    }

    protected ToggleAction(ToggleAction toggleAction) {
        this.$init$();
        if (toggleAction != null) {
            Object[] objectArray = toggleAction.getKeys();
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    String string = objectArray[n].toString();
                    this.putValue(string, toggleAction.getValue(string));
                    ++n;
                }
            }
            this._resolvers.addAll(toggleAction._resolvers);
        }
    }

    public final void addPropertyResolver(PropertyResolver propertyResolver) {
        if (propertyResolver == null) {
            throw new NullPointerException("resolver is null");
        }
        this._resolvers.add(0, propertyResolver);
    }

    public final void removePropertyResolver(PropertyResolver propertyResolver) {
        this._resolvers.remove(propertyResolver);
    }

    public boolean getState() {
        return this.getBooleanValue(STATE);
    }

    public void setState(boolean bl) {
        this.setBooleanValue(STATE, bl);
    }

    public boolean isToggle() {
        return this.getBooleanValue(TOGGLES);
    }

    public boolean isRadio() {
        return this.getBooleanValue(RADIO);
    }

    public boolean isActionMenu() {
        return this.getValue(ACTION_MENU_ACTIONS) != null;
    }

    public void setMenuWeight(float f) {
        this.putValue(MENU_WEIGHT, new Float(f));
    }

    public float getMenuWeight() {
        Object object = this.getValue(MENU_WEIGHT);
        if (object == null) {
            return Float.MAX_VALUE;
        }
        return ((Float)object).floatValue();
    }

    protected boolean getBooleanValue(String string) {
        Object object = this.getValue(string);
        return object instanceof Boolean && (Boolean)object != false;
    }

    protected void setBooleanValue(String string, boolean bl) {
        boolean bl2 = this.getBooleanValue(string);
        if (bl2 != bl) {
            this.putValue(string, bl);
        }
    }

    private Object getValueFromResolvers(String string) {
        Object object = null;
        for (PropertyResolver propertyResolver : this._resolvers) {
            object = propertyResolver.get(string);
            if (object == null) continue;
            return object;
        }
        return object;
    }

    public void listenForItemEvent(AbstractButton abstractButton) {
        abstractButton.addItemListener(new 1());
    }

    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null) {
            Icon icon;
            object = this.getValueFromResolvers(string);
            if (object != null) {
                this.putValue(string, object);
            }
            if (string == DISABLED_ICON && (icon = (Icon)this.getValue("SmallIcon")) instanceof ImageIcon) {
                object = GraphicsUtils.createImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
                this.putValue(string, object);
                return object;
            }
        }
        return object;
    }

    private static final boolean shouldPerformLater() {
        return false;
    }

    protected static final void freezeKeyboard(boolean bl) {
        if (JDK.HAS_BUG_BROKEN_TYPE_AHEAD) {
            KeyboardRedirector keyboardRedirector = KeyboardRedirector.getInstance();
            if (bl) {
                keyboardRedirector.freeze();
            } else {
                keyboardRedirector.thaw();
            }
        }
    }

    public final class oracle.ide.controls.ToggleAction$1
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                1 var4_4 = new 1(this, abstractButton);
                if (PERFORM_ACTION_LATER) {
                    SwingUtilities.invokeLater(var4_4);
                } else {
                    var4_4.run();
                }
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ AbstractButton v$button;
            final /* synthetic */ oracle.ide.controls.ToggleAction$1 this$0;

            public void run() {
                boolean bl = this.v$button.isSelected();
                if (this.this$0.ToggleAction.this.getState() != bl) {
                    this.this$0.ToggleAction.this.setState(bl);
                }
            }

            public 1(oracle.ide.controls.ToggleAction$1 var1_1, AbstractButton abstractButton) {
                this.v$button = abstractButton;
                this.this$0 = var1_1;
            }
        }
    }

    private static final class ResourceBundleIconResolver
    extends PropertyResolver {
        private ResourceBundle _bundle;
        private String _key;

        private ResourceBundleIconResolver(ResourceBundle resourceBundle, String string) {
            this._bundle = resourceBundle;
            this._key = string;
        }

        public Object get(String string) {
            if (this._bundle != null && "SmallIcon" == string) {
                try {
                    try {
                        URL uRL = this._bundle.getClass().getResource(this._key);
                        Icon icon = GraphicsUtils.createImageIcon(uRL);
                        if (icon == null) {
                            icon = new NullIcon();
                        }
                        ImageIcon imageIcon = icon;
                        this._bundle = null;
                        this._key = null;
                        return imageIcon;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        NullIcon nullIcon = new NullIcon();
                        this._bundle = null;
                        this._key = null;
                        return nullIcon;
                    }
                }
                catch (Throwable throwable) {
                    this._bundle = null;
                    this._key = null;
                    throw throwable;
                }
            }
            return null;
        }

        ResourceBundleIconResolver(ResourceBundle resourceBundle, String string, 1 var3_3) {
            this(resourceBundle, string);
        }

        public final class 1 {
        }
    }

    private static final class ArbIconResolver
    extends PropertyResolver {
        private ArrayResourceBundle _bundle;
        private final int _iconKey;

        private ArbIconResolver(ArrayResourceBundle arrayResourceBundle, int n) {
            this._bundle = arrayResourceBundle;
            this._iconKey = n;
        }

        public Object get(String string) {
            if (this._bundle != null && "SmallIcon" == string) {
                try {
                    try {
                        Icon icon = this._bundle.getIconImpl(this._iconKey);
                        this._bundle = null;
                        return icon;
                    }
                    catch (Exception exception) {
                        NullIcon nullIcon = new NullIcon();
                        this._bundle = null;
                        return nullIcon;
                    }
                }
                catch (Throwable throwable) {
                    this._bundle = null;
                    throw throwable;
                }
            }
            return null;
        }

        ArbIconResolver(ArrayResourceBundle arrayResourceBundle, int n, 1 var3_3) {
            this(arrayResourceBundle, n);
        }

        public final class 1 {
        }
    }
}

