/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.controls.PropertyChangeAdapter;

public class ToggleMenuItem
extends JCheckBoxMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;

    public ToggleMenuItem(ToggleAction toggleAction) {
        super(toggleAction);
        this.setSelected(toggleAction.getState());
        toggleAction.listenForItemEvent(this);
    }

    protected void configurePropertiesFromAction(Action action) {
        Integer n;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(action != null ? (String)action.getValue("Name") : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
        if (action != null && (n = (Integer)action.getValue("MnemonicKey")) != null) {
            this.setMnemonic(n);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new InnerPropertyChangeAdaptor(this, action);
    }

    public Icon getIcon() {
        Action action;
        if (!this.checkedForIcon && (action = this.getAction()) != null) {
            this.checkedForIcon = true;
            this.setIcon((Icon)action.getValue("SmallIcon"));
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        Action action;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (action = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)action.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public static Icon getCheckBoxMenuItemIcon() {
        return UIManager.getIcon("CheckBoxMenuItem.checkIcon");
    }

    public MenuElement[] getSubElements() {
        return MenuItem.EMPTY_MENU_ELEMENTS;
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        public InnerPropertyChangeAdaptor(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }

        protected void stateChanged(PropertyChangeEvent propertyChangeEvent) {
            ToggleMenuItem toggleMenuItem = (ToggleMenuItem)this.getAdaptee();
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            if (toggleMenuItem.isSelected() != bl.booleanValue()) {
                toggleMenuItem.setState(bl);
            }
        }
    }
}

