/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyUtil;
import oracle.javatools.controls.PropertyChangeAdapter;

public class ToolButton
extends JButton {
    protected static final String uiClassID = "ToolButtonUI";
    protected JPopupMenu popup;
    private boolean iconVisible;
    private boolean menuStyle;
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;
    private boolean painting;
    private PopupMenuListener popupMenuListener;

    void $init$() {
        this.iconVisible = true;
    }

    public ToolButton(Action action) {
        super((Action)null);
        this.$init$();
        this.putClientProperty("hideActionText", Boolean.TRUE);
        this.setHorizontalAlignment(0);
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setAction(action);
    }

    public static String buildToolTip(Action action) {
        if (action == null) {
            return null;
        }
        String string = (String)action.getValue("ShortDescription");
        if (string == null || string.length() == 0) {
            string = (String)action.getValue("Name");
        }
        if (string != null && string.length() > 0) {
            if (action instanceof IdeAction) {
                int n = ((IdeAction)action).getCommandId();
                String string2 = KeyUtil.getAcceleratorTooltip(n);
                if (string2 != null && string2.length() != 0) {
                    string = string + " (" + string2 + ")";
                }
            } else {
                KeyStroke keyStroke = (KeyStroke)action.getValue("Accelerator");
                if (keyStroke != null) {
                    StringBuffer stringBuffer = new StringBuffer(20);
                    stringBuffer.append(" (");
                    String string3 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
                    if (string3 != null && string3.length() > 0) {
                        stringBuffer.append(string3);
                        stringBuffer.append("+");
                    }
                    stringBuffer.append(KeyEvent.getKeyText(keyStroke.getKeyCode()));
                    stringBuffer.append(")");
                    string = string + stringBuffer;
                }
            }
        }
        return string;
    }

    public JMenuItem addPopupItem(String string) {
        JMenuItem jMenuItem;
        if (this.popup == null) {
            this.createPopupMenu();
        }
        if ((jMenuItem = this._findPopupItem(string)) == null) {
            jMenuItem = this.popup.add(string);
            this.layoutToolbar();
        }
        return jMenuItem;
    }

    public void removePopupItem(String string) {
        JMenuItem jMenuItem = this._findPopupItem(string);
        if (jMenuItem != null) {
            this.popup.remove(jMenuItem);
            this.layoutToolbar();
        }
    }

    public JMenuItem findPopupItem(String string) {
        return this._findPopupItem(string);
    }

    public final void setLabelVisible(boolean bl) {
        this.putClientProperty("hideActionText", bl);
        this.repaint();
    }

    public final boolean getLabelVisible() {
        return ToolButton.isLabelVisible(this);
    }

    public final void setIconVisible(boolean bl) {
        if (bl == this.iconVisible) {
            return;
        }
        this.iconVisible = bl;
        Icon icon = this.getIcon();
        if (icon != null) {
            this.setIcon(icon);
            this.setPressedIcon(icon);
            this.setSelectedIcon(icon);
        }
    }

    public final boolean getIconVisible() {
        return this.iconVisible;
    }

    public void setMenuStyle(boolean bl) {
        this.menuStyle = bl;
    }

    public boolean isMenuStyle() {
        return this.menuStyle;
    }

    protected void init() {
    }

    protected JPopupMenu createPopupMenu() {
        if (this.popup != null) {
            this.releasePopupMenu();
        }
        this.popup = new JPopupMenu();
        this.popupMenuListener = new ButtonPopupMenuListener(this);
        this.popup.addPopupMenuListener(this.popupMenuListener);
        this.invalidate();
        return this.popup;
    }

    protected void releasePopupMenu() {
        if (this.popup != null && this.popupMenuListener != null) {
            this.popup.removePopupMenuListener(this.popupMenuListener);
        }
        this.popup = null;
        this.invalidate();
    }

    protected static boolean isLabelVisible(AbstractButton abstractButton) {
        Boolean bl = (Boolean)abstractButton.getClientProperty("hideActionText");
        return bl == null || bl != Boolean.TRUE;
    }

    Toolbar getToolbar() {
        Container container = this.getParent();
        return container instanceof Toolbar ? (Toolbar)container : null;
    }

    boolean hasPopup() {
        return this.popup != null;
    }

    boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    void togglePopup() {
        if (this.popup == null) {
            return;
        }
        if (!this.popup.isVisible()) {
            MenuUtils.showPopupMenu((JPopupMenu)this.popup, (Component)this, (int)0, (int)this.getHeight());
        } else {
            this.popup.setVisible(false);
        }
    }

    private JMenuItem _findPopupItem(String string) {
        if (this.popup != null) {
            MenuElement[] menuElementArray = this.popup.getSubElements();
            int n = 0;
            while (n < menuElementArray.length) {
                JMenuItem jMenuItem;
                Component component = menuElementArray[n].getComponent();
                if (component instanceof JMenuItem && (jMenuItem = (JMenuItem)component).getText().equals(string)) {
                    return jMenuItem;
                }
                ++n;
            }
        }
        return null;
    }

    protected final void layoutToolbar() {
        Toolbar toolbar = this.getToolbar();
        if (toolbar != null) {
            toolbar.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.popup != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(action != null && ToolButton.isLabelVisible(this) ? (String)action.getValue("Name") : null);
        this.setToolTipText(action != null ? ToolButton.buildToolTip(action) : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new DefaultActionPropertyChangeListener(this, action);
    }

    public Icon getIcon() {
        if (!this.checkedForIcon) {
            Action action = this.getAction();
            this.checkedForIcon = true;
            this.setIcon(action != null ? (Icon)action.getValue("SmallIcon") : null);
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon) {
            Action action = this.getAction();
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)action.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public void repaint() {
        if (this.painting) {
            return;
        }
        super.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        this.painting = true;
        super.paintComponent(graphics);
        this.painting = false;
    }

    protected static class DefaultActionPropertyChangeListener
    extends PropertyChangeAdapter {
        public DefaultActionPropertyChangeListener(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }

        protected void nameChanged(PropertyChangeEvent propertyChangeEvent) {
            AbstractButton abstractButton = this.getAdaptee();
            if (ToolButton.isLabelVisible(abstractButton)) {
                abstractButton.setText((String)propertyChangeEvent.getNewValue());
            }
            this.tooltipChanged(propertyChangeEvent);
        }

        protected void tooltipChanged(PropertyChangeEvent propertyChangeEvent) {
            AbstractButton abstractButton = this.getAdaptee();
            abstractButton.setToolTipText(ToolButton.buildToolTip(abstractButton.getAction()));
        }
    }

    private static final class ButtonPopupMenuListener
    implements PopupMenuListener {
        ToolButton button;

        ButtonPopupMenuListener(ToolButton toolButton) {
            this.button = toolButton;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.updateForPopup(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.updateForPopup(false);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        private void updateForPopup(boolean bl) {
            1 var2_2 = new 1(this, bl);
            SwingUtilities.invokeLater(var2_2);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$visible;
            final /* synthetic */ ButtonPopupMenuListener this$0;

            public void run() {
                ButtonModel buttonModel = this.this$0.button.getModel();
                if (this.this$0.button.isMenuStyle()) {
                    buttonModel.setPressed(this.v$visible);
                }
                buttonModel.setRollover(false);
                Toolbar toolbar = this.this$0.button.getToolbar();
                if (toolbar != null) {
                    toolbar.setOver(null);
                }
                this.this$0.button.repaint();
            }

            public 1(ButtonPopupMenuListener buttonPopupMenuListener, boolean bl) {
                this.v$visible = bl;
                this.this$0 = buttonPopupMenuListener;
            }
        }
    }
}

