/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;

public class ToolButtonUI
extends BasicButtonUI {
    private static final ToolButtonUI toolButtonUI = new ToolButtonUI();
    static final Icon popupIndicator = MenuToolButton.POPUP_ICON;
    static final int POPUP_WIDTH = 14;
    static final String propertyPrefix = "ToolButton.";
    private boolean inPaintIcon;

    public static ComponentUI createUI(JComponent jComponent) {
        return toolButtonUI;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        ToolButton toolButton = (ToolButton)jComponent;
        Dimension dimension = ToolButtonUI.getToolbarButtonPreferredSize(toolButton, this.defaultTextIconGap);
        if (toolButton.hasPopup()) {
            dimension.width = toolButton.isMenuStyle() ? (dimension.width += popupIndicator.getIconWidth() + 1) : (dimension.width += 14);
        }
        return dimension;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ToolButton toolButton = (ToolButton)jComponent;
        super.paint(graphics, jComponent);
        if (toolButton.hasPopup()) {
            int n;
            int n2;
            if (toolButton.isMenuStyle()) {
                n2 = this.getTextShiftOffset();
                n = toolButton.getWidth() - popupIndicator.getIconWidth() - 3 + n2;
            } else {
                n2 = toolButton.isPopupVisible() ? this.defaultTextShiftOffset : this.getTextShiftOffset();
                n = toolButton.getWidth() - (14 + popupIndicator.getIconWidth() + 2) / 2 + n2;
            }
            int n3 = (toolButton.getHeight() - popupIndicator.getIconHeight()) / 2 + n2;
            popupIndicator.paintIcon(toolButton, graphics, n, n3);
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new ToolButtonListener(abstractButton, null);
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        ToolButton toolButton = (ToolButton)jComponent;
        rectangle.x += ToolButtonUI.getPopupXShift(toolButton);
        this.inPaintIcon = true;
        super.paintIcon(graphics, jComponent, rectangle);
        this.inPaintIcon = false;
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        ToolButton toolButton = (ToolButton)jComponent;
        rectangle.x += ToolButtonUI.getPopupXShift(toolButton);
        super.paintText(graphics, jComponent, rectangle, string);
    }

    protected void clearTextShiftOffset() {
        if (!this.inPaintIcon) {
            super.clearTextShiftOffset();
        }
    }

    protected static Dimension getToolbarButtonPreferredSize(AbstractButton abstractButton, int n) {
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, n);
        Container container = abstractButton.getParent();
        if (container != null) {
            Insets insets = container.getInsets();
            int n2 = container.getHeight() - (insets.top + insets.bottom);
            if (dimension.height < n2) {
                dimension.height = n2;
            }
        }
        if (dimension.width != dimension.height) {
            dimension.width = dimension.height = Math.max(dimension.width, dimension.height);
        }
        return dimension;
    }

    private static int getPopupXShift(ToolButton toolButton) {
        if (toolButton.hasPopup()) {
            if (toolButton.isMenuStyle()) {
                return -popupIndicator.getIconWidth() / 2 - 1;
            }
            return -7;
        }
        return 0;
    }

    private final class ToolButtonListener
    extends BasicButtonListener {
        private ToolButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ToolButton toolButton = (ToolButton)mouseEvent.getComponent();
            Toolbar toolbar = toolButton.getToolbar();
            if (toolbar != null) {
                ToolButton toolButton2 = toolbar.getOver();
                if (toolButton2 != null && toolButton2.isPopupVisible()) {
                    toolButton2.togglePopup();
                    if (toolButton != toolButton2) {
                        toolButton2.getModel().setRollover(false);
                        toolbar.setOver(null);
                        this.mouseEntered(mouseEvent);
                    }
                    return;
                }
                toolbar.setTrack(toolButton);
            }
            ButtonModel buttonModel = toolButton.getModel();
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && toolButton.hasPopup() && buttonModel.isEnabled() && (toolButton.isMenuStyle() || mouseEvent.getX() > toolButton.getWidth() - 14)) {
                toolButton.togglePopup();
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ToolButton toolButton = (ToolButton)mouseEvent.getComponent();
            Toolbar toolbar = toolButton.getToolbar();
            if (toolbar != null) {
                toolbar.setTrack(null);
            }
            if (!toolButton.isMenuStyle()) {
                super.mouseReleased(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ToolButton toolButton = (ToolButton)mouseEvent.getComponent();
            Toolbar toolbar = toolButton.getToolbar();
            if (toolbar != null && toolbar.getOver() == null) {
                toolbar.setOver(toolButton);
                ToolButton toolButton2 = toolbar.getTrack();
                if (toolButton2 == null || toolButton == toolButton2) {
                    super.mouseEntered(mouseEvent);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ToolButton toolButton;
            ToolButton toolButton2 = (ToolButton)mouseEvent.getComponent();
            Toolbar toolbar = toolButton2.getToolbar();
            if (toolbar != null && (toolButton = toolbar.getOver()) != null && !toolButton.isPopupVisible()) {
                toolbar.setOver(null);
                ToolButton toolButton3 = toolbar.getTrack();
                if (toolButton3 == null || toolButton2 == toolButton3) {
                    super.mouseExited(mouseEvent);
                }
            }
        }

        ToolButtonListener(AbstractButton abstractButton, 1 var3_3) {
            this(abstractButton);
        }

        public final class 1 {
        }
    }
}

