/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.RadioToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleToolButton;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.ToolbarGroup;
import oracle.ide.controls.ToolbarItem;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.util.GraphicsUtils;

public class Toolbar
extends JToolBar {
    private ToolButton _trackButton;
    private ToolButton _overButton;
    private Action[] _actions;
    private ChangeListener _changeListener;

    public Toolbar(JFrame jFrame, Border border) {
        this();
        if (jFrame != null) {
            Container container = jFrame.getContentPane();
            container.add((Component)this, "North");
        }
        if (border != null) {
            this.setBorder(border);
        }
    }

    public Toolbar(JFrame jFrame) {
        this(jFrame, BorderFactory.createEtchedBorder());
    }

    public Toolbar() {
        this.setFloatable(false);
        this.setRollover(true);
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        this._changeListener = new 1();
        keyStrokeOptions.addChangeListener(this._changeListener);
    }

    public final ToolButton add(ToggleAction toggleAction) {
        ToolButton toolButton = new ToolButton(toggleAction);
        this.add(toolButton);
        return toolButton;
    }

    public final ToggleToolButton addToggleButton(ToggleAction toggleAction) {
        ToggleToolButton toggleToolButton = new ToggleToolButton(toggleAction);
        this.add(toggleToolButton);
        return toggleToolButton;
    }

    public final RadioToolButton addRadioButton(ToggleAction toggleAction, ButtonGroup buttonGroup) {
        RadioToolButton radioToolButton = new RadioToolButton(toggleAction);
        this.add(radioToolButton);
        buttonGroup.add(radioToolButton);
        return radioToolButton;
    }

    public final MenuToolButton addMenuButton(ToggleAction[] toggleActionArray) {
        MenuToolButton menuToolButton = new MenuToolButton(toggleActionArray);
        this.add(menuToolButton);
        return menuToolButton;
    }

    public final ActionMenuToolButton addActionMenuButton(Action action) {
        ActionMenuToolButton actionMenuToolButton = new ActionMenuToolButton(action);
        this.add(actionMenuToolButton);
        return actionMenuToolButton;
    }

    public final JToolBar.Separator newSeparator() {
        JToolBar.Separator separator = new JToolBar.Separator();
        separator.setOrientation(this.getOrientation() == 1 ? 0 : 1);
        separator.setMinimumSize(separator.getPreferredSize());
        return separator;
    }

    public final void addSeparator() {
        this.add(this.newSeparator());
    }

    public final void addFiller() {
        Component component = this.getOrientation() == 0 ? Box.createHorizontalStrut(6) : Box.createVerticalStrut(6);
        this.add(component);
    }

    public Component addComponent(Component component, int n) {
        return this.add(component, n);
    }

    public void setLabelVisible(boolean bl) {
        int n = this.getComponentCount();
        while (n-- > 0) {
            Component component = this.getComponent(n);
            if (!(component instanceof ToolButton)) continue;
            ToolButton toolButton = (ToolButton)component;
            toolButton.putClientProperty("hideActionText", bl);
            toolButton.repaint();
        }
        this.validate();
    }

    public boolean isLabelVisible() {
        return false;
    }

    public Action[] getActions() {
        if (this._actions != null) {
            return this._actions;
        }
        int n = this.getComponentCount();
        ArrayList<Action> arrayList = new ArrayList<Action>(n);
        int n2 = n;
        while (n2-- > 0) {
            Component component = this.getComponent(n2);
            if (component instanceof ToolbarGroup) {
                Action[] actionArray = ((ToolbarGroup)((Object)component)).getActions();
                int n3 = 0;
                while (n3 < actionArray.length) {
                    arrayList.add(actionArray[n3]);
                    ++n3;
                }
                continue;
            }
            if (component instanceof ToolbarItem) {
                arrayList.add(((ToolbarItem)((Object)component)).getAction());
                continue;
            }
            if (!(component instanceof AbstractButton)) continue;
            arrayList.add(((AbstractButton)component).getAction());
        }
        this._actions = arrayList.toArray(new Action[arrayList.size()]);
        return this._actions;
    }

    public void dispose() {
        if (this._changeListener != null) {
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.removeChangeListener(this._changeListener);
            this._changeListener = null;
        }
        Toolbar.disposeImpl(this);
    }

    public void remove(Component component) {
        this._actions = null;
        super.remove(component);
    }

    public void remove(int n) {
        this._actions = null;
        super.remove(n);
    }

    public void removeAll() {
        this._actions = null;
        super.removeAll();
    }

    protected void addImpl(Component component, Object object, int n) {
        this._actions = null;
        super.addImpl(component, object, n);
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            abstractButton.setOpaque(false);
        }
    }

    void setTrack(ToolButton toolButton) {
        if (toolButton == null) {
            if (this._trackButton != null) {
                this._trackButton.repaint();
            }
            if (this._overButton != null && this._trackButton != this._overButton) {
                this._overButton.getModel().setRollover(true);
            }
        }
        this._trackButton = toolButton;
    }

    ToolButton getTrack() {
        return this._trackButton;
    }

    void setOver(ToolButton toolButton) {
        this._overButton = toolButton;
    }

    ToolButton getOver() {
        return this._overButton;
    }

    private static void disposeImpl(Component component) {
        AbstractButton abstractButton;
        Action action;
        if (component instanceof AbstractButton && (action = (abstractButton = (AbstractButton)component).getAction()) != null) {
            abstractButton.setAction(null);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            while (n-- > 0) {
                Toolbar.disposeImpl(container.getComponent(n));
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        FocusTraversalPolicy focusTraversalPolicy;
        Component component;
        Container container;
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 501 && (container = this.getFocusCycleRootAncestor()) != null && !GraphicsUtils.isAncestorOfFocusedComponent(container) && (component = (focusTraversalPolicy = container.getFocusTraversalPolicy()).getComponentAfter(container, this)) != null) {
            component.requestFocus();
        }
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n = Toolbar.this.getComponentCount();
            while (n-- > 0) {
                Component component = Toolbar.this.getComponent(n);
                if (!(component instanceof AbstractButton)) continue;
                AbstractButton abstractButton = (AbstractButton)component;
                abstractButton.setToolTipText(ToolButton.buildToolTip(abstractButton.getAction()));
            }
        }
    }
}

