/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.layout.IdeProperties;

public class TreeAutoExpander {
    private static Boolean ENABLED;
    private Listeners _listeners;
    private JTree _tree;
    private TreePath _expandedPath;
    private boolean _inputEvent;
    private TreeModel _model;

    public static void install(JTree jTree) {
        if (TreeAutoExpander.isEnabled()) {
            new TreeAutoExpander(jTree);
        }
    }

    private static boolean isEnabled() {
        if (ENABLED == null) {
            IdeProperties ideProperties = Ide.getIdeProperties();
            String string = ideProperties.getProperty("TreeAutoExpander.Enabled", Boolean.TRUE.toString());
            ENABLED = Boolean.valueOf(string);
        }
        return ENABLED;
    }

    private TreeAutoExpander(JTree jTree) {
        this._tree = jTree;
        this._listeners = new Listeners(null);
        jTree.addMouseListener(this._listeners);
        jTree.addKeyListener(this._listeners);
        jTree.addTreeExpansionListener(this._listeners);
    }

    private void reset() {
        this._inputEvent = false;
        this._expandedPath = null;
    }

    private void whenTreeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this._expandedPath = treeExpansionEvent.getPath();
        if (this._inputEvent) {
            this.expandLastPath();
        } else {
            this.whenOneConditionMet();
        }
    }

    private void whenInputEvent() {
        if (this._expandedPath != null) {
            this.expandLastPath();
        } else {
            this._inputEvent = true;
            this.whenOneConditionMet();
        }
    }

    private void whenOneConditionMet() {
        TreeModel treeModel = this._tree.getModel();
        if (treeModel != this._model) {
            this.setModel(treeModel);
            this.reset();
        } else {
            SwingUtilities.invokeLater(this._listeners);
        }
    }

    private void setModel(TreeModel treeModel) {
        if (this._model != null) {
            this._model.removeTreeModelListener(this._listeners);
        }
        this._model = treeModel;
        if (this._model != null) {
            this._model.addTreeModelListener(this._listeners);
        }
    }

    private void expandLastPath() {
        TreeAutoExpander.expandPath(this._tree, this._expandedPath);
        this.reset();
    }

    private static void expandPath(JTree jTree, TreePath treePath) {
        Object object;
        int n;
        TreeModel treeModel = jTree.getModel();
        while ((n = treeModel.getChildCount(object = treePath.getLastPathComponent())) == 1) {
            Object object2 = treeModel.getChild(object, 0);
            if (jTree.isExpanded(treePath = treePath.pathByAddingChild(object2))) continue;
            jTree.expandPath(treePath);
            break;
        }
    }

    static void mav$reset(TreeAutoExpander treeAutoExpander) {
        treeAutoExpander.reset();
    }

    static void mav$whenInputEvent(TreeAutoExpander treeAutoExpander) {
        treeAutoExpander.whenInputEvent();
    }

    static void mav$whenTreeExpanded(TreeAutoExpander treeAutoExpander, TreeExpansionEvent treeExpansionEvent) {
        treeAutoExpander.whenTreeExpanded(treeExpansionEvent);
    }

    private class Listeners
    implements KeyListener,
    TreeModelListener,
    Runnable,
    MouseListener,
    TreeExpansionListener {
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreeAutoExpander.mav$whenTreeExpanded(TreeAutoExpander.this, treeExpansionEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void keyReleased(KeyEvent keyEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void keyTyped(KeyEvent keyEvent) {
            TreeAutoExpander.mav$whenInputEvent(TreeAutoExpander.this);
        }

        public void run() {
            TreeAutoExpander.mav$reset(TreeAutoExpander.this);
        }

        private Listeners() {
        }

        Listeners(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

