/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JTextField;
import oracle.ide.component.URLPathEditPanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;

public class URLPathField
extends JTextField
implements ActionListener {
    private JButton _btn;
    private String _title;
    private boolean _browseToAnyURLAllowed;
    private String _helpContext;
    private boolean _passEnableActionOn;
    private HashMap _entryMap;
    private boolean _allowJars;
    private static final String DEFAULT_HELP_ID = "f1_idededitpath_html";
    private static final String DEFAULT_VIEW_HELP_ID = "f1_idedviewpath_html";

    void $init$() {
        this._browseToAnyURLAllowed = false;
        this._helpContext = DEFAULT_HELP_ID;
        this._passEnableActionOn = false;
        this._entryMap = new HashMap();
        this._allowJars = true;
    }

    public URLPathField() {
        this.$init$();
    }

    public URLPathField(URLPath uRLPath) {
        this();
        this.setURLPath(uRLPath);
    }

    public void setURLPath(URLPath uRLPath) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        this._entryMap.clear();
        if (uRLPath != null) {
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                String string = URLFileSystem.getPlatformPathName(uRLArray[n]);
                fastStringBuffer.append(string);
                this._entryMap.put(string, uRLArray[n]);
                fastStringBuffer.append(';');
                ++n;
            }
        }
        if (fastStringBuffer.getLength() > 0) {
            fastStringBuffer.setLength(fastStringBuffer.getLength() - 1);
        }
        this.setText(fastStringBuffer.toString());
    }

    public URLPath getURLPath() throws BadEntryException {
        URLPath uRLPath = new URLPath();
        String string = this.getText();
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                URL uRL = (URL)this._entryMap.get(string2);
                if (uRL == null) {
                    String string3 = string2;
                    String string4 = null;
                    String string5 = "!" + File.separator;
                    int n = string2.indexOf(string5);
                    if (n > 0) {
                        string3 = string2.substring(0, n);
                        string4 = string2.substring(n + string5.length());
                        if (File.separatorChar != '/') {
                            string4 = string4.replace(File.separatorChar, '/');
                        }
                    } else {
                        String string6;
                        n = string2.lastIndexOf(46);
                        if (n >= 0 && ("zip".equals(string6 = string2.substring(n + 1).toLowerCase()) || "jar".equals(string6))) {
                            string4 = "";
                        }
                    }
                    try {
                        uRL = new URL(string3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = URLFactory.newFileURL(string3);
                    }
                    uRL = string4 != null ? URLFactory.newJarURL(uRL, string4) : URLFactory.newURL(uRL, "");
                    if (uRL == null) {
                        throw new BadEntryException(this, string2);
                    }
                    uRL = URLFileSystem.canonicalize(uRL);
                }
                uRLPath.add(uRL);
            }
        }
        return uRLPath;
    }

    public void setButtonAssociation(JButton jButton, boolean bl) {
        this._btn = jButton;
        this._passEnableActionOn = bl;
    }

    public void setButton(JButton jButton) {
        if (this._btn != null) {
            this._btn.removeActionListener(this);
        }
        this._btn = jButton;
        if (this._btn != null) {
            this._btn.addActionListener(this);
        }
    }

    public void setEditTitle(String string) {
        this._title = string;
    }

    public void setHelpContext(String string) {
        this._helpContext = string;
    }

    public void setBrowseToAnyURLAllowed(boolean bl) {
        this._browseToAnyURLAllowed = bl;
    }

    public boolean isBrowseToAnyURLAllowed() {
        return this._browseToAnyURLAllowed;
    }

    public void setJarPathsAllowed(boolean bl) {
        this._allowJars = bl;
    }

    public boolean isJarPathsAllowed() {
        return this._allowJars;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this._btn != null && this._passEnableActionOn) {
            this._btn.setEnabled(bl);
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.isEditable()) {
                URLPath uRLPath = URLPathEditPanel.editPath(this, ControlsArb.format(8, this._title), this.getURLPath(), this._browseToAnyURLAllowed, this._allowJars, this._helpContext);
                if (uRLPath != null) {
                    this.setURLPath(uRLPath);
                }
            } else {
                URLPathEditPanel.viewPath(this, ControlsArb.format(9, this._title), this.getURLPath(), ModelUtil.areEqual((Object)this._helpContext, (Object)DEFAULT_HELP_ID) ? DEFAULT_VIEW_HELP_ID : this._helpContext);
            }
        }
        catch (BadEntryException badEntryException) {
            // empty catch block
        }
    }

    public static class BadEntryException
    extends Exception {
        private String _entry;
        private URLPathField _source;

        BadEntryException(URLPathField uRLPathField, String string) {
            this._source = uRLPathField;
            this._entry = string;
        }

        public String getBadEntry() {
            return this._entry;
        }

        public URLPathField getSource() {
            return this._source;
        }
    }
}

