/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.Serializable;

public class VerticalFlowLayout
extends FlowLayout
implements Serializable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    int hgap;
    int vgap;
    boolean hfill;
    boolean vfill;

    public VerticalFlowLayout() {
        this(0, 5, 5, true, false);
    }

    public VerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n) {
        this(n, 5, 5, true, false);
    }

    public VerticalFlowLayout(int n, boolean bl, boolean bl2) {
        this(n, 5, 5, bl, bl2);
    }

    public VerticalFlowLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setAlignment(n);
        this.hgap = n2;
        this.vgap = n3;
        this.hfill = bl;
        this.vfill = bl2;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component.isVisible()) {
                Dimension dimension2 = component.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n > 0) {
                    dimension.height += this.hgap;
                }
                dimension.height += dimension2.height;
            }
            ++n;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component = container.getComponent(n);
            if (component.isVisible()) {
                Dimension dimension2 = component.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension2.width);
                if (n > 0) {
                    dimension.height += this.vgap;
                }
                dimension.height += dimension2.height;
            }
            ++n;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + this.hgap * 2;
        dimension.height += insets.top + insets.bottom + this.vgap * 2;
        return dimension;
    }

    public void setVerticalFill(boolean bl) {
        this.vfill = bl;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public void setHorizontalFill(boolean bl) {
        this.hfill = bl;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    private void placethem(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getAlignment();
        if (n7 == 1) {
            n2 += n4 / 2;
        }
        if (n7 == 2) {
            n2 += n4;
        }
        int n8 = n5;
        while (n8 < n6) {
            Component component = container.getComponent(n8);
            Dimension dimension = component.getSize();
            if (component.isVisible()) {
                int n9 = n + (n3 - dimension.width) / 2;
                component.setLocation(n9, n2);
                n2 += this.vgap + dimension.height;
            }
            ++n8;
        }
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
        int n2 = container.getSize().width - (insets.left + insets.right + this.hgap * 2);
        int n3 = container.getComponentCount();
        int n4 = insets.left + this.hgap;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n3) {
            Component component = container.getComponent(n8);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (this.vfill && n8 == n3 - 1) {
                    dimension.height = Math.max(n - n5, component.getPreferredSize().height);
                }
                if (this.hfill) {
                    component.setSize(n2, dimension.height);
                    dimension.width = n2;
                } else {
                    component.setSize(dimension.width, dimension.height);
                }
                if (n5 + dimension.height > n) {
                    this.placethem(container, n4, insets.top + this.vgap, n6, n - n5, n7, n8);
                    n5 = dimension.height;
                    n4 += this.hgap + n6;
                    n6 = dimension.width;
                    n7 = n8;
                } else {
                    if (n5 > 0) {
                        n5 += this.vgap;
                    }
                    n5 += dimension.height;
                    n6 = Math.max(n6, dimension.width);
                }
            }
            ++n8;
        }
        this.placethem(container, n4, insets.top + this.vgap, n6, n - n5, n7, n3);
    }
}

