/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import oracle.javatools.util.NamedTimer;

public class WaitCursor {
    private static final boolean CHECK_THREAD = false;
    private static Object LOCK;
    private static final long DEFAULT_DELAY = 500L;
    private static final Timer TIMER;
    private static final MouseAdapter BEEPER;
    private ArrayList _glassPanes;
    private int _waitCount;
    private TimerTask _timerTask;

    static {
        TIMER = new NamedTimer("WaitCursorTimer", 5, true);
        BEEPER = new 2();
    }

    void $init$() {
        this._glassPanes = new ArrayList(1);
        this._waitCount = 0;
    }

    public WaitCursor() {
        this.$init$();
    }

    public WaitCursor(Component component) {
        this.$init$();
        if (component != null) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
            this.attach(rootPaneContainer);
        }
    }

    public void attach(RootPaneContainer rootPaneContainer) {
        if (rootPaneContainer != null) {
            Component component;
            if (LOCK == null) {
                LOCK = rootPaneContainer.getContentPane().getTreeLock();
            }
            if ((component = rootPaneContainer.getGlassPane()) != null) {
                this._glassPanes.add(component);
            }
        }
    }

    public void detach(RootPaneContainer rootPaneContainer) {
        Component component;
        if (rootPaneContainer != null && this._glassPanes.contains(component = rootPaneContainer.getGlassPane())) {
            this.setWaitCursor(component, false);
            this._glassPanes.remove(component);
        }
    }

    public void show() {
        this.show(500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(long l) {
        if (WaitCursor.checkThread()) {
            Object object = this.getLockObject();
            synchronized (object) {
                if (this._waitCount++ == 0) {
                    if (l > 0L) {
                        this._timerTask = new 1();
                        TIMER.schedule(this._timerTask, l);
                    } else {
                        this.setWaitCursor(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        if (WaitCursor.checkThread()) {
            Object object = this.getLockObject();
            synchronized (object) {
                if (this._waitCount > 0) {
                    --this._waitCount;
                    if (this._waitCount == 0) {
                        if (this._timerTask != null) {
                            this._timerTask.cancel();
                            this._timerTask = null;
                        } else {
                            this.setWaitCursor(false);
                        }
                    }
                }
            }
        }
    }

    private void setWaitCursor(boolean bl) {
        int n = this._glassPanes.size();
        Component[] componentArray = new Component[n];
        this._glassPanes.toArray(componentArray);
        int n2 = 0;
        while (n2 < n) {
            this.setWaitCursor(componentArray[n2], bl);
            ++n2;
        }
    }

    private void setWaitCursor(Component component, boolean bl) {
        int n = bl ? 3 : 0;
        Cursor cursor = Cursor.getPredefinedCursor(n);
        component.setCursor(cursor);
        component.setVisible(bl);
        if (bl) {
            component.addMouseListener(BEEPER);
        } else {
            component.removeMouseListener(BEEPER);
        }
    }

    private static boolean checkThread() {
        return true;
    }

    private Object getLockObject() {
        return LOCK != null ? LOCK : this;
    }

    static Object mav$getLockObject(WaitCursor waitCursor) {
        return waitCursor.getLockObject();
    }

    static TimerTask ra$_timerTask(WaitCursor waitCursor) {
        return waitCursor._timerTask;
    }

    static void mav$setWaitCursor(WaitCursor waitCursor, boolean bl) {
        waitCursor.setWaitCursor(bl);
    }

    static void wa$_timerTask(WaitCursor waitCursor, TimerTask timerTask) {
        waitCursor._timerTask = timerTask;
    }

    public static final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public final class 1
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = WaitCursor.mav$getLockObject(WaitCursor.this);
            synchronized (object) {
                if (WaitCursor.ra$_timerTask(WaitCursor.this) != null) {
                    WaitCursor.mav$setWaitCursor(WaitCursor.this, true);
                    WaitCursor.wa$_timerTask(WaitCursor.this, null);
                }
            }
        }
    }
}

