/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.util.TriStateBoolean;

public class CheckBoxList
extends JList {
    private CheckBoxListCellRenderer _listCellRenderer;
    private CheckBoxListListener _listListener;
    private boolean _trackingKeyboard;

    void $init$() {
        this._listCellRenderer = new CheckBoxListCellRenderer(null);
        this._listListener = new CheckBoxListListener(null);
        this._trackingKeyboard = false;
    }

    public CheckBoxList() {
        this(new CheckBoxListModel());
    }

    public CheckBoxList(CheckBoxListModel checkBoxListModel) {
        super(checkBoxListModel);
        this.$init$();
        this.addMouseListener(this._listListener);
        this.setCellRenderer(this._listCellRenderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public CheckBoxList(Object[] objectArray) {
        this(new CheckBoxListModel(objectArray));
    }

    public CheckBoxList(Object[] objectArray, Icon icon, boolean bl) {
        this(new CheckBoxListModel(objectArray, icon, bl));
    }

    public CheckBoxList(Object[] objectArray, Icon icon, boolean bl, boolean bl2) {
        this(new CheckBoxListModel(objectArray, icon, bl, bl2));
    }

    public CheckBoxList(Object[] objectArray, boolean bl) {
        this(new CheckBoxListModel(objectArray, bl));
    }

    public CheckBoxList(Object[] objectArray, boolean bl, boolean bl2) {
        this(new CheckBoxListModel(objectArray, bl, bl2));
    }

    public CheckBoxListModel getCheckBoxListModel() {
        return (CheckBoxListModel)this.getModel();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this._trackingKeyboard && keyEvent.getKeyCode() == 27) {
            this._trackingKeyboard = false;
            this._listListener.keyReleaseRow(this, -1);
            return;
        }
        if (keyEvent.getKeyCode() != 32) {
            super.processKeyEvent(keyEvent);
            return;
        }
        int n = this._listCellRenderer.getLastRowWithFocus();
        if (n < 0) {
            return;
        }
        switch (keyEvent.getID()) {
            case 401: {
                if (this._trackingKeyboard) break;
                this._trackingKeyboard = true;
                this._listListener.keyPressRow(this, n);
                break;
            }
            case 402: {
                if (!this._trackingKeyboard) break;
                this._trackingKeyboard = false;
                this._listListener.keyReleaseRow(this, n);
                break;
            }
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.locationToIndex(point);
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)this.getModel();
        if (n >= 0 && n < checkBoxListModel.getSize() - 1) {
            return checkBoxListModel.getToolTipTextForElement(n);
        }
        return "";
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this._trackingKeyboard && focusEvent.getSource() == this) {
            this._trackingKeyboard = false;
            this._listListener.keyReleaseRow(this, -1);
        }
        if (focusEvent.getSource() == this && focusEvent.getID() == 1004 && focusEvent.getOppositeComponent() instanceof JLabel && !focusEvent.isTemporary() && this.getSelectedIndex() == -1) {
            this.setSelectedIndex(0);
        }
        super.processFocusEvent(focusEvent);
    }

    private static class CheckBoxListCellRenderer
    extends DefaultListCellRenderer {
        protected int _lastRowWithFocus;
        private JLabeledCheckBox _lcb;
        private JSelectableLabel _sl;

        void $init$() {
            this._lastRowWithFocus = -1;
            this._lcb = new JLabeledCheckBox();
            this._sl = new JSelectableLabel();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl2) {
                this._lastRowWithFocus = n;
            }
            if (!(object instanceof CheckBoxListCellData)) {
                return this;
            }
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)object;
            if (checkBoxListCellData == null) {
                return this;
            }
            boolean bl3 = checkBoxListCellData.getHasCheckBox();
            if (bl3) {
                this._lcb.checkBox.setBorderPaintedFlat(true);
                this._lcb.label.setHeightAdjustment(checkBoxListCellData.getHeightAdjustment());
                if (!jList.isEnabled()) {
                    this._lcb.label.setEnabled(false);
                    this._lcb.checkBox.setEnabled(false);
                } else {
                    this._lcb.label.setEnabled(checkBoxListCellData.isTextEnabled());
                    this._lcb.checkBox.setEnabled(checkBoxListCellData.isCheckBoxEnabled());
                }
                this._lcb.label.setSelected(bl);
                this._lcb.label.setText(checkBoxListCellData.getText());
                this._lcb.label.setIcon(checkBoxListCellData.getIcon());
                this._lcb.label.setHasFocus(bl2);
                this._lcb.setToolTipText(checkBoxListCellData.getToolTipText());
                this._lcb.getAccessibleContext().setAccessibleName(checkBoxListCellData.getText());
                TriStateBoolean triStateBoolean = checkBoxListCellData.getCheckBoxState();
                ButtonModel buttonModel = this._lcb.checkBox.getModel();
                if (!triStateBoolean.isTriState()) {
                    this._lcb.checkBox.setSelected(triStateBoolean.booleanValue());
                    buttonModel.setArmed(checkBoxListCellData.isArmed());
                    buttonModel.setPressed(checkBoxListCellData.isPressed());
                } else if (checkBoxListCellData.isArmed() && checkBoxListCellData.isPressed()) {
                    this._lcb.checkBox.setSelected(true);
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                } else {
                    this._lcb.checkBox.setSelected(true);
                    this._lcb.checkBox.setEnabled(false);
                }
                return this._lcb;
            }
            this._sl.setHeightAdjustment(checkBoxListCellData.getHeightAdjustment());
            this._sl.setEnabled(jList.isEnabled() ? checkBoxListCellData.isTextEnabled() : false);
            this._sl.setSelected(bl);
            this._sl.setText(checkBoxListCellData.getText());
            this._sl.getAccessibleContext().setAccessibleName(checkBoxListCellData.getText());
            this._sl.setIcon(checkBoxListCellData.getIcon());
            this._sl.setHasFocus(bl2);
            this._sl.setToolTipText(checkBoxListCellData.getToolTipText());
            return this._sl;
        }

        public int getLastRowWithFocus() {
            return this._lastRowWithFocus;
        }

        private CheckBoxListCellRenderer() {
            this.$init$();
        }

        CheckBoxListCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class CheckBoxListListener
    implements MouseMotionListener,
    MouseListener {
        private boolean _isArmed;
        private long _pressedTime;
        private int _pressedRow;
        private int _checkBoxWidth;
        private boolean _trackingMousePress;
        private boolean _trackingKeyPress;
        private static final int BOUNCE_TIME = 150;

        void $init$() {
            this._isArmed = false;
            this._pressedTime = -1;
            this._pressedRow = -1;
            this._checkBoxWidth = -1;
            this._trackingMousePress = false;
            this._trackingKeyPress = false;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this._trackingKeyPress) {
                if (SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                    this.mouseReleased(mouseEvent);
                }
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this._pressedTime = mouseEvent.getWhen();
            CheckBoxList checkBoxList = (CheckBoxList)mouseEvent.getComponent();
            this.pressRow(checkBoxList, this.getCurrentRow(mouseEvent));
            if (this._pressedRow >= 0) {
                this._trackingMousePress = true;
                checkBoxList.addMouseMotionListener(this);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._trackingKeyPress) {
                return;
            }
            long l = mouseEvent.getWhen();
            CheckBoxList checkBoxList = (CheckBoxList)mouseEvent.getComponent();
            this.releaseRow(checkBoxList, this.getCurrentRow(mouseEvent), l);
            this._trackingMousePress = false;
            checkBoxList.removeMouseMotionListener(this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this._pressedRow == -1) {
                return;
            }
            int n = this.getCurrentRow(mouseEvent);
            if (n != this._pressedRow && this._isArmed || n == this._pressedRow && !this._isArmed) {
                CheckBoxList checkBoxList = (CheckBoxList)mouseEvent.getComponent();
                CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)checkBoxList.getModel().getElementAt(this._pressedRow);
                this._isArmed = n == this._pressedRow;
                checkBoxListCellData.setArmed(this._isArmed);
                Rectangle rectangle = checkBoxList.getCellBounds(this._pressedRow, this._pressedRow);
                checkBoxList.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        void keyPressRow(CheckBoxList checkBoxList, int n) {
            if (this._trackingMousePress || this._trackingKeyPress) {
                return;
            }
            this._trackingKeyPress = true;
            this.pressRow(checkBoxList, n);
        }

        void keyReleaseRow(CheckBoxList checkBoxList, int n) {
            if (this._trackingMousePress || !this._trackingKeyPress) {
                return;
            }
            this._trackingKeyPress = false;
            this.releaseRow(checkBoxList, n, 0L);
        }

        private void pressRow(CheckBoxList checkBoxList, int n) {
            if (n < 0) {
                this._pressedRow = -1;
                return;
            }
            if (this._pressedRow >= 0) {
                throw new IllegalStateException("Can't invoke pressRow() when a different row is already being pressed");
            }
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)checkBoxList.getModel().getElementAt(n);
            boolean bl = checkBoxListCellData.getHasCheckBox();
            boolean bl2 = checkBoxListCellData.isCheckBoxSelectable();
            if (!bl || !bl2) {
                this._pressedRow = -1;
                return;
            }
            this._isArmed = true;
            checkBoxListCellData.setArmed(true);
            checkBoxListCellData.setPressed(true);
            this._pressedRow = n;
            Rectangle rectangle = checkBoxList.getCellBounds(this._pressedRow, this._pressedRow);
            checkBoxList.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        private void releaseRow(CheckBoxList checkBoxList, int n, long l) {
            this._checkBoxWidth = -1;
            this._isArmed = false;
            if (this._pressedRow < 0) {
                this._pressedTime = -1;
                return;
            }
            long l2 = l > 0L ? l - this._pressedTime : 0L;
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)checkBoxList.getModel().getElementAt(this._pressedRow);
            checkBoxListCellData.setPressed(false);
            checkBoxListCellData.setArmed(false);
            if (n >= 0 && (this._pressedRow == n || l2 <= 150L)) {
                TriStateBoolean triStateBoolean = checkBoxListCellData.getCheckBoxState();
                TriStateBoolean triStateBoolean2 = triStateBoolean.toggle();
                checkBoxListCellData.setCheckBoxState(triStateBoolean2);
            }
            checkBoxList.repaint();
            this._pressedRow = -1;
        }

        private int getCurrentRow(MouseEvent mouseEvent) {
            int n;
            int n2;
            CheckBoxList checkBoxList = (CheckBoxList)mouseEvent.getComponent();
            int n3 = checkBoxList.locationToIndex(new Point(n2 = mouseEvent.getX(), n = mouseEvent.getY()));
            if (n3 < 0) {
                return -1;
            }
            if (this._checkBoxWidth < 0) {
                Object e = checkBoxList.getModel().getElementAt(n3);
                ListCellRenderer listCellRenderer = checkBoxList.getCellRenderer();
                Component component = listCellRenderer.getListCellRendererComponent(checkBoxList, e, n3, true, true);
                this._checkBoxWidth = component instanceof JLabeledCheckBox ? ((JLabeledCheckBox)component).checkBox.getWidth() : 0;
            }
            Rectangle rectangle = checkBoxList.getCellBounds(n3, n3);
            if (n2 > rectangle.x + this._checkBoxWidth) {
                return -1;
            }
            return n3;
        }

        private CheckBoxListListener() {
            this.$init$();
        }

        CheckBoxListListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

