/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.checkboxlist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.Copyable;

public class CheckBoxListModel
extends AbstractListModel
implements Copyable {
    private ArrayList _dataList;
    private Comparator _comparator;

    void $init$() {
        this._dataList = new ArrayList();
        this._comparator = new 1();
    }

    public CheckBoxListModel() {
        this.$init$();
    }

    public CheckBoxListModel(Object[] objectArray) {
        this.$init$();
        int n = 0;
        while (n < objectArray.length) {
            this.addElement(objectArray[n], null, false, false);
            ++n;
        }
    }

    public CheckBoxListModel(Object[] objectArray, Icon icon, boolean bl) {
        this(objectArray, icon, bl, false);
    }

    public CheckBoxListModel(Object[] objectArray, Icon icon, boolean bl, boolean bl2) {
        this.$init$();
        int n = 0;
        while (n < objectArray.length) {
            this.addElement(objectArray[n], icon, bl, bl2);
            ++n;
        }
    }

    public CheckBoxListModel(Object[] objectArray, boolean bl) {
        this(objectArray, null, bl);
    }

    public CheckBoxListModel(Object[] objectArray, boolean bl, boolean bl2) {
        this(objectArray, null, bl, bl2);
    }

    public void addElement(Object object, Icon icon, String string, String string2) {
        this.addElementAt(-1, object, icon, false, false, string, string2);
    }

    public void addElementAt(int n, Object object, Icon icon, String string, String string2) {
        this.addElementAt(n, object, icon, false, false, string, string2);
    }

    public void addElement(Object object, Icon icon, boolean bl, boolean bl2) {
        this.addElementAt(-1, object, icon, bl, bl2, object.toString());
    }

    public void addElementAt(int n, Object object, Icon icon, boolean bl, boolean bl2) {
        this.addElementAt(n, object, icon, bl, bl2, object.toString());
    }

    public void addElement(Object object, Icon icon, boolean bl, boolean bl2, String string) {
        this.addElementAt(-1, object, icon, bl, bl2, string, null);
    }

    public void addElementAt(int n, Object object, Icon icon, boolean bl, boolean bl2, String string) {
        this.addElementAt(n, object, icon, bl, bl2, string, null);
    }

    public void addElement(Object object, Icon icon, boolean bl, boolean bl2, String string, String string2) {
        this.addElementAt(-1, object, icon, bl, bl2, string, string2);
    }

    public void addElementAt(int n, Object object, Icon icon, boolean bl, boolean bl2, String string, String string2) {
        TriStateBoolean triStateBoolean = bl2 ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
        int n2 = 0;
        if (n == -1) {
            this._dataList.add(new CheckBoxListCellData(icon, string, bl, triStateBoolean, object, string2));
            n2 = this._dataList.size() - 1;
        } else {
            this._dataList.add(n, new CheckBoxListCellData(icon, string, bl, triStateBoolean, object, string2));
            n2 = n;
        }
        this.fireIntervalAdded(this, n2, n2);
    }

    public void addCheckBoxStateListener(CheckBoxListItemStateListener checkBoxListItemStateListener) {
        if (checkBoxListItemStateListener != null) {
            for (CheckBoxListCellData checkBoxListCellData : this._dataList) {
                checkBoxListCellData.setStateListener(checkBoxListItemStateListener);
            }
        }
    }

    public void selectAll() {
        for (CheckBoxListCellData checkBoxListCellData : this._dataList) {
            checkBoxListCellData.setCheckBoxState(true);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public void deselectAll() {
        for (CheckBoxListCellData checkBoxListCellData : this._dataList) {
            checkBoxListCellData.setCheckBoxState(false);
        }
        this.fireContentsChanged(this, 0, this._dataList.size() - 1);
    }

    public List getSelectionList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (CheckBoxListCellData checkBoxListCellData : this._dataList) {
            TriStateBoolean triStateBoolean = checkBoxListCellData.getCheckBoxState();
            if (!triStateBoolean.isTrue()) continue;
            arrayList.add(checkBoxListCellData.getUserObject());
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public void findUserObjectAndMark(Object object, boolean bl) {
        for (CheckBoxListCellData checkBoxListCellData : this._dataList) {
            if (!checkBoxListCellData.getUserObject().equals(object)) continue;
            checkBoxListCellData.setCheckBoxState(bl);
            return;
        }
    }

    public boolean isElementSelected(int n) {
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n);
        TriStateBoolean triStateBoolean = checkBoxListCellData.getCheckBoxState();
        return triStateBoolean.isTrue();
    }

    public void setElementSelected(int n) {
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n);
        checkBoxListCellData.setCheckBoxState(true);
    }

    public Object getUserObjectAt(int n) {
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n);
        return checkBoxListCellData.getUserObject();
    }

    public void setCheckBoxVisible(boolean bl, boolean bl2) {
        int n = this._dataList.size();
        int n2 = 0;
        while (n2 < n) {
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n2);
            checkBoxListCellData.setHasCheckBox(bl);
            checkBoxListCellData.setCheckBoxState(bl2);
            ++n2;
        }
    }

    public void sort() {
        Collections.sort(this._dataList, this._comparator);
        this.fireContentsChanged(this, 0, this._dataList.size());
    }

    public void clear() {
        int n = this._dataList.size();
        if (n > 0) {
            this._dataList.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    public void removeElementByText(String string) {
        int n = this.findElementByText(string);
        if (n != -1) {
            this._dataList.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    public void removeElementByIndex(int n) {
        this._dataList.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public int findElementByText(String string) {
        int n = this._dataList.size();
        int n2 = 0;
        while (n2 < n) {
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n2);
            if (checkBoxListCellData.getText().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public String findTextForElement(int n) {
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n);
        return checkBoxListCellData.getText();
    }

    public String getToolTipTextForElement(int n) {
        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this._dataList.get(n);
        return checkBoxListCellData.getToolTipText();
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((CheckBoxListModel)object);
    }

    protected final boolean equalsImpl(CheckBoxListModel checkBoxListModel) {
        return checkBoxListModel._dataList.equals(this._dataList);
    }

    public void putCheckBoxListCellDataAt(int n, CheckBoxListCellData checkBoxListCellData) {
        this._dataList.add(n, checkBoxListCellData);
    }

    public Object getElementAt(int n) {
        return this._dataList.get(n);
    }

    public int getSize() {
        return this._dataList.size();
    }

    public Object copyTo(Object object) {
        CheckBoxListModel checkBoxListModel = object != null ? (CheckBoxListModel)object : new CheckBoxListModel();
        this.copyToImpl(checkBoxListModel);
        return checkBoxListModel;
    }

    protected final void copyToImpl(CheckBoxListModel checkBoxListModel) {
        ModelUtil.deepCopy((List)this._dataList, (List)checkBoxListModel._dataList);
    }

    public final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)object;
            CheckBoxListCellData checkBoxListCellData2 = (CheckBoxListCellData)object2;
            return checkBoxListCellData.getText().compareTo(checkBoxListCellData2.getText());
        }
    }
}

