/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;

public class AutoRepeatButtonModel
extends DefaultButtonModel
implements ActionListener {
    private final int _initDelay;
    private final int _repeatDelay;
    private Timer _timer;
    private ActionEvent _event;
    private Window _focusedWindow;

    public AutoRepeatButtonModel() {
        this(750, 50);
    }

    public AutoRepeatButtonModel(int n, int n2) {
        this._initDelay = n;
        this._repeatDelay = n2;
    }

    public void setPressed(boolean bl) {
        if (this.isPressed() != bl && this.isEnabled()) {
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            if (this.isPressed()) {
                int n = 0;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof InputEvent) {
                    n = ((InputEvent)aWTEvent).getModifiers();
                } else if (aWTEvent instanceof ActionEvent) {
                    n = ((ActionEvent)aWTEvent).getModifiers();
                }
                this._event = new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n);
                this.launchTimer();
                this.fireActionPerformed(this._event);
            } else {
                this.stopTimer();
            }
            this.fireStateChanged();
        }
    }

    public void setEnabled(boolean bl) {
        if (!bl) {
            this.stopTimer();
        }
        super.setEnabled(bl);
    }

    public void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
            this._focusedWindow = null;
        }
    }

    private void launchTimer() {
        if (this._timer == null) {
            this._timer = new Timer(this._repeatDelay, this);
            this._timer.setInitialDelay(this._initDelay);
            this._timer.setRepeats(true);
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._focusedWindow = keyboardFocusManager.getFocusedWindow();
            this._timer.start();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window window = keyboardFocusManager.getFocusedWindow();
        if (window == this._focusedWindow) {
            this.fireActionPerformed(this._event);
        } else {
            this.stopTimer();
        }
    }
}

