/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ListModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.IdeConstants;
import oracle.ide.IdeUIManager;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.controls.SmallSquareButton;
import oracle.ide.controls.customtab.CustomTabPage;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;

public class CustomTab
extends JPanel
implements ListDataListener,
MouseMotionListener,
MouseListener,
SwingConstants {
    public static final double SELECTED_STYLE_FIXED = 0.0;
    public static final double SELECTED_STYLE_CENTER = 0.5;
    public static final double SELECTED_STYLE_MOVE = 1.0;
    private static final String DOTDOTDOT = "...";
    private static final Color COLOR_UNSELECTED = IdeUIManager.getUnselectedTabColor();
    private static final Color COLOR_SELECTED_FOCUSED = IdeUIManager.getSelectedFocusedTabColor();
    private static final Color COLOR_HIGHLIGHTED = IdeUIManager.getHighlightedTabColor();
    private static final Color DISABLED_TEXT_COLOR = IdeUIManager.getDisabledTextColor();
    private static final Color COLOR_LINES = IdeConstants.COLOR_IDE_LINES;
    private static final String CLOSE_SELECTED_COMMAND = "closeSelected";
    private static final String CLOSE_HOVER_COMMAND = "closeHover";
    private int _position;
    private ListModel _model;
    private int _selectedPage;
    private int _hoverPage;
    private final ArrayList _selectionListener;
    private int _tooltipHeight;
    private AbstractButton _selectedCloseButton;
    private AbstractButton _hoverCloseButton;
    private ActionListener _closeAction;
    private boolean _ctrlClickCloseEnabled;
    private boolean _isListeningGlobalMouseMovements;
    private boolean _active;
    private boolean _focused;
    private boolean _compressible;
    private boolean _isGradientHighlight;
    private boolean _fitWidth;
    private boolean _showIcons;
    private boolean _showTabUnderline;
    private boolean _showSelectedCloseButton;
    private int _minTabWidth;
    private int _minTabHeight;
    private Font[] _cachedFonts;
    private ArrayList _listDataListeners;
    private int _gapBeforeTabs;
    private int _gapBetweenTabs;
    private int _gapAfterTabs;
    private int _gapAboveLabel;
    private int _gapBelowLabel;
    private int _gapLeft;
    private int _gapCenter;
    private int _gapClose;
    private int _gapRight;
    private int _offsetSelected;
    private int _cornerSize;
    private double _selectedStyle;

    void $init$() {
        this._position = 3;
        this._selectedPage = -1;
        this._hoverPage = -1;
        this._selectionListener = new ArrayList(2);
        this._showIcons = true;
        this._showTabUnderline = true;
        this._listDataListeners = new ArrayList(3);
        this._gapBeforeTabs = 0;
        this._gapBetweenTabs = 1;
        this._gapAfterTabs = 0;
        this._gapAboveLabel = 1;
        this._gapBelowLabel = 1;
        this._gapLeft = 1;
        this._gapCenter = 1;
        this._gapClose = 4;
        this._gapRight = 1;
        this._offsetSelected = 2;
        this._cornerSize = 2;
        this._selectedStyle = 0.5;
    }

    public CustomTab(int n) {
        this(null, n);
    }

    public CustomTab(ListModel listModel, int n) {
        super(null);
        this.$init$();
        this.setFocusable(false);
        this._position = n;
        this.setModel(listModel);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
        this._hoverCloseButton = new CloseButton();
        this._hoverCloseButton.setActionCommand(CLOSE_HOVER_COMMAND);
        this.add(this._hoverCloseButton);
        this._selectedCloseButton = new CloseButton();
        this._selectedCloseButton.setActionCommand(CLOSE_SELECTED_COMMAND);
        this.add(this._selectedCloseButton);
        this.setFont(UIManager.getFont("Label.font"));
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel listModel) {
        if (this._model != null) {
            this._model.removeListDataListener(this);
            this._selectedPage = -1;
            this._hoverPage = -1;
        }
        this._model = listModel;
        if (this._model != null) {
            this._model.addListDataListener(this);
        }
        this.whenTabChanged();
    }

    public void addCloseActionListener(ActionListener actionListener) {
        this.setCloseAction(new 2(this, actionListener));
    }

    public void setCloseAction(Action action) {
        this._closeAction = action;
        this._selectedCloseButton.setAction(action);
        this._hoverCloseButton.setAction(action);
        this.whenTabChanged();
    }

    private boolean isCtrlClickCloseEnabled() {
        return this._ctrlClickCloseEnabled;
    }

    public void setCtrlClickCloseEnabled(boolean bl) {
        this._ctrlClickCloseEnabled = bl;
    }

    public void addSelectionListener(ListSelectionListener listSelectionListener) {
        this._selectionListener.add(listSelectionListener);
    }

    public void removeSelectionListener(ListSelectionListener listSelectionListener) {
        this._selectionListener.remove(listSelectionListener);
    }

    private void fireSelectionChange() {
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, this._selectedPage, this._selectedPage, false);
        int n = 0;
        while (n < this._selectionListener.size()) {
            ListSelectionListener listSelectionListener = (ListSelectionListener)this._selectionListener.get(n);
            listSelectionListener.valueChanged(listSelectionEvent);
            ++n;
        }
    }

    public int getPosition() {
        return this._position;
    }

    public void setPosition(int n) {
        this._position = n;
    }

    private boolean isCompressible() {
        return this._compressible;
    }

    public void setCompressible(boolean bl) {
        if (this._compressible != bl) {
            this._compressible = bl;
            this.whenTabChanged();
        }
    }

    private int getMinTabWidth() {
        return this._minTabWidth;
    }

    public void setMinTabWidth(int n) {
        if (this._minTabWidth != n) {
            this._minTabWidth = n;
            this.whenTabChanged();
        }
    }

    public int getMinTabHeight() {
        return this._minTabHeight;
    }

    public void setMinTabHeight(int n) {
        if (this._minTabHeight != n) {
            this._minTabHeight = n;
            this.whenTabChanged();
        }
    }

    public static Color getColorLines() {
        return COLOR_LINES;
    }

    public boolean getShowIcons() {
        return this.isShowIcons();
    }

    public boolean isShowIcons() {
        return this._showIcons;
    }

    public void setShowIcons(boolean bl) {
        if (this._showIcons != bl) {
            this._showIcons = bl;
            this.whenTabChanged();
        }
    }

    public boolean isShowTabUnderline() {
        return this._showTabUnderline;
    }

    public void setShowTabUnderline(boolean bl) {
        if (this._showTabUnderline != bl) {
            this._showTabUnderline = bl;
            this.whenTabChanged();
        }
    }

    public boolean isFitWidth() {
        return this._fitWidth;
    }

    public void setFitWidth(boolean bl) {
        if (this._fitWidth != bl) {
            this._fitWidth = bl;
            this.whenTabChanged();
        }
    }

    public boolean isGradientHighlight() {
        return this._isGradientHighlight;
    }

    public void setGradientHighlight(boolean bl) {
        if (this._isGradientHighlight != bl) {
            this._isGradientHighlight = bl;
            this.repaint();
        }
    }

    public boolean isFocused() {
        return this._focused;
    }

    public void setFocused(boolean bl) {
        if (bl != this._focused) {
            this._focused = bl;
            this.whenTabChanged();
        }
    }

    private boolean isActive() {
        return this._active;
    }

    public void setActive(boolean bl) {
        if (this._active != bl) {
            this._active = bl;
            this.whenTabChanged();
        }
    }

    public boolean isShowSelectedCloseButton() {
        return this._showSelectedCloseButton;
    }

    public void setShowSelectedCloseButton(boolean bl) {
        if (this._showSelectedCloseButton != bl) {
            this._showSelectedCloseButton = bl;
            this.whenTabChanged();
        }
    }

    public CustomTabPage removePage(int n) {
        DefaultListModel defaultListModel = (DefaultListModel)this._model;
        CustomTabPage customTabPage = (CustomTabPage)defaultListModel.remove(n);
        if (this.getPageCount() == 0) {
            this._selectedPage = -1;
        }
        this._hoverPage = -1;
        return customTabPage;
    }

    public void removePage(CustomTabPage customTabPage) {
        int n = this.searchPage(customTabPage);
        this.removePage(n);
    }

    public void removeAllPages() {
        DefaultListModel defaultListModel = (DefaultListModel)this._model;
        if (defaultListModel != null) {
            defaultListModel.removeAllElements();
        }
        this._selectedPage = -1;
        this._hoverPage = -1;
    }

    public int getPageCount() {
        return this._model == null ? 0 : this._model.getSize();
    }

    public int searchPage(CustomTabPage customTabPage) {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            CustomTabPage customTabPage2 = this.getPage(n2);
            if (customTabPage2 == customTabPage) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public CustomTabPage getPage(int n) {
        return (CustomTabPage)this._model.getElementAt(n);
    }

    public void setSelectedPage(int n) {
        if (this._selectedPage != n) {
            this._setSelectedPage(n);
        }
    }

    private void _setSelectedPage(int n) {
        if (n == -1 || this.getPage(n).isEnabled() && this.getPage(n).isVisible()) {
            this._selectedPage = n;
            if (n != -1) {
                CustomTabPage customTabPage = this.getPage(n);
                String string = customTabPage.getTooltip();
                if (!ModelUtil.hasLength((String)string)) {
                    string = "";
                }
                this.getAccessibleContext().setAccessibleName(string);
                this.getAccessibleContext().setAccessibleDescription(string);
            }
            if (this._selectedPage != -1 && this.getPage(this._selectedPage).isHighlighted()) {
                this.getPage(this._selectedPage).setHighlighted(false);
            }
            this.fireSelectionChange();
            this.whenTabChanged();
        }
    }

    public int getSelectedPage() {
        return this._selectedPage;
    }

    private void selectPageAt(Point point) {
        int n = this.getPageAt(point);
        if (n != -1) {
            this.setSelectedPage(n);
        }
    }

    public int getPageAt(Point point) {
        int n = this.getPageCount();
        int n2 = 0;
        while (n2 < n) {
            CustomTabPage customTabPage = this.getPage(n2);
            if (customTabPage.isVisible() && customTabPage.getBounds().contains(point)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getPageBefore(int n) {
        int n2 = -1;
        int n3 = this.getPageCount();
        int n4 = 0;
        while (n4 < n3) {
            CustomTabPage customTabPage = this.getPage(n4);
            if (customTabPage.isVisible()) {
                Rectangle rectangle = customTabPage.getBounds();
                if (rectangle.x >= n) break;
                n2 = n4;
            }
            ++n4;
        }
        return n2;
    }

    public int getPageAfter(int n) {
        int n2 = this.getPageCount();
        int n3 = 0;
        while (n3 < n2) {
            CustomTabPage customTabPage = this.getPage(n3);
            if (customTabPage.isVisible()) {
                Rectangle rectangle = customTabPage.getBounds();
                if (rectangle.x > n) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    public void setDirty(int n, boolean bl) {
        CustomTabPage customTabPage = this.getPage(n);
        if (n != -1) {
            customTabPage.setDirty(bl);
            this.whenTabChanged();
        }
    }

    public void setHighlighted(int n, boolean bl) {
        CustomTabPage customTabPage = this.getPage(n);
        if (n != -1 && n != this._selectedPage) {
            customTabPage.setHighlighted(bl);
            this.whenTabChanged();
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        int n = 0;
        int n2 = 0;
        int n3 = this.getPageCount();
        while (n3-- > 0) {
            CustomTabPage customTabPage = this.getPage(n3);
            if (!customTabPage.isVisible()) continue;
            n2 += this.getMinimumTabWidth(customTabPage, n3 == this.getSelectedPage());
            ++n;
        }
        return new Dimension(n2 += this._gapBeforeTabs + this._gapAfterTabs + this._gapBetweenTabs * (n - 1), dimension.height);
    }

    public Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        int n = this.isFitWidth() ? Integer.MAX_VALUE : dimension.width;
        return new Dimension(n, dimension.height);
    }

    public Dimension getPreferredSize() {
        Dimension dimension;
        if (!this.isPreferredSizeSet()) {
            dimension = this.getMaxSize();
            this.clearCachedFont();
            this.setPreferredSize(dimension);
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    public void doLayout() {
        Rectangle rectangle = this.getTabBounds();
        this.calculateSizes(rectangle, true);
        this.updateCloseButtons();
    }

    public void invalidate() {
        super.invalidate();
        this.setPreferredSize(null);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._cachedFonts = new Font[4];
    }

    private Font getCachedFont(int n) {
        Font font = this._cachedFonts[n];
        if (font == null) {
            Font font2 = UIManager.getFont("Oracle.dirtyFont");
            if (font2 == null || (n & 2) != 2) {
                font2 = this._cachedFonts[0] == null ? this.getFont() : this._cachedFonts[0];
            }
            this._cachedFonts[n] = font = n != font2.getStyle() ? font2.deriveFont(n) : font2;
        }
        return font;
    }

    private void clearCachedFont() {
        int n = 0;
        while (n < this._cachedFonts.length) {
            this._cachedFonts[n] = null;
            ++n;
        }
    }

    private Font getAdjustedFont(CustomTabPage customTabPage, boolean bl) {
        boolean bl2 = customTabPage.isDirty();
        boolean bl3 = bl && this.isActive() || customTabPage.isHighlighted();
        Font font = this.getCachedFont((bl2 ? 2 : 0) | (bl3 ? 1 : 0));
        return font;
    }

    private AbstractButton getCloseButton(boolean bl) {
        return bl && this.isShowSelectedCloseButton() ? this._selectedCloseButton : this._hoverCloseButton;
    }

    private void updateCloseButtons() {
        this.updateSelectedCloseButton();
        this.updateHoverCloseButton();
    }

    private void updateSelectedCloseButton() {
        if (this.isShowSelectedCloseButton()) {
            if (this._selectedPage >= 0 && this._selectedPage < this.getPageCount()) {
                this.showCloseButton(this._selectedCloseButton, this._selectedPage);
            } else {
                this.hideCloseButton(this._selectedCloseButton);
            }
        }
    }

    private void updateHoverCloseButton() {
        if (this._hoverPage >= 0 && this._hoverPage < this.getPageCount()) {
            if (!this.isShowSelectedCloseButton() || this._hoverPage != this._selectedPage) {
                this.showCloseButton(this._hoverCloseButton, this._hoverPage);
            } else {
                this.hideCloseButton(this._hoverCloseButton);
            }
        } else {
            this.hideCloseButton(this._hoverCloseButton);
        }
    }

    private void showCloseButton(AbstractButton abstractButton, int n) {
        CustomTabPage customTabPage = this.getPage(n);
        if (this._closeAction != null && customTabPage.isCloseable()) {
            abstractButton.setVisible(true);
            Rectangle rectangle = customTabPage.getBounds();
            Dimension dimension = abstractButton.getPreferredSize();
            boolean bl = n == this.getSelectedPage();
            int n2 = rectangle.x + rectangle.width - (dimension.width + this._gapRight + this._cornerSize + 1);
            int n3 = rectangle.y + (rectangle.height - dimension.height + (this.isShowTabUnderline() ? 0 : 1) + (bl ? 0 : this._offsetSelected)) / 2;
            abstractButton.setBounds(n2, n3, dimension.width, dimension.height);
            abstractButton.setForeground(this.getButtonForeground(customTabPage, bl));
        }
    }

    private void hideCloseButton(AbstractButton abstractButton) {
        if (this._closeAction != null && abstractButton != null) {
            abstractButton.setVisible(false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point;
        int n;
        boolean bl;
        boolean bl2 = bl = PlatformUtils.isMac() ? mouseEvent.isAltDown() : mouseEvent.isControlDown();
        if (this._closeAction != null && this.isCtrlClickCloseEnabled() && (bl || SwingUtilities.isMiddleMouseButton(mouseEvent)) && (n = this.getPageAt(point = mouseEvent.getPoint())) != -1) {
            CustomTabPage customTabPage = this.getPage(n);
            ActionEvent actionEvent = new ActionEvent(customTabPage, 1001, "", mouseEvent.getWhen(), mouseEvent.getModifiers());
            this._closeAction.actionPerformed(actionEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && (!this.isCtrlClickCloseEnabled() || !mouseEvent.isControlDown() && !SwingUtilities.isMiddleMouseButton(mouseEvent))) {
            this.selectPageAt(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this._isListeningGlobalMouseMovements && this._closeAction != null) {
            GlobalMouseDispatcher globalMouseDispatcher = GlobalMouseDispatcher.getInstance();
            globalMouseDispatcher.addMouseListener(new 1(this, globalMouseDispatcher));
            this._isListeningGlobalMouseMovements = true;
        }
        this.updateHoverCloseButton(mouseEvent.getPoint());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateHoverCloseButton(mouseEvent.getPoint());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateHoverCloseButton(mouseEvent.getPoint());
    }

    private void updateHoverCloseButton(Point point) {
        if (this._closeAction != null) {
            this._hoverPage = this.getPageAt(point);
            this.updateHoverCloseButton();
        }
    }

    public void whenTabChanged() {
        this.revalidate();
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this._listDataListeners.add(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this._listDataListeners.remove(listDataListener);
    }

    private void fireListDataEvent(ListDataEvent listDataEvent) {
        int n = 0;
        while (n < this._listDataListeners.size()) {
            ListDataListener listDataListener = (ListDataListener)this._listDataListeners.get(n);
            switch (listDataEvent.getType()) {
                case 0: {
                    listDataListener.contentsChanged(listDataEvent);
                    break;
                }
                case 1: {
                    listDataListener.intervalAdded(listDataEvent);
                    break;
                }
                case 2: {
                    listDataListener.intervalRemoved(listDataEvent);
                }
            }
            ++n;
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        if (n <= this._selectedPage) {
            this._selectedPage += n2 + 1 - n;
        }
        this.fireListDataEvent(listDataEvent);
        this.whenTabChanged();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        int n = listDataEvent.getIndex0();
        int n2 = listDataEvent.getIndex1();
        if (this._selectedPage > n2) {
            this._selectedPage -= n2 + 1 - n;
        } else if (this._selectedPage >= n) {
            int n3 = n - 1;
            while (n3 >= 0) {
                CustomTabPage customTabPage = this.getPage(n3);
                if (customTabPage.isVisible()) break;
                --n3;
            }
            int n4 = n3 + 1;
            while (n4 < this._model.getSize()) {
                CustomTabPage customTabPage = this.getPage(n4);
                if (customTabPage.isVisible()) {
                    n3 = n4;
                    break;
                }
                ++n4;
                ++n4;
            }
            if (n3 >= 0) {
                this._setSelectedPage(n3);
            }
        }
        this.fireListDataEvent(listDataEvent);
        this.whenTabChanged();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.setSelectedPage(-1);
        this.fireListDataEvent(listDataEvent);
        this.whenTabChanged();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        CustomTabPage customTabPage;
        String string = null;
        int n = this.getPageAt(mouseEvent.getPoint());
        if (n != -1 && (string = (customTabPage = this.getPage(n)).getTooltip()) == null && (customTabPage.isCompressed() || customTabPage.isCondensed()) && (string = customTabPage.getLongLabel()) == null) {
            string = customTabPage.getLabel();
        }
        return string;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n;
        Point point = null;
        if (this.getToolTipText(mouseEvent) != null && (n = this.getPageAt(mouseEvent.getPoint())) != -1) {
            CustomTabPage customTabPage = this.getPage(n);
            Rectangle rectangle = customTabPage.getBounds();
            if (this._tooltipHeight == 0) {
                JToolTip jToolTip = this.createToolTip();
                jToolTip.setTipText("jt");
                this._tooltipHeight = jToolTip.getPreferredSize().height;
            }
            point = new Point(rectangle.x, -this._tooltipHeight);
        }
        return point;
    }

    private void drawTabTop(int n, int n2, int n3, int n4, boolean bl, CustomTabPage customTabPage, Graphics2D graphics2D) {
        int n5 = bl ? 0 : this._offsetSelected;
        int[] nArray = new int[]{n, n, n + this._cornerSize, n + n3 - this._cornerSize - 1, n + n3 - 1, n + n3 - 1};
        int[] nArray2 = new int[]{n2 + n4 - 1, n2 + this._cornerSize + n5, n2 + n5, n2 + n5, n2 + this._cornerSize + n5, n2 + n4 - 1};
        if (this.isGradientHighlight()) {
            Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
            if (bl) {
                Color color;
                Color color2;
                if (this.isFocused()) {
                    color2 = IdeUIManager.getActiveTitleGradientLightColor();
                    color = IdeUIManager.getActiveTitleGradientDarkColor();
                } else {
                    color2 = IdeUIManager.getInactiveTitleGradientLightColor();
                    color = IdeUIManager.getInactiveTitleGradientDarkColor();
                }
                graphics2D.setColor(color);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n4 - 1, color));
            } else {
                graphics2D.setColor(IdeUIManager.getUnselectedTitleColor());
            }
            graphics2D.fill(polygon);
            graphics2D.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
            Color color = graphics2D.getColor();
            color = new Color((int)((double)color.getRed() * 0.95), (int)((double)color.getGreen() * 0.95), (int)((double)color.getBlue() * 0.95));
            graphics2D.setColor(color);
            graphics2D.drawLine(n + n3 - 3, n2 + this._cornerSize + n5 - 1, n + n3 - 3, n2 + n4 - 3);
            color = new Color((int)((double)color.getRed() * 0.95), (int)((double)color.getGreen() * 0.95), (int)((double)color.getBlue() * 0.95));
            graphics2D.setColor(color);
            graphics2D.drawLine(n + n3 - 2, n2 + this._cornerSize + n5, n + n3 - 2, n2 + n4 - 2);
        } else {
            graphics2D.setColor(this.getPageBackground(customTabPage, bl));
            graphics2D.fillPolygon(nArray, nArray2, nArray.length);
            graphics2D.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        }
        graphics2D.setColor(COLOR_LINES);
        graphics2D.drawPolyline(nArray, nArray2, nArray.length);
        Rectangle rectangle = new Rectangle();
        rectangle.x = n + 1 + this._cornerSize + this._gapLeft;
        rectangle.y = n2 + this._gapAboveLabel + this._offsetSelected / 2;
        rectangle.height = n4 - this._gapBelowLabel;
        rectangle.width = n3 - this._cornerSize - this._gapLeft - this._gapRight - this._cornerSize - 1;
        if (this._closeAction != null) {
            AbstractButton abstractButton = this.getCloseButton(bl);
            rectangle.width -= this._gapClose + abstractButton.getPreferredSize().width;
        }
        if (bl) {
            rectangle.translate(0, -((int)((double)this._offsetSelected * this._selectedStyle)));
        }
        this.drawIconAndLabel(graphics2D, rectangle, customTabPage, bl);
    }

    private void drawTabBottom(int n, int n2, int n3, int n4, boolean bl, CustomTabPage customTabPage, Graphics2D graphics2D) {
        int n5 = bl ? 0 : this._offsetSelected;
        int[] nArray = new int[]{n, n, n + this._cornerSize, n + n3 - this._cornerSize - 1, n + n3 - 1, n + n3 - 1};
        int[] nArray2 = new int[]{n2, n2 + n4 - 1 - this._cornerSize - n5, n2 + n4 - 1 - n5, n2 + n4 - 1 - n5, n2 + n4 - 1 - this._cornerSize - n5, n2};
        if (this.isGradientHighlight()) {
            Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
            if (bl) {
                Color color;
                Color color2;
                if (this.isFocused()) {
                    color2 = IdeUIManager.getActiveTitleGradientLightColor();
                    color = IdeUIManager.getActiveTitleGradientDarkColor();
                } else {
                    color2 = IdeUIManager.getInactiveTitleGradientLightColor();
                    color = IdeUIManager.getInactiveTitleGradientDarkColor();
                }
                graphics2D.setColor(color);
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color2, 0.0f, n4 - 1, color));
            } else {
                graphics2D.setColor(IdeUIManager.getUnselectedTitleColor());
            }
            graphics2D.fill(polygon);
            Color color = graphics2D.getColor();
            color = new Color((int)((double)color.getRed() * 0.95), (int)((double)color.getGreen() * 0.95), (int)((double)color.getBlue() * 0.95));
            graphics2D.setColor(color);
            graphics2D.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4 - 1 - this._cornerSize - n5);
        } else {
            graphics2D.setColor(this.getPageBackground(customTabPage, bl));
            graphics2D.fillPolygon(nArray, nArray2, nArray.length);
        }
        graphics2D.setColor(COLOR_LINES);
        graphics2D.drawPolyline(nArray, nArray2, nArray.length);
        Rectangle rectangle = new Rectangle();
        rectangle.x = n + 1 + this._cornerSize + this._gapLeft;
        rectangle.y = n2 + this._gapAboveLabel;
        rectangle.height = n4 - this._offsetSelected - this._gapBelowLabel - 1;
        rectangle.width = n3 - this._cornerSize - this._gapLeft - this._gapRight - this._cornerSize - 1;
        if (this._closeAction != null) {
            AbstractButton abstractButton = this.getCloseButton(bl);
            rectangle.width -= this._gapClose + abstractButton.getPreferredSize().width;
        }
        if (bl) {
            rectangle.translate(0, (int)((double)this._offsetSelected * this._selectedStyle));
        }
        this.drawIconAndLabel(graphics2D, rectangle, customTabPage, bl);
    }

    private void drawIconAndLabel(Graphics2D graphics2D, Rectangle rectangle, CustomTabPage customTabPage, boolean bl) {
        String string;
        boolean bl2;
        int n;
        boolean bl3;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        int n2 = 0;
        Icon icon = this.isShowIcons() ? customTabPage.getIcon() : null;
        boolean bl4 = bl3 = icon != null;
        if (bl3 && (n = icon.getIconWidth()) <= rectangle.width) {
            int n3 = rectangle.y + (rectangle.height - icon.getIconHeight()) / 2;
            icon.paintIcon(this, graphics2D2, rectangle.x + n2, n3);
            n2 += n;
        }
        if (bl2 = ModelUtil.hasLength((String)(string = customTabPage.isCondensed() ? customTabPage.getLabel() : customTabPage.getLongLabel()))) {
            Font font = this.getAdjustedFont(customTabPage, bl);
            graphics2D2.setFont(font);
            FontRenderContext fontRenderContext = graphics2D2.getFontRenderContext();
            Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
            double d = (double)rectangle.y + ((double)rectangle.height - rectangle2D.getHeight()) / 2.0;
            double d2 = -rectangle2D.getY();
            float f = (float)(d + d2);
            graphics2D2.setColor(this.getPageForeground(customTabPage, bl));
            int n4 = rectangle.width - n2;
            if (rectangle2D.getWidth() <= (double)n4) {
                if (bl3) {
                    n2 += this._gapCenter;
                }
                SwingUtils.drawString((Graphics2D)graphics2D2, (String)string, (float)(rectangle.x + n2), (float)f);
            } else {
                Rectangle2D rectangle2D2 = font.getStringBounds(DOTDOTDOT, fontRenderContext);
                if (bl3) {
                    n2 += this._gapCenter;
                    n4 -= this._gapCenter;
                }
                graphics2D2.clipRect(rectangle.x + n2, rectangle.y, n4, rectangle.height);
                double d3 = (double)n4 - rectangle2D2.getWidth();
                TextLayout textLayout = new TextLayout(string, graphics2D2.getFont(), fontRenderContext);
                TextHitInfo textHitInfo = textLayout.hitTestChar((float)d3, 1.0f);
                int n5 = textHitInfo.getCharIndex();
                if (n5 > 0) {
                    String string2 = string.substring(0, n5).trim();
                    SwingUtils.drawString((Graphics2D)graphics2D2, (String)string2, (float)(rectangle.x + n2), (float)f);
                    Rectangle2D rectangle2D3 = font.getStringBounds(string2, fontRenderContext);
                    n2 = (int)((double)n2 + rectangle2D3.getWidth());
                }
                SwingUtils.drawString((Graphics2D)graphics2D2, (String)DOTDOTDOT, (float)(rectangle.x + n2), (float)f);
            }
        }
        graphics2D2.dispose();
    }

    private Color getPageForeground(CustomTabPage customTabPage, boolean bl) {
        boolean bl2 = customTabPage.isEnabled();
        if (customTabPage.isHighlighted()) {
            return Color.WHITE;
        }
        if (!bl2) {
            return DISABLED_TEXT_COLOR;
        }
        if (this.isGradientHighlight()) {
            return bl ? (this.isFocused() ? IdeUIManager.getActiveTitleForegroundColor() : IdeUIManager.getInactiveTitleForegroundColor()) : IdeUIManager.getUnselectedTitleForegroundColor();
        }
        return bl2 ? this.getForeground() : DISABLED_TEXT_COLOR;
    }

    private Color getButtonForeground(CustomTabPage customTabPage, boolean bl) {
        boolean bl2 = customTabPage.isEnabled();
        if (customTabPage.isHighlighted()) {
            return Color.WHITE;
        }
        if (!bl2) {
            return DISABLED_TEXT_COLOR;
        }
        if (this.isGradientHighlight()) {
            return bl ? (this.isFocused() ? IdeUIManager.getActiveTitleButtonColor() : IdeUIManager.getInactiveTitleButtonColor()) : IdeUIManager.getUnselectedTitleButtonColor();
        }
        return bl2 ? this.getForeground() : DISABLED_TEXT_COLOR;
    }

    private Color getPageBackground(CustomTabPage customTabPage, boolean bl) {
        if (this.isGradientHighlight()) {
            return bl ? (this.isFocused() ? IdeUIManager.getActiveTitleColor() : IdeUIManager.getInactiveTitleColor()) : IdeUIManager.getUnselectedTitleColor();
        }
        if (bl) {
            return COLOR_SELECTED_FOCUSED;
        }
        if (customTabPage.isHighlighted()) {
            return COLOR_HIGHLIGHTED;
        }
        return COLOR_UNSELECTED;
    }

    public int getGapBeforeTabs() {
        return this._gapBeforeTabs;
    }

    public void setGapBeforeTabs(int n) {
        this._gapBeforeTabs = n;
        this.whenTabChanged();
    }

    public int getGapBetweenTabs() {
        return this._gapBetweenTabs;
    }

    public void setGapBetweenTabs(int n) {
        this._gapBetweenTabs = n;
        this.whenTabChanged();
    }

    public int getGapAfterTabs() {
        return this._gapAfterTabs;
    }

    public void setGapAfterTabs(int n) {
        this._gapAfterTabs = n;
        this.whenTabChanged();
    }

    public int getGapAboveLabel() {
        return this._gapAboveLabel;
    }

    public void setGapAboveLabel(int n) {
        this._gapAboveLabel = n;
        this.whenTabChanged();
    }

    public int getGapBelowLabel() {
        return this._gapBelowLabel;
    }

    public void setGapBelowLabel(int n) {
        this._gapBelowLabel = n;
        this.whenTabChanged();
    }

    public int getGapLeft() {
        return this._gapLeft;
    }

    public void setGapLeft(int n) {
        this._gapLeft = n;
        this.whenTabChanged();
    }

    public int getGapCenter() {
        return this._gapCenter;
    }

    public void setGapCenter(int n) {
        this._gapCenter = n;
        this.whenTabChanged();
    }

    public int getGapRight() {
        return this._gapRight;
    }

    public int getGapClose() {
        return this._gapClose;
    }

    public void setGapClose(int n) {
        this._gapClose = n;
        this.whenTabChanged();
    }

    public void setGapRight(int n) {
        this._gapRight = n;
        this.whenTabChanged();
    }

    public int getOffsetSelected() {
        return this._offsetSelected;
    }

    public void setOffsetSelected(int n) {
        this._offsetSelected = n;
        this.whenTabChanged();
    }

    public int getCornerSize() {
        return this._cornerSize;
    }

    public void setCornerSize(int n) {
        this._cornerSize = n;
        this.whenTabChanged();
    }

    public double getSelectedStyle() {
        return this._selectedStyle;
    }

    public void setSelectedStyle(double d) {
        this._selectedStyle = d;
        this.whenTabChanged();
    }

    private Dimension getMaxSize() {
        Rectangle rectangle = this.getTabBounds();
        Dimension dimension = this.calculateSizes(rectangle, false);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    private int getPreferredTabHeight(String string, Icon icon, FontMetrics fontMetrics, boolean bl) {
        int n;
        Insets insets = this.getInsets();
        boolean bl2 = icon != null;
        boolean bl3 = string != null && string.length() != 0;
        AbstractButton abstractButton = this.getCloseButton(bl);
        int n2 = n = bl2 ? icon.getIconHeight() : 0;
        if (bl3) {
            int n3 = fontMetrics.getHeight();
            n = Math.max(n, n3);
        }
        if (abstractButton != null && this._closeAction != null) {
            n = Math.max(n, abstractButton.getPreferredSize().height);
        }
        n += insets.top + this._gapAboveLabel + this._gapBelowLabel + insets.bottom;
        if (this.isShowTabUnderline()) {
            ++n;
        }
        return Math.max(n, this.getMinTabHeight());
    }

    private int getPreferredTabWidth(String string, Icon icon, FontMetrics fontMetrics, boolean bl) {
        boolean bl2 = icon != null;
        boolean bl3 = string != null && string.length() != 0;
        AbstractButton abstractButton = this.getCloseButton(bl);
        int n = 1 + this._cornerSize + this._gapLeft;
        if (bl2) {
            n += icon.getIconWidth();
        }
        if (bl2 && bl3) {
            n += this._gapCenter;
        }
        if (bl3) {
            int n2 = fontMetrics.stringWidth(string);
            n += n2;
        }
        if (abstractButton != null && this._closeAction != null) {
            n += abstractButton.getPreferredSize().width + this._gapClose;
        }
        return Math.max(n += this._gapRight + this._cornerSize + 1, this.getMinTabWidth());
    }

    private int getMinimumTabWidth(CustomTabPage customTabPage, boolean bl) {
        Icon icon = this.isShowIcons() ? customTabPage.getIcon() : null;
        AbstractButton abstractButton = this.getCloseButton(bl);
        int n = 1 + this._cornerSize + this._gapLeft;
        n = icon != null ? (n += icon.getIconWidth()) : (n += 16);
        if (abstractButton != null && this._closeAction != null) {
            n += abstractButton.getPreferredSize().width + this._gapClose;
        }
        return Math.max(n += this._gapRight + this._cornerSize + 1, this.getMinTabWidth());
    }

    private int getCompressedTabWidth(String string, Icon icon, Font font, FontMetrics fontMetrics, int n, boolean bl) {
        double d;
        FontRenderContext fontRenderContext;
        TextLayout textLayout;
        TextHitInfo textHitInfo;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 1 + this._cornerSize + this._gapLeft;
        n6 += this._gapRight + this._cornerSize + 1;
        boolean bl2 = string != null && string.length() != 0;
        boolean bl3 = icon != null;
        AbstractButton abstractButton = this.getCloseButton(bl);
        if (bl3) {
            n6 += icon.getIconWidth();
        }
        if (abstractButton != null && this._closeAction != null) {
            n6 += abstractButton.getPreferredSize().width + this._gapClose;
        }
        if (bl2 && (n5 = n - n6 - (n4 = icon != null ? this._gapCenter : 0)) > 0 && (n3 = fontMetrics.stringWidth(DOTDOTDOT)) < n5 && (n2 = (textHitInfo = (textLayout = new TextLayout(string, font, fontRenderContext = new FontRenderContext(null, false, false))).hitTestChar((float)(d = (double)(n5 - n3)), 1.0f)).getCharIndex()) > 0) {
            String string2 = string.substring(0, n2);
            int n7 = fontMetrics.stringWidth(string2);
            n6 += n4 + n7 + n3;
        }
        return Math.max(n6, this.getMinTabWidth());
    }

    private Dimension calculateSizes(Rectangle rectangle, boolean bl) {
        int n = this.getPageCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n5 = 0;
        while (n5 < n) {
            CustomTabPage customTabPage = this.getPage(n5);
            customTabPage.setCompressed(false);
            customTabPage.setCondensed(false);
            if (customTabPage.isVisible()) {
                boolean bl2 = n5 == this.getSelectedPage();
                Font font = this.getAdjustedFont(customTabPage, bl2);
                FontMetrics fontMetrics = this.getFontMetrics(font);
                Icon icon = this.isShowIcons() ? customTabPage.getIcon() : null;
                String string = customTabPage.getLabel();
                if (ModelUtil.hasLength((String)string)) {
                    int n6 = this.getPreferredTabWidth(string, icon, fontMetrics, bl2);
                    int n7 = this.getPreferredTabHeight(string, icon, fontMetrics, bl2);
                    nArray2[n5] = n6;
                    n2 = Math.max(n7, n2);
                } else {
                    nArray2[n5] = 0;
                }
                String string2 = customTabPage.getLongLabel();
                if (ModelUtil.hasLength((String)string2)) {
                    int n8 = this.getPreferredTabWidth(string2, icon, fontMetrics, bl2);
                    int n9 = this.getPreferredTabHeight(string2, icon, fontMetrics, bl2);
                    nArray[n5] = n8;
                    n2 = Math.max(n9, n2);
                } else {
                    nArray[n5] = nArray2[n5];
                    customTabPage.setCondensed(true);
                }
                n3 += Math.max(nArray[n5], nArray2[n5]);
                ++n4;
            }
            ++n5;
        }
        n2 += 1 + this._offsetSelected;
        int n10 = rectangle.width - n3 - this._gapBeforeTabs - this._gapAfterTabs - this._gapBetweenTabs * (n4 - 1);
        if (bl && n10 < 0) {
            int n11 = n;
            while (n11-- > 0) {
                int n12;
                CustomTabPage customTabPage = this.getPage(n11);
                if (!customTabPage.isVisible() || nArray[n11] <= (n12 = nArray2[n11])) continue;
                if (this.isCompressible()) {
                    int n13;
                    Icon icon;
                    boolean bl3 = n11 == this.getSelectedPage();
                    Font font = this.getAdjustedFont(customTabPage, bl3);
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int n14 = fontMetrics.stringWidth(DOTDOTDOT);
                    String string = customTabPage.getLongLabel();
                    int n15 = this.getCompressedTabWidth(string, icon = this.isShowIcons() ? customTabPage.getIcon() : null, font, fontMetrics, n13 = nArray[n11] + n10, bl3);
                    if (n15 - n14 > n12) {
                        int n16 = this.isFitWidth() ? n15 : Math.max(n15, n13);
                        int n17 = nArray[n11] - n16;
                        n3 -= n17;
                        nArray[n11] = n16;
                        customTabPage.setCompressed(n17 > 0);
                        if ((n10 += n17) >= 0) break;
                    }
                }
                int n18 = nArray[n11] + n10;
                int n19 = this.isFitWidth() ? n12 : Math.max(n12, n18);
                int n20 = nArray[n11] - n19;
                n3 -= n20;
                nArray[n11] = n19;
                customTabPage.setCondensed(n20 > 0);
                if ((n10 += n20) >= 0) break;
            }
            if (n10 < 0 && this.isCompressible()) {
                int n21 = n;
                while (n21-- > 0) {
                    CustomTabPage customTabPage = this.getPage(n21);
                    if (!customTabPage.isVisible()) continue;
                    boolean bl4 = n21 == this.getSelectedPage();
                    Font font = this.getAdjustedFont(customTabPage, bl4);
                    String string = customTabPage.getLabel();
                    Icon icon = this.isShowIcons() ? customTabPage.getIcon() : null;
                    int n22 = nArray[n21] + n10;
                    FontMetrics fontMetrics = this.getFontMetrics(font);
                    int n23 = this.getCompressedTabWidth(string, icon, font, fontMetrics, n22, bl4);
                    int n24 = this.isFitWidth() ? n23 : Math.max(n23, n22);
                    int n25 = nArray[n21] - n24;
                    n3 -= n25;
                    nArray[n21] = n24;
                    customTabPage.setCompressed(n25 > 0);
                    if ((n10 += n25) >= 0) break;
                }
            }
        }
        if (bl && this.isFitWidth() && n10 > 0) {
            int n26 = n;
            while (n26-- > 0) {
                CustomTabPage customTabPage = this.getPage(n26);
                if (n4 <= 0 || !customTabPage.isVisible()) continue;
                int n27 = n10 / n4;
                int n28 = n26;
                nArray[n28] = nArray[n28] + n27;
                n10 -= n27;
                --n4;
            }
        }
        int n29 = rectangle.x + this._gapBeforeTabs;
        int n30 = rectangle.y;
        int n31 = bl ? rectangle.height : n2;
        int n32 = 0;
        while (n32 < n) {
            CustomTabPage customTabPage = this.getPage(n32);
            if (customTabPage.isVisible()) {
                int n33 = nArray[n32];
                if (bl) {
                    customTabPage.setBounds(n29, n30, n33, n31);
                }
                n29 += nArray[n32];
                n29 += this._gapBetweenTabs;
            }
            ++n32;
        }
        if (n4 > 0) {
            n29 -= this._gapBetweenTabs;
        }
        if (bl && (n29 != rectangle.width || n2 != rectangle.height)) {
            this.updateCloseButtons();
        }
        return new Dimension(n29, n2);
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintTabs(graphics2D);
    }

    protected void paintTabs(Graphics2D graphics2D) {
        int n;
        Rectangle rectangle = this.getTabBounds();
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if ((n = this.getPageCount()) == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            CustomTabPage customTabPage = this.getPage(n2);
            if (customTabPage.isVisible()) {
                boolean bl = this.getSelectedPage() == n2;
                Font font = this.getAdjustedFont(customTabPage, bl);
                graphics2D.setFont(font);
                Rectangle rectangle2 = customTabPage.getBounds();
                if (this._position == 1) {
                    this.drawTabTop(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, bl, customTabPage, graphics2D);
                } else {
                    this.drawTabBottom(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, bl, customTabPage, graphics2D);
                }
            }
            ++n2;
        }
        if (this.isShowTabUnderline()) {
            CustomTabPage customTabPage;
            graphics2D.setColor(COLOR_LINES);
            int n3 = rectangle.x;
            int n4 = rectangle.x;
            if (this._selectedPage != -1 && (customTabPage = this.getPage(this._selectedPage)).isVisible()) {
                Rectangle rectangle3 = customTabPage.getBounds();
                n3 = rectangle3.x;
                n4 = n3 + rectangle3.width - 1;
            }
            if (this._position == 3) {
                if (n3 > rectangle.x) {
                    graphics2D.drawLine(rectangle.x, rectangle.y, n3, rectangle.y);
                }
                graphics2D.drawLine(n4, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
            } else {
                if (n3 > rectangle.x) {
                    graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, n3, rectangle.y + rectangle.height - 1);
                }
                graphics2D.drawLine(n4, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            }
        }
        this.clearCachedFont();
    }

    private Rectangle getTabBounds() {
        Insets insets = this.getInsets();
        return new Rectangle(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    static void wa$_isListeningGlobalMouseMovements(CustomTab customTab, boolean bl) {
        customTab._isListeningGlobalMouseMovements = bl;
    }

    static void wa$_hoverPage(CustomTab customTab, int n) {
        customTab._hoverPage = n;
    }

    static void mav$updateHoverCloseButton(CustomTab customTab) {
        customTab.updateHoverCloseButton();
    }

    static int ra$_selectedPage(CustomTab customTab) {
        return customTab._selectedPage;
    }

    static int ra$_hoverPage(CustomTab customTab) {
        return customTab._hoverPage;
    }

    static ActionListener ra$_closeAction(CustomTab customTab) {
        return customTab._closeAction;
    }

    public final class 2
    extends AbstractAction {
        private final /* synthetic */ ActionListener v$closeActionListener;
        final /* synthetic */ CustomTab this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$closeActionListener.actionPerformed(actionEvent);
        }

        public 2(CustomTab customTab, ActionListener actionListener) {
            this.v$closeActionListener = actionListener;
            this.this$0 = customTab;
        }
    }

    public final class 1
    extends MouseAdapter {
        private final /* synthetic */ GlobalMouseDispatcher v$globalMouseDispatcher;
        final /* synthetic */ CustomTab this$0;

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (!SwingUtilities.isDescendingFrom(component, this.this$0)) {
                this.v$globalMouseDispatcher.removeMouseListener(this);
                CustomTab.wa$_isListeningGlobalMouseMovements(this.this$0, false);
                CustomTab.wa$_hoverPage(this.this$0, -1);
                CustomTab.mav$updateHoverCloseButton(this.this$0);
            }
        }

        public 1(CustomTab customTab, GlobalMouseDispatcher globalMouseDispatcher) {
            this.v$globalMouseDispatcher = globalMouseDispatcher;
            this.this$0 = customTab;
        }
    }

    private final class CloseButton
    extends SmallSquareButton {
        CloseButton() {
            super(IdeArb.getInstance(), 463, 464);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
            this.setVisible(false);
            this.setModel(new DefaultButtonModel());
        }

        protected void configurePropertiesFromAction(Action action) {
            String string;
            String string2 = string = action != null ? (String)action.getValue("ShortDescription") : null;
            if (string != null) {
                this.setToolTipText(string);
            }
        }

        protected ActionListener createActionListener() {
            return new ForwardCloseActionEvent(null);
        }

        private final class ForwardCloseActionEvent
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ButtonModel buttonModel = (ButtonModel)actionEvent.getSource();
                String string = buttonModel.getActionCommand();
                if (string.equals(CustomTab.CLOSE_SELECTED_COMMAND)) {
                    n = CustomTab.ra$_selectedPage(CustomTab.this);
                } else if (string.equals(CustomTab.CLOSE_HOVER_COMMAND)) {
                    n = CustomTab.ra$_hoverPage(CustomTab.this);
                } else {
                    return;
                }
                CustomTab.wa$_hoverPage(CustomTab.this, -1);
                CustomTabPage customTabPage = CustomTab.this.getPage(n);
                ActionEvent actionEvent2 = new ActionEvent(customTabPage, 1001, "", actionEvent.getWhen(), actionEvent.getModifiers());
                CustomTab.ra$_closeAction(CustomTab.this).actionPerformed(actionEvent2);
            }

            private ForwardCloseActionEvent() {
            }

            ForwardCloseActionEvent(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

