/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.customtab;

import java.awt.Rectangle;
import javax.swing.Icon;
import oracle.ide.util.BitField;

public abstract class CustomTabPage {
    private static final int FLAG_COMPRESSED = 1;
    private static final int FLAG_ENABLED = 2;
    private static final int FLAG_DIRTY = 4;
    private static final int FLAG_HIGHLIGHTED = 8;
    private static final int FLAG_VISIBLE = 16;
    private static final int FLAG_CONDENSED = 32;
    private static final int FLAG_CLOSEABLE = 64;
    private final Rectangle _rectangle;
    private int _flags;

    void $init$() {
        this._rectangle = new Rectangle();
        this._flags = 82;
    }

    public abstract Icon getIcon();

    public abstract String getLabel();

    public abstract String getLongLabel();

    public abstract String getTooltip();

    public CustomTabPage() {
        this.$init$();
    }

    public final Rectangle getBounds() {
        return this._rectangle;
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        this._rectangle.setBounds(n, n2, n3, n4);
    }

    private int getFlags() {
        return this._flags;
    }

    public void setFlags(int n) {
        this._flags = n;
    }

    private boolean hasFlag(int n) {
        return BitField.isSet(this.getFlags(), n);
    }

    private void setFlag(int n, boolean bl) {
        int n2 = this.getFlags();
        int n3 = bl ? BitField.set(n2, n) : BitField.unset(n2, n);
        this.setFlags(n3);
    }

    public boolean isCompressed() {
        return this.hasFlag(1);
    }

    public void setCompressed(boolean bl) {
        this.setFlag(1, bl);
    }

    public void setEnabled(boolean bl) {
        this.setFlag(2, bl);
    }

    public boolean isEnabled() {
        return this.hasFlag(2);
    }

    public void setDirty(boolean bl) {
        this.setFlag(4, bl);
    }

    public boolean isDirty() {
        return this.hasFlag(4);
    }

    public void setHighlighted(boolean bl) {
        this.setFlag(8, bl);
    }

    public boolean isHighlighted() {
        return this.hasFlag(8);
    }

    public boolean isVisible() {
        return this.hasFlag(16);
    }

    public void setVisible(boolean bl) {
        this.setFlag(16, bl);
    }

    public boolean isCondensed() {
        return this.hasFlag(32);
    }

    public void setCondensed(boolean bl) {
        this.setFlag(32, bl);
    }

    public boolean isCloseable() {
        return this.hasFlag(64);
    }

    public void setCloseable(boolean bl) {
        this.setFlag(64, bl);
    }
}

