/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.JTreeCellRenderer;
import oracle.ide.controls.tree.JTreeListener;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.controls.tree.TreeCellRadioSelectedListener;

public class CustomJTree
extends JTree {
    private final JTreeListener _treeListener;
    private final JTreeCellRenderer _treeCellRenderer;
    private boolean _trackingKeyboard;
    MouseEvent _currentMouseEvent;

    void $init$() {
        this._treeListener = new JTreeListener();
        this._treeCellRenderer = new JTreeCellRenderer();
        this._trackingKeyboard = false;
        this._currentMouseEvent = null;
    }

    public CustomJTree() {
        this(new JMutableTreeNode());
    }

    public CustomJTree(JMutableTreeNode jMutableTreeNode) {
        this(jMutableTreeNode, false);
    }

    public CustomJTree(JMutableTreeNode jMutableTreeNode, boolean bl) {
        this(new DefaultTreeModel(jMutableTreeNode, bl));
    }

    public CustomJTree(TreeModel treeModel) {
        this(treeModel, true);
    }

    public CustomJTree(TreeModel treeModel, boolean bl) {
        super(treeModel);
        this.$init$();
        if (!bl) {
            this.setRowHeight(0);
        }
        this.setCellRenderer(this._treeCellRenderer);
        this.addMouseListener(this._treeListener);
        this.addTreeWillExpandListener(this._treeListener);
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
    }

    public void addTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._treeListener.addTreeCellCheckedListener(treeCellCheckedListener);
    }

    public void removeTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._treeListener.removeTreeCellCheckedListener(treeCellCheckedListener);
    }

    public void addTreeCellRadioSelectedListener(TreeCellRadioSelectedListener treeCellRadioSelectedListener) {
        this._treeListener.addTreeCellRadioSelectedListener(treeCellRadioSelectedListener);
    }

    public void removeTreeCellCheckedListener(TreeCellRadioSelectedListener treeCellRadioSelectedListener) {
        this._treeListener.removeTreeCellRadioSelectedListener(treeCellRadioSelectedListener);
    }

    public void enableToolTips(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public boolean isPropagateCheckState() {
        return this._treeListener.isPropagateCheckState();
    }

    public void setPropagateCheckState(boolean bl) {
        this._treeListener.setPropagateCheckState(bl);
    }

    public JTreeCellData getLeadSelectionData() {
        TreePath treePath = this.getLeadSelectionPath();
        return CustomJTree.getLastPathComponentData(treePath);
    }

    public void expandAllRows() {
        TreePath treePath = this.getSelectionPath();
        int n = 0;
        while (n < this.getRowCount()) {
            this.expandRow(n++);
        }
        if (treePath != null) {
            this.setSelectionPath(treePath);
        } else {
            this.setSelectionRow(0);
        }
    }

    protected void fireCellChecked(JMutableTreeNode jMutableTreeNode) {
        this._treeListener.fireCellChecked(jMutableTreeNode);
    }

    protected void fireCellUnchecked(JMutableTreeNode jMutableTreeNode) {
        this._treeListener.fireCellUnchecked(jMutableTreeNode);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this._trackingKeyboard && keyEvent.getKeyCode() == 27) {
            this._trackingKeyboard = false;
            this._treeListener.keyReleaseRow(this, -1);
            return;
        }
        if (keyEvent.getKeyCode() != 32) {
            super.processKeyEvent(keyEvent);
            return;
        }
        int n = this._treeCellRenderer.getLastRowWithFocus();
        if (n < 0) {
            return;
        }
        switch (keyEvent.getID()) {
            case 401: {
                if (this._trackingKeyboard) break;
                this._trackingKeyboard = true;
                this._treeListener.keyPressRow(this, n);
                break;
            }
            case 402: {
                if (!this._trackingKeyboard) break;
                this._trackingKeyboard = false;
                this._treeListener.keyReleaseRow(this, n);
                break;
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this._trackingKeyboard && focusEvent.getSource() == this) {
            this._trackingKeyboard = false;
            this._treeListener.keyReleaseRow(this, -1);
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this._trackingKeyboard) {
            return;
        }
        this._currentMouseEvent = mouseEvent;
        super.processMouseEvent(mouseEvent);
        this._currentMouseEvent = null;
    }

    public static void updateNodes(TreePath treePath) {
        Object object;
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof JMutableTreeNode) {
            ((JMutableTreeNode)object).updateNodes();
        }
    }

    public static JTreeCellData getLastPathComponentData(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        return object instanceof JMutableTreeNode ? ((JMutableTreeNode)object).getModel() : null;
    }
}

