/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.TriStateBoolean;

public class JMutableTreeNode
extends DefaultMutableTreeNode
implements Comparable {
    protected JTreeCellData _treeCellData;

    public JMutableTreeNode() {
        this((String)null);
    }

    public JMutableTreeNode(String string) {
        this(new JTreeCellData(string));
    }

    public JMutableTreeNode(JTreeCellData jTreeCellData) {
        this(jTreeCellData, true);
    }

    public JMutableTreeNode(JTreeCellData jTreeCellData, boolean bl) {
        super(jTreeCellData, bl);
        this._treeCellData = jTreeCellData;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JMutableTreeNode)) {
            throw new ClassCastException("In order to sort, all tree nodes must be an instance of JMutableTreeNode.");
        }
        return this.compareTo((JMutableTreeNode)object);
    }

    public void selectDescendants(boolean bl) {
        JTreeCellData jTreeCellData = this.getModel();
        if (jTreeCellData.getHasRadioButton()) {
            jTreeCellData.setInternalRadioEnabled(bl);
        }
        if (!jTreeCellData.isEnabled()) {
            return;
        }
        jTreeCellData.setCheckBoxState(bl);
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof JMutableTreeNode)) continue;
            ((JMutableTreeNode)treeNode).selectDescendants(bl);
        }
    }

    public TriStateBoolean descendingUpdateNodes() {
        JTreeCellData jTreeCellData = this.getModel();
        if (this.getChildCount() <= 0) {
            if (jTreeCellData.getHasRadioButton()) {
                return TriStateBoolean.getState(jTreeCellData.isRadioButtonSelected());
            }
            return jTreeCellData.getCheckBoxState();
        }
        TriStateBoolean triStateBoolean = TriStateBoolean.UNDEF;
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof JMutableTreeNode)) continue;
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeNode;
            TriStateBoolean triStateBoolean2 = jMutableTreeNode.descendingUpdateNodes();
            if (jMutableTreeNode.getModel().getHasRadioButton()) {
                if (triStateBoolean2.isTrue() && jMutableTreeNode.getModel().isRadioButtonEnabled() && jMutableTreeNode.getModel().isInternalRadioEnabled()) {
                    triStateBoolean = TriStateBoolean.TRUE;
                    break;
                }
                triStateBoolean = TriStateBoolean.FALSE;
                continue;
            }
            triStateBoolean = triStateBoolean.aggregate(triStateBoolean2);
        }
        if (triStateBoolean.isUndef()) {
            triStateBoolean = TriStateBoolean.FALSE;
        }
        jTreeCellData.setCheckBoxState(triStateBoolean);
        return triStateBoolean;
    }

    public void ascendingUpdateNodes() {
        TreeNode treeNode = this.getParent();
        TriStateBoolean triStateBoolean = TriStateBoolean.UNDEF;
        while (treeNode != null) {
            if (treeNode instanceof JMutableTreeNode) {
                JTreeCellData jTreeCellData;
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treeNode;
                if (!triStateBoolean.isTriState()) {
                    Enumeration<TreeNode> enumeration = jMutableTreeNode.children();
                    while (enumeration.hasMoreElements()) {
                        TriStateBoolean triStateBoolean2;
                        JTreeCellData jTreeCellData2;
                        TreeNode treeNode2 = enumeration.nextElement();
                        if (treeNode2 instanceof JMutableTreeNode && (jTreeCellData2 = ((JMutableTreeNode)treeNode2).getModel()).getHasCheckBox() && (triStateBoolean = triStateBoolean.aggregate(triStateBoolean2 = jTreeCellData2.getCheckBoxState())).isTriState()) break;
                    }
                }
                if ((jTreeCellData = jMutableTreeNode.getModel()) != null) {
                    jTreeCellData.setCheckBoxState(triStateBoolean);
                }
            }
            treeNode = treeNode.getParent();
        }
    }

    public void updateNodes() {
        this.descendingUpdateNodes();
        this.ascendingUpdateNodes();
    }

    public JMutableTreeNode unselectSibling() {
        if (!(this.getParent() instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getParent();
        TreeNode treeNode = defaultMutableTreeNode.getFirstChild();
        while (treeNode != null) {
            JTreeCellData jTreeCellData;
            if (treeNode instanceof JMutableTreeNode && (jTreeCellData = ((JMutableTreeNode)treeNode).getModel()).isRadioButtonSelected()) {
                jTreeCellData.setRadioButtonSelected(false);
                return (JMutableTreeNode)treeNode;
            }
            treeNode = ((DefaultMutableTreeNode)treeNode).getNextSibling();
        }
        return null;
    }

    public int compareTo(JMutableTreeNode jMutableTreeNode) {
        if (jMutableTreeNode == null) {
            return 1;
        }
        JTreeCellData jTreeCellData = jMutableTreeNode._treeCellData;
        if (this._treeCellData == null) {
            if (jTreeCellData == null) {
                return 0;
            }
            return -1;
        }
        if (jTreeCellData == null) {
            return 1;
        }
        return this._treeCellData.compareTo(jTreeCellData);
    }

    public JMutableTreeNode add(JTreeCellData jTreeCellData) {
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode(jTreeCellData);
        this.add(jMutableTreeNode);
        return jMutableTreeNode;
    }

    public JTreeCellData getModel() {
        return this._treeCellData;
    }

    public void setModel(JTreeCellData jTreeCellData) {
        this._treeCellData = jTreeCellData;
    }

    public void sortChildren() {
        this.sortChildren(0);
    }

    public void sortChildren(int n) {
        if (n < 0 || this.children == null) {
            return;
        }
        Collections.sort(this.children);
        if (n-- > 0) {
            for (Object e : this.children) {
                ((JMutableTreeNode)e).sortChildren(n);
            }
        }
    }

    public void sortDescendents() {
        this.sortChildren(Integer.MAX_VALUE);
    }
}

