/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import javax.swing.Icon;
import oracle.ide.util.TriStateBoolean;

public class JTreeCellData
implements Comparable {
    protected String _text;
    protected boolean _isTextEnabled;
    protected boolean _isTextSelectable;
    protected String _toolTipText;
    protected Icon _icon;
    protected boolean _useDefaultIcons;
    protected boolean _hasCheckBox;
    protected boolean _hasRadioButton;
    protected boolean _isRadioButtonEnabled;
    protected boolean _isRadioButtonSelected;
    protected TriStateBoolean _checkBoxState;
    protected boolean _isCheckBoxEnabled;
    protected boolean _isCheckBoxSelectable;
    protected boolean _isArmed;
    protected boolean _isPressed;
    protected Object _userObject;
    protected int _heightAdj;
    private boolean _internalRadioEnabled;

    void $init$() {
        this._checkBoxState = TriStateBoolean.FALSE;
        this._isArmed = false;
        this._isPressed = false;
        this._userObject = null;
        this._internalRadioEnabled = true;
    }

    public JTreeCellData(String string) {
        this(null, string);
    }

    public JTreeCellData(Icon icon, String string) {
        this(icon, string, false);
    }

    public JTreeCellData(Icon icon, String string, boolean bl) {
        this(icon, string, bl, TriStateBoolean.FALSE);
    }

    public JTreeCellData(Icon icon, String string, boolean bl, TriStateBoolean triStateBoolean) {
        this.$init$();
        if (triStateBoolean == null) {
            throw new NullPointerException();
        }
        this._icon = icon;
        this._text = string;
        this._hasCheckBox = bl;
        this._checkBoxState = triStateBoolean;
        this.setEnabled(true);
    }

    public int compareTo(Object object) {
        if (!(object instanceof JTreeCellData)) {
            throw new ClassCastException("In order to sort, all tree nodes must be an instance of JMutableTreeNode.");
        }
        return this.compareTo((JTreeCellData)object);
    }

    public int compareTo(JTreeCellData jTreeCellData) {
        if (jTreeCellData == null) {
            return 1;
        }
        String string = jTreeCellData._text;
        if (this._text == null) {
            if (string == null) {
                return 0;
            }
            return -1;
        }
        if (string == null) {
            return 1;
        }
        return this._text.compareTo(string);
    }

    public void setEnabled(boolean bl) {
        this.setEnabled(bl, bl);
    }

    public void setEnabled(boolean bl, boolean bl2) {
        this._isTextEnabled = bl;
        this._isTextSelectable = bl2;
        this._isCheckBoxEnabled = bl;
        this._isCheckBoxSelectable = bl;
        this._isRadioButtonEnabled = bl;
    }

    public boolean isEnabled() {
        return this._isTextEnabled && (this._isCheckBoxEnabled || this._isRadioButtonEnabled);
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public boolean isTextEnabled() {
        return this._isTextEnabled;
    }

    public void setTextEnabled(boolean bl) {
        this._isTextEnabled = bl;
    }

    public boolean isTextSelectable() {
        return this._isTextSelectable;
    }

    public void setTextSelectable(boolean bl) {
        this._isTextSelectable = bl;
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String string) {
        this._toolTipText = string;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public boolean getUseDefaultIcons() {
        return this._useDefaultIcons;
    }

    public void setUseDefaultIcons(boolean bl) {
        this._useDefaultIcons = bl;
    }

    public boolean getHasCheckBox() {
        return this._hasCheckBox;
    }

    public void setHasCheckBox(boolean bl) {
        this._hasCheckBox = bl;
    }

    public boolean getHasRadioButton() {
        return this._hasRadioButton;
    }

    public void setRadioButtonEnabled(boolean bl) {
        this._isRadioButtonEnabled = bl;
    }

    public void setRadioButtonSelected(boolean bl) {
        this._isRadioButtonSelected = bl;
    }

    public boolean isRadioButtonEnabled() {
        return this._isRadioButtonEnabled;
    }

    public boolean isRadioButtonSelected() {
        return this._isRadioButtonSelected;
    }

    public void setHasRadioButton(boolean bl) throws IllegalStateException {
        if (this.getHasCheckBox()) {
            throw new IllegalStateException();
        }
        this._hasRadioButton = bl;
    }

    public TriStateBoolean getCheckBoxState() {
        return this._checkBoxState;
    }

    public void setCheckBoxState(TriStateBoolean triStateBoolean) {
        this._checkBoxState = triStateBoolean;
    }

    public void setCheckBoxState(boolean bl) {
        this.setCheckBoxState(bl ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
    }

    public boolean isCheckBoxEnabled() {
        return this._isCheckBoxEnabled;
    }

    public void setCheckBoxEnabled(boolean bl) {
        this._isCheckBoxEnabled = bl;
    }

    public boolean isCheckBoxSelectable() {
        return this._isCheckBoxSelectable;
    }

    public void setCheckBoxSelectable(boolean bl) {
        this._isCheckBoxSelectable = bl;
    }

    public boolean isArmed() {
        return this._isArmed;
    }

    public void setArmed(boolean bl) {
        this._isArmed = bl;
    }

    public boolean isPressed() {
        return this._isPressed;
    }

    public void setPressed(boolean bl) {
        this._isPressed = bl;
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public int getHeightAdjustment() {
        return this._heightAdj;
    }

    public void setHeightAdjustment(int n) {
        this._heightAdj = n;
    }

    boolean isInternalRadioEnabled() {
        return this._internalRadioEnabled;
    }

    void setInternalRadioEnabled(boolean bl) {
        this._internalRadioEnabled = bl;
    }
}

