/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.Component;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JLabeledRadioButton;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.TriStateBoolean;

class JTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final boolean _isMotif;
    private int _lastRowWithFocus;
    private JLabeledCheckBox _lcb;
    private JSelectableLabel _sl;
    private JLabeledRadioButton _lrb;

    void $init$() {
        this._lastRowWithFocus = -1;
        this._lcb = new JLabeledCheckBox();
        this._sl = new JSelectableLabel();
        this._lrb = new JLabeledRadioButton();
    }

    JTreeCellRenderer() {
        this.$init$();
        this._isMotif = "Motif".equalsIgnoreCase(UIManager.getLookAndFeel().getID());
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (bl4) {
            this._lastRowWithFocus = n;
        }
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (!(object instanceof JMutableTreeNode)) {
            return this;
        }
        JTreeCellData jTreeCellData = ((JMutableTreeNode)object).getModel();
        if (jTreeCellData == null) {
            return this;
        }
        boolean bl5 = jTreeCellData.getHasCheckBox();
        boolean bl6 = jTreeCellData.getHasRadioButton();
        if (bl5) {
            this._lcb.checkBox.setBorderPaintedFlat(true);
            this._lcb.checkBox.setFocusPainted(false);
            this._lcb.label.setHeightAdjustment(jTreeCellData.getHeightAdjustment());
            if (!jTree.isEnabled()) {
                this._lcb.label.setEnabled(false);
                this._lcb.checkBox.setEnabled(false);
            } else {
                this._lcb.label.setEnabled(jTreeCellData.isTextEnabled());
                this._lcb.checkBox.setEnabled(jTreeCellData.isCheckBoxEnabled());
            }
            this._lcb.label.setSelected(bl);
            this._lcb.label.setText(jTreeCellData.getText());
            this._lcb.label.setIcon(jTreeCellData.getIcon());
            this._lcb.label.setHasFocus(bl4);
            this._lcb.setToolTipText(jTreeCellData.getToolTipText());
            this._lcb.getAccessibleContext().setAccessibleName(jTreeCellData.getText());
            if (bl4) {
                this._lcb.getAccessibleContext().firePropertyChange("AccessibleState", bl ? null : AccessibleState.CHECKED, bl ? AccessibleState.CHECKED : null);
            }
            TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
            ButtonModel buttonModel = this._lcb.checkBox.getModel();
            if (!triStateBoolean.isTriState()) {
                JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, triStateBoolean.booleanValue(), jTreeCellData);
            } else if (jTreeCellData.isArmed() && jTreeCellData.isPressed()) {
                if (!this._isMotif) {
                    this._lcb.checkBox.setEnabled(false);
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, true, true);
                } else {
                    this._lcb.checkBox.setEnabled(true);
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, false, true, true);
                }
            } else {
                this._lcb.checkBox.setEnabled(true);
                if (!this._isMotif) {
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, true, true);
                } else {
                    JTreeCellRenderer.setCheckBoxState(this._lcb.checkBox, true, false, false);
                }
            }
            return this._lcb;
        }
        if (bl6) {
            this._lrb.label.setHeightAdjustment(jTreeCellData.getHeightAdjustment());
            if (!jTree.isEnabled() || !jTreeCellData.isInternalRadioEnabled()) {
                this._lrb.label.setEnabled(false);
                this._lrb.radioButton.setEnabled(false);
            } else {
                this._lrb.label.setEnabled(jTreeCellData.isTextEnabled());
                this._lrb.radioButton.setEnabled(jTreeCellData.isRadioButtonEnabled());
            }
            this._lrb.label.setSelected(bl);
            this._lrb.label.setText(jTreeCellData.getText());
            this._lrb.label.setIcon(jTreeCellData.getIcon());
            this._lrb.label.setHasFocus(bl4);
            this._lrb.radioButton.setSelected(jTreeCellData.isRadioButtonSelected());
            this._lrb.setToolTipText(jTreeCellData.getToolTipText());
            this._lrb.getAccessibleContext().setAccessibleName(jTreeCellData.getText());
            JTreeCellRenderer.setButtonModelState(this._lrb.radioButton, jTreeCellData);
            return this._lrb;
        }
        this._sl.setHeightAdjustment(jTreeCellData.getHeightAdjustment());
        this._sl.setEnabled(jTree.isEnabled() ? jTreeCellData.isTextEnabled() : false);
        this._sl.setSelected(bl);
        this._sl.setText(jTreeCellData.getText());
        this._sl.getAccessibleContext().setAccessibleName(jTreeCellData.getText());
        this._sl.setIcon(jTreeCellData.getIcon());
        this._sl.setHasFocus(bl4);
        this._sl.setToolTipText(jTreeCellData.getToolTipText());
        return this._sl;
    }

    private static void setCheckBoxState(JCheckBox jCheckBox, boolean bl, boolean bl2, boolean bl3) {
        JTreeCellRenderer.setCheckBoxSelected(jCheckBox, bl);
        JTreeCellRenderer.setButtonModelState(jCheckBox, bl2, bl3);
    }

    private static void setCheckBoxState(JCheckBox jCheckBox, boolean bl, JTreeCellData jTreeCellData) {
        JTreeCellRenderer.setCheckBoxSelected(jCheckBox, bl);
        JTreeCellRenderer.setButtonModelState(jCheckBox, jTreeCellData);
    }

    private static void setCheckBoxSelected(JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
    }

    private static void setButtonModelState(AbstractButton abstractButton, JTreeCellData jTreeCellData) {
        JTreeCellRenderer.setButtonModelState(abstractButton, jTreeCellData.isPressed(), jTreeCellData.isArmed());
    }

    private static void setButtonModelState(AbstractButton abstractButton, boolean bl, boolean bl2) {
        ButtonModel buttonModel = abstractButton.getModel();
        buttonModel.setArmed(bl2);
        buttonModel.setPressed(bl);
    }

    public int getLastRowWithFocus() {
        return this._lastRowWithFocus;
    }
}

