/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls.tree;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.ide.controls.JLabeledCheckBox;
import oracle.ide.controls.JLabeledRadioButton;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.controls.tree.TreeCellRadioSelectedEvent;
import oracle.ide.controls.tree.TreeCellRadioSelectedListener;
import oracle.ide.util.TriStateBoolean;

class JTreeListener
implements TreeWillExpandListener,
MouseMotionListener,
MouseListener {
    private final EventListenerList _listenerList;
    private boolean _isArmed;
    private long _pressedTime;
    private int _pressedRow;
    private int _checkOrRadioWidth;
    private boolean _trackingMousePress;
    private boolean _trackingKeyPress;
    private static final int BOUNCE_TIME = 150;
    private boolean _propagateCheckState;

    void $init$() {
        this._listenerList = new EventListenerList();
        this._isArmed = false;
        this._pressedTime = -1;
        this._pressedRow = -1;
        this._checkOrRadioWidth = -1;
        this._trackingMousePress = false;
        this._trackingKeyPress = false;
        this._propagateCheckState = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._trackingKeyPress) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                this.mouseReleased(mouseEvent);
            }
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this._pressedTime = mouseEvent.getWhen();
        JTree jTree = (JTree)mouseEvent.getComponent();
        this.pressRow(jTree, this.getCurrentRow(mouseEvent));
        if (this._pressedRow >= 0) {
            this._trackingMousePress = true;
            jTree.addMouseMotionListener(this);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._trackingKeyPress) {
            return;
        }
        long l = mouseEvent.getWhen();
        JTree jTree = (JTree)mouseEvent.getComponent();
        this.releaseRow(jTree, this.getCurrentRow(mouseEvent), l);
        this._trackingMousePress = false;
        jTree.removeMouseMotionListener(this);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._pressedRow == -1) {
            return;
        }
        int n = this.getCurrentRow(mouseEvent);
        if (n != this._pressedRow && this._isArmed || n == this._pressedRow && !this._isArmed) {
            JTree jTree = (JTree)mouseEvent.getComponent();
            TreePath treePath = jTree.getPathForRow(this._pressedRow);
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
            JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
            this._isArmed = n == this._pressedRow;
            jTreeCellData.setArmed(this._isArmed);
            Rectangle rectangle = jTree.getRowBounds(this._pressedRow);
            jTree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        CustomJTree customJTree = (CustomJTree)treeExpansionEvent.getSource();
        MouseEvent mouseEvent = customJTree._currentMouseEvent;
        if (mouseEvent == null || this.getCurrentRow(mouseEvent) < 0) {
            return;
        }
        throw new ExpandVetoException(treeExpansionEvent);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        this.treeWillExpand(treeExpansionEvent);
    }

    void addTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._listenerList.add(TreeCellCheckedListener.class, treeCellCheckedListener);
    }

    void removeTreeCellCheckedListener(TreeCellCheckedListener treeCellCheckedListener) {
        this._listenerList.remove(TreeCellCheckedListener.class, treeCellCheckedListener);
    }

    void addTreeCellRadioSelectedListener(TreeCellRadioSelectedListener treeCellRadioSelectedListener) {
        this._listenerList.add(TreeCellRadioSelectedListener.class, treeCellRadioSelectedListener);
    }

    void removeTreeCellRadioSelectedListener(TreeCellRadioSelectedListener treeCellRadioSelectedListener) {
        this._listenerList.remove(TreeCellRadioSelectedListener.class, treeCellRadioSelectedListener);
    }

    void fireCellChecked(JMutableTreeNode jMutableTreeNode) {
        Object[] objectArray = this._listenerList.getListenerList();
        TreeCellCheckedEvent treeCellCheckedEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TreeCellCheckedListener.class && treeCellCheckedEvent == null) {
                treeCellCheckedEvent = new TreeCellCheckedEvent(jMutableTreeNode);
                ((TreeCellCheckedListener)objectArray[n + 1]).cellChecked(treeCellCheckedEvent);
            }
            n -= 2;
        }
    }

    void fireCellUnchecked(JMutableTreeNode jMutableTreeNode) {
        Object[] objectArray = this._listenerList.getListenerList();
        TreeCellCheckedEvent treeCellCheckedEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TreeCellCheckedListener.class && treeCellCheckedEvent == null) {
                treeCellCheckedEvent = new TreeCellCheckedEvent(jMutableTreeNode);
                ((TreeCellCheckedListener)objectArray[n + 1]).cellUnchecked(treeCellCheckedEvent);
            }
            n -= 2;
        }
    }

    void fireRadioSelected(JMutableTreeNode jMutableTreeNode) {
        if (jMutableTreeNode == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        TreeCellRadioSelectedEvent treeCellRadioSelectedEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TreeCellRadioSelectedListener.class && treeCellRadioSelectedEvent == null) {
                treeCellRadioSelectedEvent = new TreeCellRadioSelectedEvent(jMutableTreeNode);
                ((TreeCellRadioSelectedListener)objectArray[n + 1]).cellSelected(treeCellRadioSelectedEvent);
            }
            n -= 2;
        }
    }

    void fireRadioUnselected(JMutableTreeNode jMutableTreeNode) {
        if (jMutableTreeNode == null) {
            return;
        }
        Object[] objectArray = this._listenerList.getListenerList();
        TreeCellRadioSelectedEvent treeCellRadioSelectedEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == TreeCellRadioSelectedListener.class && treeCellRadioSelectedEvent == null) {
                treeCellRadioSelectedEvent = new TreeCellRadioSelectedEvent(jMutableTreeNode);
                ((TreeCellRadioSelectedListener)objectArray[n + 1]).cellUnselected(treeCellRadioSelectedEvent);
            }
            n -= 2;
        }
    }

    void keyPressRow(JTree jTree, int n) {
        if (this._trackingMousePress || this._trackingKeyPress) {
            return;
        }
        this._trackingKeyPress = true;
        this.pressRow(jTree, n);
    }

    void keyReleaseRow(JTree jTree, int n) {
        if (this._trackingMousePress || !this._trackingKeyPress) {
            return;
        }
        this._trackingKeyPress = false;
        this.releaseRow(jTree, n, 0L);
    }

    boolean isPropagateCheckState() {
        return this._propagateCheckState;
    }

    void setPropagateCheckState(boolean bl) {
        this._propagateCheckState = bl;
    }

    private void pressRow(JTree jTree, int n) {
        if (n < 0) {
            this._pressedRow = -1;
            return;
        }
        if (this._pressedRow >= 0) {
            throw new IllegalStateException("Can't invoke pressRow() when a different row is already being pressed");
        }
        TreePath treePath = jTree.getPathForRow(n);
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
        boolean bl = jTreeCellData.getHasCheckBox();
        boolean bl2 = jTreeCellData.isCheckBoxSelectable();
        boolean bl3 = jTreeCellData.getHasRadioButton();
        boolean bl4 = jTreeCellData.isRadioButtonEnabled();
        boolean bl5 = jTreeCellData.isInternalRadioEnabled();
        if (!(bl && bl2 || bl3 && bl4 && bl5)) {
            this._pressedRow = -1;
            return;
        }
        this._isArmed = true;
        jTreeCellData.setArmed(true);
        jTreeCellData.setPressed(true);
        jTree.addSelectionRow(n);
        this._pressedRow = n;
        Rectangle rectangle = jTree.getRowBounds(this._pressedRow);
        jTree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void releaseRow(JTree jTree, int n, long l) {
        this._checkOrRadioWidth = -1;
        this._isArmed = false;
        if (this._pressedRow < 0) {
            this._pressedTime = -1;
            return;
        }
        long l2 = l > 0L ? l - this._pressedTime : 0L;
        TreePath treePath = jTree.getPathForRow(this._pressedRow);
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
        jTreeCellData.setPressed(false);
        jTreeCellData.setArmed(false);
        if (n >= 0 && (this._pressedRow == n || l2 <= 150L)) {
            if (jTreeCellData.getHasCheckBox()) {
                TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
                TriStateBoolean triStateBoolean2 = triStateBoolean.toggle();
                jTreeCellData.setCheckBoxState(triStateBoolean2);
                boolean bl = triStateBoolean2.booleanValue();
                if (this.isPropagateCheckState()) {
                    jMutableTreeNode.selectDescendants(bl);
                }
                if (bl) {
                    this.fireCellChecked(jMutableTreeNode);
                } else {
                    this.fireCellUnchecked(jMutableTreeNode);
                }
                if (this.isPropagateCheckState()) {
                    jMutableTreeNode.updateNodes();
                }
            } else if (jTreeCellData.getHasRadioButton() && !jTreeCellData.isRadioButtonSelected() && jTreeCellData.isRadioButtonEnabled()) {
                JMutableTreeNode jMutableTreeNode2 = jMutableTreeNode.unselectSibling();
                this.fireRadioUnselected(jMutableTreeNode2);
                jTreeCellData.setRadioButtonSelected(true);
                this.fireRadioSelected(jMutableTreeNode);
            }
        }
        jTree.repaint();
        this._pressedRow = -1;
    }

    private int getCurrentRow(MouseEvent mouseEvent) {
        int n;
        int n2;
        JTree jTree = (JTree)mouseEvent.getComponent();
        int n3 = jTree.getRowForLocation(n2 = mouseEvent.getX(), n = mouseEvent.getY());
        if (n3 < 0) {
            return -1;
        }
        if (this._checkOrRadioWidth < 0) {
            TreePath treePath = jTree.getPathForRow(n3);
            Object object = treePath.getLastPathComponent();
            TreeCellRenderer treeCellRenderer = jTree.getCellRenderer();
            Component component = treeCellRenderer.getTreeCellRendererComponent(jTree, object, jTree.isRowSelected(n3), jTree.isExpanded(n3), jTree.getModel().isLeaf(object), n3, true);
            this._checkOrRadioWidth = component instanceof JLabeledCheckBox ? ((JLabeledCheckBox)component).checkBox.getWidth() : (component instanceof JLabeledRadioButton ? ((JLabeledRadioButton)component).radioButton.getWidth() : 0);
        }
        Rectangle rectangle = jTree.getRowBounds(n3);
        if (n2 > rectangle.x + this._checkOrRadioWidth) {
            return -1;
        }
        return n3;
    }

    JTreeListener() {
        this.$init$();
    }
}

