/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.datatransfer.TransferUtils;

public class TransferableContext
extends ArrayList
implements Transferable {
    public static final DataFlavor contextFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + TransferableContext.class.getName(), "IDE Context");
    private static final DataFlavor[] flavors = new DataFlavor[]{contextFlavor, TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER};
    private Context context;

    public TransferableContext(Context context) {
        if (context == null) {
            return;
        }
        this.context = context;
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length < 1) {
            return;
        }
        this.ensureCapacity(elementArray.length);
        int n = 0;
        while (n < elementArray.length) {
            this.add(elementArray[n]);
            ++n;
        }
    }

    public Context getContext() {
        return this.context;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(contextFlavor)) {
            return this;
        }
        if (TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER.equals(dataFlavor)) {
            return null;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(contextFlavor) || TransferUtils.FLAVOR_SAFE_TO_FETCH_CONTENTS_EARLY_MARKER.equals(dataFlavor);
    }
}

