/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.resource.DialogsArb;
import oracle.ide.resource.IdeIcons;
import oracle.javatools.util.SwingUtils;

public abstract class DialogUtil {
    private static final ArrayList _urlFilters = new ArrayList();
    private static URLFilter _workspaceFilter;
    private static URLFilter _projectFilter;
    private static URLFilter _defaultFilter;
    private static SizeKeeperCallback _standardKeeper;

    static {
        _standardKeeper = new SizeKeeperCallback("file.chooser");
    }

    public static URLChooser newURLChooser() {
        return DialogUtil.newURLChooser(Context.newIdeContext());
    }

    public static URLChooser newURLChooser(Context context) {
        return DialogUtil.newURLChooser(context, null);
    }

    public static URLChooser newURLChooser(URL uRL) {
        return DialogUtil.newURLChooser(null, uRL);
    }

    public static URLChooser newURLChooser(Context context, URL uRL) {
        URLChooser uRLChooser = new URLChooser();
        DialogUtil.initURLChooser(uRLChooser, context);
        if (uRL != null) {
            uRLChooser.setSelectedURL(uRL);
        }
        return uRLChooser;
    }

    public static void initURLChooser(URLChooser uRLChooser, Context context) {
        URL uRL = DialogUtil.getDefaultURLFromContext(context);
        uRLChooser.setSelectedURL(uRL);
        DialogUtil.addShortcutButtons(uRLChooser, context);
        DialogUtil.addURLFilters(uRLChooser);
        uRLChooser.setDialogRunnerCallback(_standardKeeper);
    }

    public static void addShortcutButtons(URLChooser uRLChooser, Context context) {
        URL uRL;
        URL uRL2;
        uRLChooser.removeShortcutButtons();
        Project project = context != null ? context.getProject() : null;
        URL uRL3 = uRL2 = project != null ? ((Node)project).getURL() : null;
        if (uRL2 != null) {
            uRLChooser.addShortcutButton(IdeIcons.getIcon(9), DialogsArb.getString(17), uRL2);
        }
        Workspace workspace = context != null ? context.getWorkspace() : null;
        URL uRL4 = uRL = workspace != null ? ((Node)workspace).getURL() : null;
        if (uRL != null) {
            URL uRL5;
            URL uRL6 = uRL != null ? URLFileSystem.getParent(uRL) : null;
            URL uRL7 = uRL5 = uRL2 != null ? URLFileSystem.getParent(uRL2) : null;
            if (uRL5 == null || !URLFileSystem.equals(uRL6, uRL5)) {
                uRLChooser.addShortcutButton(IdeIcons.getIcon(10), DialogsArb.getString(18), uRL);
            }
        }
        String string = Ide.getHomeDirectory();
        URL uRL8 = DialogUtil.getIdeHomeDirectoryURL();
        uRLChooser.addShortcutButton(IdeIcons.getIcon(8), DialogsArb.getString(19), uRL8);
        String string2 = Ide.getTrueUserHomeDirectory();
        if (string2 != null && !string2.equals(string)) {
            URL uRL9 = URLFactory.newDirURL(string2);
            uRLChooser.addShortcutButton(IdeIcons.getIcon(13), DialogsArb.getString(20), uRL9);
        }
    }

    public static URLChooserInit getURLChooserInit(Context context) {
        return new 1(context);
    }

    public static void addURLFilter(URLFilter uRLFilter) {
        if (uRLFilter != null && !_urlFilters.contains(uRLFilter)) {
            _urlFilters.add(uRLFilter);
        }
    }

    public static void setWorkspaceFilter(URLFilter uRLFilter) {
        _workspaceFilter = uRLFilter;
    }

    public static void setProjectFilter(URLFilter uRLFilter) {
        _projectFilter = uRLFilter;
    }

    public static void setDefaultFilter(URLFilter uRLFilter) {
        _defaultFilter = uRLFilter;
    }

    public static Dialog getAncestorDialog(Component component) {
        return SwingUtils.getAncestorDialog((Component)component);
    }

    public static Frame getAncestorFrame(Component component) {
        return SwingUtils.getAncestorFrame((Component)component);
    }

    public static JEWTDialog createJEWTDialogOwnedBy(Component component) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)component);
        if (dialog != null) {
            return new JEWTDialog(dialog);
        }
        Frame frame = SwingUtils.getAncestorFrame((Component)component);
        if (frame != null) {
            return new JEWTDialog(frame);
        }
        return null;
    }

    private static URL getDefaultURLFromContext(Context context) {
        Node node;
        URL uRL;
        if (context == null) {
            return DialogUtil.getIdeUserHomeDirectoryURL();
        }
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length == 1) {
            URL uRL2;
            RelativeDirectoryContextFolder relativeDirectoryContextFolder;
            URLPath uRLPath;
            Element element = elementArray[0];
            if (element instanceof Locatable) {
                uRL = DialogUtil.getDirectoryURLFromLocatable((Locatable)((Object)element));
                if (uRL != null) {
                    return uRL;
                }
            } else if (element instanceof RelativeDirectoryContextFolder && (uRLPath = (relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element).getRootDirectories()) != null && (uRL2 = uRLPath.getFirstEntry()) != null) {
                String string = relativeDirectoryContextFolder.getRelativePath();
                return URLFactory.newDirURL(uRL2, string);
            }
            if (element instanceof Workspaces) {
                uRL = ((Workspaces)element).getWorkDirectory();
                if (uRL != null) {
                    while (uRL != null && !URLFileSystem.exists(uRL)) {
                        uRL = URLFileSystem.getParent(uRL);
                    }
                }
                return uRL;
            }
        }
        if ((node = context.getNode()) != null && !(node instanceof IdeSystem) && (uRL = DialogUtil.getDirectoryURLFromLocatable(node)) != null) {
            return uRL;
        }
        Project project = context.getProject();
        if (project != null) {
            uRL = ((Node)project).getURL();
            return URLFileSystem.getParent(uRL);
        }
        Workspace workspace = context.getWorkspace();
        if (workspace != null) {
            uRL = ((Node)workspace).getURL();
            return URLFileSystem.getParent(uRL);
        }
        return DialogUtil.getIdeUserHomeDirectoryURL();
    }

    private static URL getDirectoryURLFromLocatable(Locatable locatable) {
        if (locatable == null) {
            return null;
        }
        URL uRL = locatable.getURL();
        if (uRL == null) {
            return null;
        }
        if (!URLFileSystem.isDirectoryPath(uRL) && (uRL = URLFileSystem.getParent(uRL)) == null) {
            return null;
        }
        return URLFileSystem.exists(uRL) ? uRL : null;
    }

    private static void addURLFilters(URLChooser uRLChooser) {
        for (URLFilter uRLFilter : _urlFilters) {
            uRLChooser.addChooseableURLFilter(uRLFilter);
        }
    }

    private static URL getIdeHomeDirectoryURL() {
        return URLFactory.newDirURL(Ide.getHomeDirectory());
    }

    private static URL getIdeUserHomeDirectoryURL() {
        URL uRL = URLFactory.newDirURL(Ide.getUserHomeDirectory());
        return URLFileSystem.exists(uRL) ? uRL : DialogUtil.getIdeHomeDirectoryURL();
    }

    public static final class 1
    implements URLChooserInit {
        private final /* synthetic */ Context v$context;

        public void initURLChooser(URLChooser uRLChooser) {
            DialogUtil.initURLChooser(uRLChooser, this.v$context);
        }

        public 1(Context context) {
            this.v$context = context;
        }
    }
}

