/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.util.ModelUtil;

public class ProgressBar
implements Runnable,
ActionListener {
    private Component _parent;
    private JLabel _progressLabel;
    private String _progressText;
    private JLabel _stepLabel;
    private String _stepText;
    private JProgressBar _progressBar;
    private boolean _useBusyBar;
    private JEWTDialog _statusDialog;
    private String _dialogTitle;
    private int _completionStatus;
    private Timer _labelTimer;
    private Timer _completionTimer;
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current;
    private long _lastPause;
    private boolean _done;
    private boolean _canCancel;
    private JPanel _statusPanel;

    void $init$() {
        this._progressLabel = new JLabel();
        this._stepLabel = new JLabel();
        this._current = 0L;
        this._lastPause = 0L;
        this._done = false;
        this._canCancel = true;
        this._statusPanel = new JPanel(new GridBagLayout());
    }

    public ProgressBar(Component component, String string, Runnable runnable, boolean bl) {
        this.$init$();
        this._parent = component;
        this._dialogTitle = string;
        this._runnable = runnable;
        this._useBusyBar = bl;
    }

    public void setRunnable(Runnable runnable) {
        this._runnable = runnable;
    }

    public void setCancelable(boolean bl) {
        this._canCancel = bl;
    }

    public boolean isCancelable() {
        return this._canCancel;
    }

    public void start(String string, String string2) {
        this.start(string, string2, 0, 100);
    }

    public void start(String string, String string2, int n, int n2) {
        this._progressText = string;
        this._stepText = string2;
        this._progressLabel.setText(this._progressText);
        this._progressLabel.setLabelFor(this._progressBar);
        this._stepLabel.setText(this._stepText);
        this._progressBar = new JProgressBar(n, n2);
        if (!this._useBusyBar) {
            this._progressBar.setValue(0);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._statusPanel.add((Component)this._progressLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this._statusPanel.add((Component)this._progressBar, gridBagConstraints);
        if (this._useBusyBar) {
            this._progressBar.setIndeterminate(true);
        } else {
            this._progressBar.setIndeterminate(false);
        }
        gridBagConstraints.gridy = 2;
        this._statusPanel.add((Component)this._stepLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this._statusPanel.add(Box.createHorizontalStrut(300), gridBagConstraints);
        this._labelTimer = new Timer(1, this);
        this._labelTimer.setRepeats(true);
        this._completionTimer = new Timer(1, this);
        this._completionTimer.setRepeats(false);
        this._userCancelled = false;
        try {
            this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._canCancel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._statusDialog == null) {
            return;
        }
        this._statusDialog.setContent((Component)this._statusPanel);
        Thread thread = new Thread((Runnable)this, "ProgressBarThread");
        thread.setPriority(5);
        this._statusDialog.addWindowListener((WindowListener)new 1(this, thread));
        boolean bl = this._statusDialog.runDialog();
        this._userCancelled = !bl;
        this.setDoneStatus();
        this._statusDialog.dispose();
        this._statusDialog = null;
    }

    public void updateProgress(int n, String string, String string2) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = n;
        if (ModelUtil.hasLength((String)string)) {
            this._progressText = string;
        }
        if (ModelUtil.hasLength((String)string2)) {
            this._stepText = string2;
        }
        this._labelTimer.start();
    }

    public int getCompletionStatus() {
        return this._completionStatus;
    }

    public void updateProgress(String string, String string2) {
        if (!this._userCancelled) {
            if (ModelUtil.hasLength((String)string)) {
                this._progressText = string;
            }
            if (ModelUtil.hasLength((String)string2)) {
                this._stepText = string2;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long l = this._current - this._lastPause;
            if (l > 1000L) {
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._labelTimer) {
            if (ModelUtil.hasLength((String)this._progressText)) {
                this._progressLabel.setText(this._progressText);
            }
            if (ModelUtil.hasLength((String)this._stepText)) {
                this._stepLabel.setText(this._stepText);
            }
            if (this._progressBar != null) {
                this._progressBar.setValue(this._completionStatus);
            }
        } else if (object == this._completionTimer) {
            if (this._statusDialog != null && this._statusDialog.isVisible()) {
                this._statusDialog.hide();
            }
            if (this._labelTimer != null) {
                this._labelTimer.stop();
                this._labelTimer.removeActionListener(this);
                this._labelTimer = null;
            }
            this._completionTimer.stop();
            this._completionTimer.removeActionListener(this);
            this._completionTimer = null;
        }
    }

    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
    }

    private void end() {
        if (this._completionTimer != null) {
            this._completionTimer.start();
        }
    }

    public final class 1
    extends WindowAdapter {
        private final /* synthetic */ Thread v$thread;
        final /* synthetic */ ProgressBar this$0;

        public void windowOpened(WindowEvent windowEvent) {
            this.v$thread.start();
            windowEvent.getWindow().removeWindowListener(this);
        }

        public 1(ProgressBar progressBar, Thread thread) {
            this.v$thread = thread;
            this.this$0 = progressBar;
        }
    }

    private static class ProgressDialog
    extends JEWTDialog {
        static ProgressDialog createDialog(Component component, String string, boolean bl) {
            ProgressDialog progressDialog = null;
            Dialog dialog = DialogUtil.getAncestorDialog(component);
            if (dialog != null) {
                progressDialog = new ProgressDialog(dialog, string, bl);
            } else {
                Frame frame = DialogUtil.getAncestorFrame(component);
                if (frame != null) {
                    progressDialog = new ProgressDialog(frame, string, bl);
                }
            }
            return progressDialog;
        }

        private static int _getButtonMask(boolean bl) {
            return bl ? 2 : 0;
        }

        private ProgressDialog(Dialog dialog, String string, boolean bl) {
            super(dialog, string, ProgressDialog._getButtonMask(bl));
            this._init(bl);
        }

        private ProgressDialog(Frame frame, String string, boolean bl) {
            super(frame, string, ProgressDialog._getButtonMask(bl));
            this._init(bl);
        }

        private void _init(boolean bl) {
            this.setDefaultButton(ProgressDialog._getButtonMask(bl));
            if (!bl) {
                this.setDefaultCloseOperation(0);
            }
        }

        protected void dismissDialog(boolean bl) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(bl);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void removeNotify() {
            super.removeNotify();
        }
    }
}

