/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Component;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.ProgressException;

public abstract class ProgressRunnable
implements Runnable {
    private static final int DEFAULT_TIMEOUT = 300000;
    private Exception _ex;
    private ProgressBar _progBar;
    private boolean _canceled;
    private Thread _runnerThread;
    private boolean _canCancel;
    private boolean _useThread;
    private String _title;
    private String _msg;
    private int _timeout;
    private Object _result;

    void $init$() {
        this._canCancel = true;
        this._useThread = true;
        this._timeout = 300000;
    }

    public ProgressRunnable() {
        this.$init$();
    }

    public final void setTitle(String string) {
        this._title = string;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setMessage(String string) {
        this._msg = string;
    }

    public final String getMessage() {
        return this._msg;
    }

    public final void setCancelable(boolean bl) {
        this._canCancel = bl;
    }

    public final boolean isCancelable() {
        return this._canCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean bl) throws ProgressException {
        this._useThread = bl;
        if (bl) {
            this._progBar = new ProgressBar((Component)((Object)Ide.getMainWindow()), this._title, this, true);
            this._progBar.setCancelable(this._canCancel);
            this._progBar.start(this._msg, null);
            ProgressRunnable progressRunnable = this;
            synchronized (progressRunnable) {
                if (this._progBar.hasUserCancelled()) {
                    this._canceled = true;
                    this.doCancel();
                }
                this._progBar = null;
            }
        } else {
            this.run();
        }
        if (this._ex != null && !this._canceled) {
            throw new ProgressException(this._ex);
        }
        this.finish(this._result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object object = null;
        try {
            try {
                ProgressRunnable progressRunnable = this;
                synchronized (progressRunnable) {
                    if (this._progBar != null) {
                        this._progBar.sleepForUIToRepaint();
                        this._runnerThread = Thread.currentThread();
                    }
                }
                object = this.doWork();
            }
            catch (Exception exception) {
                this._ex = exception;
            }
        }
        catch (Throwable throwable) {
            ProgressRunnable progressRunnable = this;
            synchronized (progressRunnable) {
                if (this._useThread) {
                    if (this._progBar != null) {
                        this._runnerThread = null;
                        this._progBar.setDoneStatus();
                        this._result = object;
                    }
                } else {
                    this._result = object;
                }
            }
            throw throwable;
        }
        ProgressRunnable progressRunnable = this;
        synchronized (progressRunnable) {
            if (this._useThread) {
                if (this._progBar != null) {
                    this._runnerThread = null;
                    this._progBar.setDoneStatus();
                    this._result = object;
                }
            } else {
                this._result = object;
            }
        }
    }

    protected abstract Object doWork() throws Exception;

    protected void finish(Object object) {
    }

    protected void doCancel() {
        if (this._runnerThread != null) {
            this._runnerThread.interrupt();
            this._runnerThread = null;
        }
    }

    protected final Thread getRunnerThread() {
        return this._runnerThread;
    }
}

