/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class DirectoryExcludeFilter
implements Copyable,
FileFilter {
    private boolean _recurseDirectories;
    private int _applyToDirectory;
    private String _userDefinedExclusions;
    private String _oldUserDefinedExclusions;
    private ArrayList _userDefinedExceptionList;

    void $init$() {
        this._recurseDirectories = true;
        this._applyToDirectory = 0;
        this._userDefinedExceptionList = new ArrayList();
    }

    public DirectoryExcludeFilter() {
        this.$init$();
    }

    public List getList() {
        return this.parseUserDefinedFilterString();
    }

    public boolean getRecurseDirectories() {
        return this._recurseDirectories;
    }

    public void setRecurseDirectories(boolean bl) {
        this._recurseDirectories = bl;
    }

    public int getApplyToDirectory() {
        return this._applyToDirectory;
    }

    public void setApplyToDirectory(int n) {
        this._applyToDirectory = n;
    }

    public String getUserDefinedExclusions() {
        return this._userDefinedExclusions;
    }

    public void setUserDefinedExclusions(String string) {
        this._userDefinedExclusions = string;
    }

    public static boolean equals(DirectoryExcludeFilter directoryExcludeFilter, DirectoryExcludeFilter directoryExcludeFilter2) {
        String string;
        if (directoryExcludeFilter.getRecurseDirectories() != directoryExcludeFilter2.getRecurseDirectories()) {
            return false;
        }
        if (directoryExcludeFilter.getApplyToDirectory() != directoryExcludeFilter2.getApplyToDirectory()) {
            return false;
        }
        String string2 = directoryExcludeFilter.getUserDefinedExclusions();
        return ModelUtil.areEqual((Object)string2, (Object)(string = directoryExcludeFilter2.getUserDefinedExclusions()));
    }

    protected List parseUserDefinedFilterString() {
        if (ModelUtil.areEqual((Object)this._userDefinedExclusions, (Object)this._oldUserDefinedExclusions)) {
            return this._userDefinedExceptionList;
        }
        if (!ModelUtil.hasLength((String)this._userDefinedExclusions)) {
            this._userDefinedExceptionList.clear();
        } else {
            this._userDefinedExceptionList.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(this._userDefinedExclusions, ";");
            int n = this instanceof FileTypeIncludeFilter ? 0 : 1;
            while (stringTokenizer.hasMoreTokens()) {
                URLFilter uRLFilter = null;
                String string = stringTokenizer.nextToken();
                uRLFilter = DirectoryExcludeFilter.createURLFilter(string, n);
                if (uRLFilter == null) continue;
                this._userDefinedExceptionList.add(uRLFilter);
            }
        }
        this._oldUserDefinedExclusions = this._userDefinedExclusions;
        return this._userDefinedExceptionList;
    }

    protected static URLFilter createURLFilter(String string, int n) {
        URLFilter uRLFilter = null;
        uRLFilter = WildcardURLFilter.hasWildcard(string) ? new WildcardURLFilter(string, URLFileSystem.isLocalFileSystemCaseSensitive()) : (n == 0 || string.endsWith(" /") ? new DefaultURLFilter(string, string) : new DefaultURLFilter(string, string + "/"));
        return uRLFilter;
    }

    public Object copyTo(Object object) {
        DirectoryExcludeFilter directoryExcludeFilter = object != null ? (DirectoryExcludeFilter)object : new DirectoryExcludeFilter();
        this.copyToImpl(directoryExcludeFilter);
        return directoryExcludeFilter;
    }

    protected final void copyToImpl(DirectoryExcludeFilter directoryExcludeFilter) {
        directoryExcludeFilter._recurseDirectories = this._recurseDirectories;
        directoryExcludeFilter._applyToDirectory = this._applyToDirectory;
        directoryExcludeFilter._userDefinedExclusions = this._userDefinedExclusions;
    }
}

