/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;

public class DirectoryExcludeFilterPanel
extends JPanel {
    private JLabel _otherLbl;
    private JTextField _otherFld;
    private JRadioButton _selectedDirRB;
    private JRadioButton _allDirRB;
    private ButtonGroup _buttonGroup;
    private JCheckBox _recurseCB;
    private static final String HELP_TOPIC = "f1_ideddirectoriestoexclude_html";

    void $init$() {
        this._otherLbl = new JLabel();
        this._otherFld = new JTextField();
        this._selectedDirRB = new JRadioButton();
        this._allDirRB = new JRadioButton();
        this._buttonGroup = new ButtonGroup();
        this._recurseCB = new JCheckBox();
    }

    public DirectoryExcludeFilterPanel() {
        this.$init$();
        this.initPanel();
    }

    protected void initPanel() {
        ResourceUtils.resButton(this._allDirRB, DialogsArb.getString(22));
        ResourceUtils.resLabel(this._otherLbl, this._otherFld, DialogsArb.getString(23));
        ResourceUtils.resButton(this._recurseCB, DialogsArb.getString(24));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._otherLbl, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._otherFld, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this._buttonGroup.add(this._selectedDirRB);
        this._buttonGroup.add(this._allDirRB);
        this._allDirRB.setSelected(true);
        this.add((Component)this._allDirRB, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this._recurseCB.setSelected(true);
        this.add((Component)this._selectedDirRB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this._recurseCB, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
    }

    public boolean showDialog(Component component, DirectoryExcludeFilter directoryExcludeFilter, String string) {
        if (directoryExcludeFilter == null) {
            directoryExcludeFilter = new DirectoryExcludeFilter();
        }
        ResourceUtils.resButton(this._selectedDirRB, DialogsArb.format(21, string));
        this.loadFrom(directoryExcludeFilter);
        HelpSystem.getHelpSystem().registerTopic(this, HELP_TOPIC);
        JEWTDialog jEWTDialog = DialogUtil.createJEWTDialogOwnedBy(component);
        if (jEWTDialog == null) {
            return false;
        }
        jEWTDialog.setCenterOver(component);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setInitialFocus((Component)this._otherFld);
        jEWTDialog.setTitle(DialogsArb.getString(25));
        jEWTDialog.setButtonMask(7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setPreferredSize(350, 250);
        if (jEWTDialog.runDialog()) {
            this.commitTo(directoryExcludeFilter);
            return true;
        }
        return false;
    }

    protected void loadFrom(FileFilter fileFilter) {
        this._recurseCB.setSelected(fileFilter.getRecurseDirectories());
        if (fileFilter.getApplyToDirectory() == 1) {
            this._selectedDirRB.setSelected(true);
            this._allDirRB.setSelected(false);
        } else {
            this._selectedDirRB.setSelected(false);
            this._allDirRB.setSelected(true);
        }
        String string = fileFilter.getUserDefinedExclusions();
        if (ModelUtil.hasLength((String)string)) {
            this._otherFld.setText(string);
        }
    }

    protected void commitTo(FileFilter fileFilter) {
        fileFilter.setRecurseDirectories(this._recurseCB.isSelected());
        if (this._selectedDirRB.isSelected()) {
            fileFilter.setApplyToDirectory(1);
        } else {
            fileFilter.setApplyToDirectory(0);
        }
        fileFilter.setUserDefinedExclusions(this._otherFld.getText());
    }
}

