/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.ButtonsLayoutManager;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.DirectoryExcludeFilterPanel;
import oracle.ide.dialogs.filter.ExcludeFilterSettings;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.dialogs.filter.FileTypeIncludeFilterPanel;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Reference;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class DirectoryOptionsPanel
extends DefaultTraversablePanel
implements TreeSelectionListener,
TreeExpansionListener,
Runnable {
    private ArrayList _inputDirectories;
    private ArrayList _expandedFiles;
    private ArrayList _jdevFiles;
    private ProgressBar _progressBar;
    private Context _context;
    private JMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;
    private CustomJTree _tree;
    private JScrollPane _scrollPane;
    private JButton _addBtn;
    private JButton _removeBtn;
    private JButton _fileTypeBtn;
    private JButton _dirFilterBtn;
    private JCheckBox _copyCheckBox;
    private URLTextField _copyLocationFld;
    private JButton _browseBtn;
    private int _runOption;
    private List _selectedFiles;
    private List _copiedFiles;
    private URL _lastURLDirectory;
    private boolean _addToProject;
    private boolean _enableFileTypeBtn;
    private boolean _jwsOnly;
    private boolean _jwsExcluded;
    private boolean _jprOnly;
    private boolean _jprExcluded;
    private static final String ICON_KEY_DIRECTORY = "FileView.directoryIcon";
    private static final String ICON_KEY_FILE = "FileView.fileIcon";
    private static final String HELP_TOPIC = "f1_idedrefinefileselection_html";
    private static final int EXPAND_ALL_DIRECTORIES = 0;
    private static final int COPY_FILES = 1;
    private static final int INCLUDE_LIST = 0;
    private static final int EXCLUDE_LIST = 1;
    private static final String WORKSPACE_FILE_EXT = ".jws";
    private static final String PROJECT_FILE_EXT = ".jpr";

    void $init$() {
        this._inputDirectories = new ArrayList();
        this._expandedFiles = new ArrayList();
        this._jdevFiles = new ArrayList();
        this._addBtn = new JButton();
        this._removeBtn = new JButton();
        this._fileTypeBtn = new JButton();
        this._dirFilterBtn = new JButton();
        this._copyCheckBox = new JCheckBox();
        this._copyLocationFld = new URLTextField();
        this._browseBtn = new JButton();
        this._enableFileTypeBtn = true;
    }

    public DirectoryOptionsPanel(URL[] uRLArray, boolean bl, boolean bl2, boolean bl3, Context context) {
        this.$init$();
        this._addToProject = bl3;
        this._context = context;
        this.initData(uRLArray, bl3);
        this.initUI(bl, bl2, bl3);
    }

    public DirectoryOptionsPanel(URL[] uRLArray, boolean bl, boolean bl2) {
        this(uRLArray, bl, false, bl2, null);
    }

    public DirectoryOptionsPanel(URL[] uRLArray, boolean bl, boolean bl2, boolean bl3) {
        this(uRLArray, bl, bl2, bl3, null);
    }

    public void setProject(Project project) {
        if (this._context == null) {
            this._context = Context.newIdeContext();
        }
        this._context.setProject(project);
    }

    public void setContext(Context context) {
        this._context = context;
        this.setJDevFilesSettings();
    }

    public boolean showDialog(Component component) {
        JEWTDialog jEWTDialog = DialogUtil.createJEWTDialogOwnedBy(component);
        if (jEWTDialog == null) {
            return false;
        }
        jEWTDialog.setCenterOver(component);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setInitialFocus((Component)this.getTree());
        if (this._jwsOnly) {
            jEWTDialog.setTitle(DirOptionsArb.getString(29));
        } else if (this._jprOnly) {
            jEWTDialog.setTitle(DirOptionsArb.getString(30));
        } else {
            jEWTDialog.setTitle(DirOptionsArb.getString(0));
        }
        jEWTDialog.setButtonMask(7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setPreferredSize(new Dimension(500, 500));
        boolean bl = jEWTDialog.runDialog();
        jEWTDialog.dispose();
        return bl;
    }

    public URL getProjectDirectory() {
        return this._copyLocationFld.getURL();
    }

    public void setProjectDirectory(URL uRL) {
        URL uRL2 = null;
        if (uRL != null) {
            uRL2 = uRL;
        } else {
            if (Ide.getActiveProject() == null) {
                return;
            }
            uRL = Ide.getActiveProject().getURL();
        }
        String string = URLFileSystem.getPath(uRL);
        string = string.substring(0, string.lastIndexOf("/") + 1);
        this._copyLocationFld.setURL(URLFactory.newDirURL(string + "src/"));
    }

    public boolean getCopyFiles() {
        return this._copyCheckBox.isSelected();
    }

    public URL getCopyLocationURL() {
        return this._copyLocationFld.getURL();
    }

    public static boolean containsDirectory(URL[] uRLArray) {
        int n = 0;
        while (n < uRLArray.length) {
            if (URLFileSystem.isDirectory(uRLArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void populateTree(URL[] uRLArray) {
        int n = 0;
        while (n < uRLArray.length) {
            this.addChild(uRLArray[n]);
            ++n;
        }
        if (uRLArray.length < 2) {
            this.getTree().expandRow(0);
        }
    }

    public JMutableTreeNode getRootNode() {
        return this._rootNode;
    }

    public CustomJTree getTree() {
        return this._tree;
    }

    public ArrayList getInputDirectories() {
        return this._inputDirectories;
    }

    public int expandDirectories(Component component) {
        this._runOption = 0;
        this._progressBar = new ProgressBar(component, DirOptionsArb.getString(1), this, true);
        this._progressBar.start(DirOptionsArb.getString(2), null);
        this._progressBar.waitUntilDone();
        if (this._progressBar.hasUserCancelled()) {
            this._expandedFiles.clear();
            return 0;
        }
        return this._expandedFiles.size();
    }

    private void initData(URL[] uRLArray, boolean bl) {
        JTreeCellData jTreeCellData = new JTreeCellData(null, null, true, TriStateBoolean.TRUE);
        this._rootNode = new JMutableTreeNode(jTreeCellData);
        NodeData nodeData = new NodeData(null);
        this._rootNode.setUserObject(nodeData);
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree = new CustomJTree(this._treeModel);
        this._tree.setRootVisible(false);
        this._tree.setScrollsOnExpand(true);
        this._tree.addTreeExpansionListener(this);
        this._tree.addTreeSelectionListener(this);
        if (uRLArray != null) {
            this.populateTree(uRLArray);
            this._tree.setSelectionRow(0);
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
        }
        if (bl) {
            this.setProjectDirectory(null);
        }
        this.setJDevFilesSettings();
    }

    private void setJDevFilesSettings() {
        if (this._addToProject && this._context != null) {
            if (this._context.getWorkspace() == null) {
                this._enableFileTypeBtn = false;
                this._jwsOnly = true;
            } else if (this._context.getProject() == null) {
                this._enableFileTypeBtn = false;
                this._jprOnly = true;
            } else {
                this._jwsExcluded = true;
                this._jprExcluded = true;
            }
        }
    }

    private void initUI(boolean bl, boolean bl2, boolean bl3) {
        this.setLayout(new GridBagLayout());
        this.setHelpID(HELP_TOPIC);
        HelpUtils.setHelpID((JComponent)this, (String)HELP_TOPIC);
        this._scrollPane = new JScrollPane(this._tree);
        ResourceUtils.resButton(this._copyCheckBox, DirOptionsArb.getString(13));
        this._copyCheckBox.setSelected(false);
        ResourceUtils.resButton(this._browseBtn, DirOptionsArb.getString(16));
        this._browseBtn.addActionListener(this._copyLocationFld);
        ButtonsLayoutManager buttonsLayoutManager = new ButtonsLayoutManager();
        buttonsLayoutManager.setGap(5);
        JPanel jPanel = new JPanel(buttonsLayoutManager);
        JLabel jLabel = new JLabel();
        String string = null;
        string = bl ? DirOptionsArb.getString(14) : DirOptionsArb.getString(15);
        ResourceUtils.resLabel(jLabel, this._tree, string);
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 1, 4, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
        if (bl3 && !this._jwsOnly && !this._jprOnly) {
            this.add((Component)this._copyCheckBox, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)((Object)this._copyLocationFld), new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 15, 0, 0), 0, 0));
            this.add((Component)this._browseBtn, new GridBagConstraints(3, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
            ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this._copyCheckBox, new Component[]{this._copyLocationFld, this._browseBtn});
        }
        ResourceUtils.resButton(this._dirFilterBtn, DirOptionsArb.getString(8));
        this._dirFilterBtn.addActionListener(new 6());
        int n = 1;
        jPanel.add((Component)this._dirFilterBtn, new Integer(n++));
        ResourceUtils.resButton(this._fileTypeBtn, DirOptionsArb.getString(9));
        this._fileTypeBtn.addActionListener(new 5());
        if (this._enableFileTypeBtn) {
            jPanel.add((Component)this._fileTypeBtn, new Integer(n++));
        }
        if (this._tree.getSelectionCount() == 0) {
            this._fileTypeBtn.setEnabled(false);
            this._dirFilterBtn.setEnabled(false);
        }
        if (bl2) {
            ResourceUtils.resButton(this._removeBtn, DirOptionsArb.getString(11));
            this._removeBtn.addActionListener(new 4());
            jPanel.add((Component)this._removeBtn, new Integer(n++));
            this._removeBtn.setEnabled(false);
        }
        if (bl) {
            ResourceUtils.resButton(this._addBtn, DirOptionsArb.getString(10));
            this._addBtn.addActionListener(new 3());
            jPanel.add((Component)this._addBtn, new Integer(n++));
        }
    }

    public void run() {
        if (this._runOption == 0) {
            this.expandAllDirectories();
        } else if (this._runOption == 1) {
            this.copyFiles();
        }
    }

    private void expandAllDirectories() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this._progressBar.hasUserCancelled()) {
            return;
        }
        int n = 0;
        while (n < this._inputDirectories.size()) {
            List list;
            NodeData nodeData = (NodeData)this._inputDirectories.get(n);
            DirectoryExcludeFilter directoryExcludeFilter = nodeData.getDirectoryFilter();
            FileTypeIncludeFilter fileTypeIncludeFilter = nodeData.getFileTypeFilter();
            List list2 = fileTypeIncludeFilter == null ? null : fileTypeIncludeFilter.getList();
            List list3 = list = directoryExcludeFilter == null ? null : directoryExcludeFilter.getList();
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(DirOptionsArb.getString(3), URLFileSystem.getPlatformPathName(nodeData.getURL()));
            URL[] uRLArray = URLFileSystem.list(nodeData.getURL());
            int n2 = 0;
            while (n2 < uRLArray.length) {
                if (this._progressBar.hasUserCancelled()) {
                    return;
                }
                if (URLFileSystem.isDirectory(uRLArray[n2])) {
                    if (this.canFileBeAddedToList(uRLArray[n2], list, 1)) {
                        arrayList.add(uRLArray[n2]);
                    }
                    this._progressBar.updateProgress(DirOptionsArb.getString(4), URLFileSystem.getPlatformPathName(uRLArray[n2]));
                } else if (!this.isURLAlreadyInProject(uRLArray[n2])) {
                    if (this.canFileBeAddedToList(uRLArray[n2], list2, 0)) {
                        this.handleFile(uRLArray[n2], this._expandedFiles);
                    }
                    this._progressBar.updateProgress(DirOptionsArb.getString(5), URLFileSystem.getPlatformPathName(uRLArray[n2]));
                }
                ++n2;
            }
            uRLArray = null;
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (this._progressBar.hasUserCancelled()) {
                    return;
                }
                uRLArray = URLFileSystem.list((URL)arrayList.get(n3));
                arrayList.remove(n3);
                int n4 = 0;
                while (n4 < uRLArray.length) {
                    this._progressBar.sleepForUIToRepaint();
                    if (URLFileSystem.isDirectory(uRLArray[n4])) {
                        if (this.canFileBeAddedToList(uRLArray[n4], list, 1)) {
                            arrayList.add(n3, uRLArray[n4]);
                            this._progressBar.updateProgress(DirOptionsArb.getString(4), URLFileSystem.getPlatformPathName(uRLArray[n4]));
                        }
                    } else if (this.canFileBeAddedToList(uRLArray[n4], list2, 0) && !this.isURLAlreadyInProject(uRLArray[n4])) {
                        this.handleFile(uRLArray[n4], this._expandedFiles);
                        this._progressBar.updateProgress(DirOptionsArb.getString(5), URLFileSystem.getPlatformPathName(uRLArray[n4]));
                    }
                    ++n4;
                }
                --n3;
                ++n3;
            }
            ++n;
        }
        this._progressBar.setDoneStatus();
    }

    private void handleFile(URL uRL, List list) {
        String string = URLFileSystem.getSuffix(uRL);
        if (this._jwsOnly) {
            if (string.equals(WORKSPACE_FILE_EXT)) {
                list.add(uRL);
                return;
            }
            return;
        }
        if (this._jwsExcluded && string.equals(WORKSPACE_FILE_EXT)) {
            return;
        }
        if (this._jprOnly) {
            if (string.equals(PROJECT_FILE_EXT)) {
                list.add(uRL);
                return;
            }
            return;
        }
        if (this._jprExcluded && string.equals(PROJECT_FILE_EXT)) {
            return;
        }
        if (string.equals(WORKSPACE_FILE_EXT) || string.equals(PROJECT_FILE_EXT)) {
            this._jdevFiles.add(uRL);
        } else {
            list.add(uRL);
        }
    }

    public URL getNewFileNameFor(URL uRL) {
        List list = this.getTopLevelUserSelections();
        URL uRL2 = this._copyLocationFld.getURL();
        URL uRL3 = this.findParentURLInList(uRL, list);
        URL uRL4 = null;
        if (uRL3 == null) {
            uRL4 = URLFactory.newURL(uRL2, URLFileSystem.getFileName(uRL));
        } else {
            String string = uRL.toExternalForm().substring(uRL3.toExternalForm().length());
            uRL4 = URLFactory.newURL(uRL2, string);
        }
        return uRL4;
    }

    private void copyFiles() {
        List list = this.getTopLevelUserSelections();
        URL uRL = this._copyLocationFld.getURL();
        if (this._selectedFiles == null || this._selectedFiles.size() == 0) {
            return;
        }
        Iterator iterator = this._selectedFiles.iterator();
        while (iterator.hasNext()) {
            URL uRL2 = (URL)iterator.next();
            URL uRL3 = this.findParentURLInList(uRL2, list);
            URL uRL4 = null;
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(DirOptionsArb.getString(6), URLFileSystem.getPlatformPathName(uRL2));
            if (uRL3 == null) {
                String string = null;
                if (!URLFileSystem.isDirectory(uRL2) && URLFileSystem.hasSuffix(uRL2, ".java")) {
                    String string2 = this.getPackage(uRL2);
                    if (string2 != null) {
                        string = string2 + URLFileSystem.getFileName(uRL2);
                    }
                } else {
                    string = URLFileSystem.getFileName(uRL2);
                }
                uRL4 = URLFactory.newURL(uRL, string);
            } else {
                String string;
                String string3 = uRL2.toExternalForm().substring(uRL3.toExternalForm().length());
                if (string3.equals(URLFileSystem.getFileName(uRL2)) && URLFileSystem.getSuffix(uRL2).equals(".java") && (string = this.getPackage(uRL2)) != null) {
                    string3 = string + string3;
                }
                uRL4 = URLFactory.newURL(uRL, string3);
            }
            try {
                if (!URLFileSystem.equals(uRL2, uRL4)) {
                    URLFileSystem.copy(uRL2, uRL4);
                    this._copiedFiles.add(uRL4);
                }
                iterator.remove();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._progressBar.setDoneStatus();
    }

    private boolean canFileBeAddedToList(URL uRL, List list, int n) {
        if (list == null) {
            return true;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            URLFilter uRLFilter = (URLFilter)list.get(n2);
            if (uRLFilter.accept(uRL)) {
                return n == 0;
            }
            ++n2;
        }
        return n != 0;
    }

    private boolean isURLAlreadyInProject(URL uRL) {
        if (this._context.getProject() != null) {
            try {
                if (this._context.getProject().containsChild(NodeFactory.findOrCreate(uRL))) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void addChild(URL uRL) {
        if (this.isParentURLInTree(uRL)) {
            JOptionPane.showMessageDialog(this, DirOptionsArb.format(23, URLFileSystem.getPlatformPathName(uRL)), DirOptionsArb.getString(24), 0);
            return;
        }
        DirectoryExcludeFilter directoryExcludeFilter = (DirectoryExcludeFilter)this.getOrCreateFilter(1);
        FileTypeIncludeFilter fileTypeIncludeFilter = (FileTypeIncludeFilter)this.getOrCreateFilter(0);
        JMutableTreeNode[] jMutableTreeNodeArray = this.getChildURLsInTree(uRL);
        if (jMutableTreeNodeArray != null) {
            if (JOptionPane.showConfirmDialog(this, DirOptionsArb.format(25, URLFileSystem.getPlatformPathName(uRL)), DirOptionsArb.getString(26), 0, 0) == 1) {
                return;
            }
            int n = 0;
            while (n < jMutableTreeNodeArray.length) {
                jMutableTreeNodeArray[n].removeFromParent();
                ++n;
            }
            JMutableTreeNode jMutableTreeNode = this.createAndAdd(this._rootNode, uRL);
            if (jMutableTreeNode != null) {
                this.applyFilter(jMutableTreeNode, directoryExcludeFilter, 1, true);
                this.applyFilter(jMutableTreeNode, fileTypeIncludeFilter, 0, true);
                this._treeModel.reload(this._rootNode);
            }
        } else {
            JMutableTreeNode jMutableTreeNode = this.createAndAdd(this._rootNode, uRL);
            if (jMutableTreeNode != null) {
                this.applyFilter(jMutableTreeNode, directoryExcludeFilter, 1, true);
                this.applyFilter(jMutableTreeNode, fileTypeIncludeFilter, 0, true);
                this._treeModel.reload(this._rootNode);
            }
        }
    }

    private boolean isParentURLInTree(URL uRL) {
        Enumeration<TreeNode> enumeration = this._rootNode.children();
        while (enumeration.hasMoreElements()) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
            NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
            URL uRL2 = nodeData.getURL();
            if (!URLFileSystem.isDirectoryPath(uRL2) || !URLFileSystem.isBaseURLFor(uRL2, uRL)) continue;
            return true;
        }
        return false;
    }

    private JMutableTreeNode[] getChildURLsInTree(URL uRL) {
        if (!URLFileSystem.isDirectoryPath(uRL)) {
            return null;
        }
        ArrayList<JMutableTreeNode> arrayList = new ArrayList<JMutableTreeNode>();
        Enumeration<TreeNode> enumeration = this._rootNode.children();
        while (enumeration.hasMoreElements()) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
            NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
            URL uRL2 = nodeData.getURL();
            if (!URLFileSystem.isBaseURLFor(uRL, uRL2)) continue;
            arrayList.add(jMutableTreeNode);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        int n = arrayList.size();
        JMutableTreeNode[] jMutableTreeNodeArray = arrayList.toArray(new JMutableTreeNode[n]);
        return jMutableTreeNodeArray;
    }

    private JMutableTreeNode createAndAdd(JMutableTreeNode jMutableTreeNode, URL uRL) {
        if (this.isURLAlreadyInProject(uRL)) {
            return null;
        }
        Icon icon = null;
        String string = URLFileSystem.getFileName(uRL);
        boolean bl = URLFileSystem.isDirectoryPath(uRL);
        icon = bl ? UIManager.getIcon(ICON_KEY_DIRECTORY) : UIManager.getIcon(ICON_KEY_FILE);
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        FileTypeIncludeFilter fileTypeIncludeFilter = nodeData.getFileTypeFilter();
        DirectoryExcludeFilter directoryExcludeFilter = nodeData.getDirectoryFilter();
        List list = null;
        int n = 0;
        if (bl && directoryExcludeFilter != null) {
            list = directoryExcludeFilter.getList();
            n = 1;
        } else if (!bl && fileTypeIncludeFilter != null) {
            list = fileTypeIncludeFilter.getList();
            n = 0;
        }
        JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
        TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
        if (triStateBoolean.isTrue() && !this.canFileBeAddedToList(uRL, list, n)) {
            triStateBoolean = TriStateBoolean.FALSE;
        }
        JTreeCellData jTreeCellData2 = new JTreeCellData(icon, string, true, triStateBoolean);
        2 var14_14 = new 2(jTreeCellData2, bl);
        NodeData nodeData2 = null;
        nodeData2 = bl ? new NodeData(uRL, fileTypeIncludeFilter, directoryExcludeFilter) : new NodeData(uRL, fileTypeIncludeFilter, directoryExcludeFilter);
        var14_14.setUserObject(nodeData2);
        int n2 = jMutableTreeNode.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getChildAt(n3);
            JTreeCellData jTreeCellData3 = jMutableTreeNode2.getModel();
            String string2 = jTreeCellData3.getText();
            if (string.compareTo(string2) < 0) {
                n2 = n3;
            }
            ++n3;
        }
        this._treeModel.insertNodeInto(var14_14, jMutableTreeNode, n2);
        return var14_14;
    }

    private void addChildrenFromFileSystem(JMutableTreeNode jMutableTreeNode) {
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        JMutableTreeNode jMutableTreeNode2 = null;
        URL[] uRLArray = URLFileSystem.list(nodeData.getURL());
        JMutableTreeNode jMutableTreeNode3 = null;
        int n = 0;
        while (n < uRLArray.length) {
            block7: {
                block6: {
                    if (URLFileSystem.isDirectory(uRLArray[n])) break block6;
                    String string = URLFileSystem.getSuffix(uRLArray[n]);
                    if (this._jwsOnly && !string.equals(WORKSPACE_FILE_EXT) || this._jwsExcluded && string.equals(WORKSPACE_FILE_EXT) || this._jprOnly && !string.equals(PROJECT_FILE_EXT) || this._jprExcluded && string.equals(PROJECT_FILE_EXT)) break block7;
                }
                if ((jMutableTreeNode2 = this.createAndAdd(jMutableTreeNode, uRLArray[n])) != null && jMutableTreeNode3 == null) {
                    jMutableTreeNode3 = jMutableTreeNode2;
                }
            }
            ++n;
        }
        if (jMutableTreeNode3 != null) {
            jMutableTreeNode3.ascendingUpdateNodes();
            this._treeModel.reload(jMutableTreeNode);
        }
    }

    public List getSelectedFileList(Component component, boolean bl) {
        int n;
        this._selectedFiles = new ArrayList();
        this.collectFileList(this._rootNode, this._selectedFiles);
        int n2 = this._selectedFiles.size();
        int n3 = 0;
        while (n3 < n2) {
            this.handleFile((URL)this._selectedFiles.get(n3), this._expandedFiles);
            ++n3;
        }
        this._selectedFiles.clear();
        this._selectedFiles.addAll(this._expandedFiles);
        this._expandedFiles.clear();
        if (this._inputDirectories.size() > 0) {
            this.expandDirectories(component);
        }
        if (this._jdevFiles.size() > 0 && (n = JOptionPane.showConfirmDialog(component, DirOptionsArb.getString(28), DirOptionsArb.getString(27), 0)) == 0) {
            this.resolveProjectsToWorkspaces(this._jdevFiles);
            this._selectedFiles.addAll(this._jdevFiles);
            this._jdevFiles.clear();
            this._expandedFiles.clear();
            this._inputDirectories.clear();
            return this._selectedFiles;
        }
        this._selectedFiles.addAll(this._expandedFiles);
        this._inputDirectories.clear();
        this._expandedFiles.clear();
        this._jdevFiles.clear();
        if (this._copyCheckBox.isSelected() && bl) {
            this.copyFilesToProject(component);
            return this._copiedFiles;
        }
        return this._selectedFiles;
    }

    private void resolveProjectsToWorkspaces(ArrayList arrayList) {
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        ArrayList<URL> arrayList3 = new ArrayList<URL>();
        int n = arrayList.size();
        String string = null;
        URL uRL = null;
        int n2 = 0;
        while (n2 < n) {
            uRL = (URL)arrayList.get(n2);
            string = URLFileSystem.getSuffix(uRL);
            if (string.equalsIgnoreCase(WORKSPACE_FILE_EXT)) {
                arrayList2.add(uRL);
            } else {
                arrayList3.add(uRL);
            }
            ++n2;
        }
        n = arrayList2.size();
        DataContainer dataContainer = null;
        URL uRL2 = null;
        int n3 = 0;
        while (n3 < n) {
            uRL2 = (URL)arrayList2.get(n3);
            try {
                Object2Dom object2Dom = Object2Dom.newInstance();
                dataContainer = (Workspace)object2Dom.toObject(uRL2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            List list = dataContainer.getListOfChildren();
            int n4 = list.size();
            Reference reference = null;
            int n5 = 0;
            while (n5 < n4) {
                reference = (Reference)list.get(n5);
                URL uRL3 = reference.getURL();
                int n6 = arrayList3.indexOf(uRL3);
                if (n6 != -1) {
                    arrayList3.remove(n6);
                }
                ++n5;
            }
            arrayList.clear();
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
            ++n3;
        }
    }

    private void collectFileList(JMutableTreeNode jMutableTreeNode, List list) {
        if (jMutableTreeNode.isLeaf()) {
            this.collectIfChecked(jMutableTreeNode, list);
        } else if (jMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = jMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
                this.collectFileList(jMutableTreeNode2, list);
            }
        } else {
            JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
            if (jTreeCellData.getHasCheckBox() && jTreeCellData.getCheckBoxState() == TriStateBoolean.TRUE) {
                NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
                this._inputDirectories.add(nodeData);
            }
        }
    }

    private void collectIfChecked(JMutableTreeNode jMutableTreeNode, List list) {
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
        if (jTreeCellData.getHasCheckBox() && jTreeCellData.getCheckBoxState() == TriStateBoolean.TRUE) {
            list.add(nodeData.getURL());
        }
    }

    private List getTopLevelUserSelections() {
        ArrayList<URL> arrayList = new ArrayList<URL>(this._rootNode.getChildCount());
        Enumeration<TreeNode> enumeration = this._rootNode.children();
        while (enumeration.hasMoreElements()) {
            JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
            NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
            URL uRL = nodeData.getURL();
            URL uRL2 = URLFileSystem.getParent(uRL);
            if (uRL2 == null || arrayList.contains(uRL2)) continue;
            arrayList.add(uRL2);
        }
        return arrayList;
    }

    private void applyFilter(JMutableTreeNode jMutableTreeNode, FileFilter fileFilter, int n, boolean bl) {
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        URL uRL = nodeData.getURL();
        if (uRL == null) {
            return;
        }
        JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
        boolean bl2 = true;
        boolean bl3 = URLFileSystem.isDirectory(uRL);
        if (bl3 && n == 1) {
            bl2 = this.canFileBeAddedToList(uRL, fileFilter.getList(), 1);
            nodeData.setDirectoryFilter(fileFilter);
            this.updateCheckBoxState(jMutableTreeNode, jTreeCellData, bl2, bl3);
        } else if (bl3 && n == 0) {
            nodeData.setFileTypeFilter(fileFilter);
        } else if (!bl3 && n == 0) {
            bl2 = this.canFileBeAddedToList(uRL, fileFilter.getList(), 0);
            this.updateCheckBoxState(jMutableTreeNode, jTreeCellData, bl2, bl3);
        } else if (!bl3 && n == 1) {
            return;
        }
        if (!jMutableTreeNode.isLeaf() && bl && jMutableTreeNode.getChildCount() > 0) {
            Enumeration<TreeNode> enumeration = jMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
                NodeData nodeData2 = (NodeData)jMutableTreeNode2.getUserObject();
                URL uRL2 = nodeData2.getURL();
                if (URLFileSystem.isDirectory(uRL2)) {
                    if (n == 1 && !bl2) {
                        return;
                    }
                    this.applyFilter(jMutableTreeNode2, fileFilter, n, fileFilter.getRecurseDirectories());
                    continue;
                }
                if (n != 0) continue;
                this.applyFilter(jMutableTreeNode2, fileFilter, n, false);
            }
        }
    }

    private void updateCheckBoxState(JMutableTreeNode jMutableTreeNode, JTreeCellData jTreeCellData, boolean bl, boolean bl2) {
        TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
        if (bl2 && bl && (triStateBoolean.isTriState() || triStateBoolean.isUndef())) {
            return;
        }
        if (bl2 && bl && triStateBoolean.isFalse() && jMutableTreeNode.getChildCount() > 0) {
            this.reapplyExistingFilters(jMutableTreeNode);
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getChildAt(0);
            jMutableTreeNode2.ascendingUpdateNodes();
        } else if (triStateBoolean.isTriState() || triStateBoolean.isUndef() || triStateBoolean.isTrue() && !bl || triStateBoolean.isFalse() && bl) {
            jTreeCellData.setCheckBoxState(bl);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this._tree.getModel();
            defaultTreeModel.nodeChanged(jMutableTreeNode);
            jMutableTreeNode.selectDescendants(bl);
            jMutableTreeNode.updateNodes();
        }
    }

    private void reapplyExistingFilters(JMutableTreeNode jMutableTreeNode) {
        block4: {
            NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
            URL uRL = nodeData.getURL();
            if (uRL == null) {
                return;
            }
            JTreeCellData jTreeCellData = jMutableTreeNode.getModel();
            if (!URLFileSystem.isDirectory(uRL)) {
                return;
            }
            DirectoryExcludeFilter directoryExcludeFilter = nodeData.getDirectoryFilter();
            FileTypeIncludeFilter fileTypeIncludeFilter = nodeData.getFileTypeFilter();
            if (jMutableTreeNode.getChildCount() <= 0) break block4;
            Enumeration<TreeNode> enumeration = jMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                JTreeCellData jTreeCellData2;
                JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
                NodeData nodeData2 = (NodeData)jMutableTreeNode2.getUserObject();
                URL uRL2 = nodeData2.getURL();
                boolean bl = URLFileSystem.isDirectory(uRL2);
                boolean bl2 = true;
                if (bl && directoryExcludeFilter != null) {
                    bl2 = this.canFileBeAddedToList(uRL2, directoryExcludeFilter.getList(), 1);
                    this.updateCheckBoxState(jMutableTreeNode2, jMutableTreeNode2.getModel(), bl2, bl);
                    this.reapplyExistingFilters(jMutableTreeNode2);
                    if (jMutableTreeNode2.getChildCount() <= 0) continue;
                    JMutableTreeNode jMutableTreeNode3 = (JMutableTreeNode)jMutableTreeNode2.getChildAt(0);
                    jMutableTreeNode3.ascendingUpdateNodes();
                    continue;
                }
                if (bl || fileTypeIncludeFilter == null || !(jTreeCellData2 = jMutableTreeNode2.getModel()).isCheckBoxSelectable()) continue;
                bl2 = this.canFileBeAddedToList(uRL2, fileTypeIncludeFilter.getList(), 0);
                this.updateCheckBoxState(jMutableTreeNode2, jMutableTreeNode2.getModel(), bl2, bl);
            }
            JMutableTreeNode jMutableTreeNode4 = (JMutableTreeNode)jMutableTreeNode.getChildAt(0);
            jMutableTreeNode4.ascendingUpdateNodes();
        }
    }

    private void saveFilter(FileFilter fileFilter, int n) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExtensions = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ExcludeFilterSettings excludeFilterSettings = documentExtensions.getExcludeFilterSettings();
        if (excludeFilterSettings == null) {
            excludeFilterSettings = new ExcludeFilterSettings();
            documentExtensions.setExcludeFilterSettings(excludeFilterSettings);
        }
        if (n == 0) {
            excludeFilterSettings.setFileTypeIncludeFilter((FileTypeIncludeFilter)fileFilter);
        } else {
            excludeFilterSettings.setDirectoryExcludeFilter((DirectoryExcludeFilter)fileFilter);
        }
    }

    private FileFilter getOrCreateFilter(int n) {
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExtensions = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ExcludeFilterSettings excludeFilterSettings = documentExtensions.getExcludeFilterSettings();
        DirectoryExcludeFilter directoryExcludeFilter = null;
        if (excludeFilterSettings != null) {
            directoryExcludeFilter = n == 0 ? excludeFilterSettings.getFileTypeIncludeFilter() : excludeFilterSettings.getDirectoryExcludeFilter();
        }
        if (directoryExcludeFilter == null) {
            directoryExcludeFilter = n == 0 ? new FileTypeIncludeFilter() : new DirectoryExcludeFilter();
        }
        return directoryExcludeFilter;
    }

    private JMutableTreeNode getNearestDirectory() {
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (jMutableTreeNode.isLeaf()) {
            return (JMutableTreeNode)jMutableTreeNode.getParent();
        }
        return jMutableTreeNode;
    }

    private URL findParentURLInList(URL uRL, List list) {
        int n = 0;
        while (n < list.size()) {
            if (URLFileSystem.isBaseURLFor((URL)list.get(n), uRL)) {
                return (URL)list.get(n);
            }
            ++n;
        }
        return null;
    }

    private void copyFilesToProject(Component component) {
        this._runOption = 1;
        this._copiedFiles = new ArrayList(this._selectedFiles.size());
        this._progressBar = new ProgressBar(component, DirOptionsArb.getString(7), this, true);
        this._progressBar.start(DirOptionsArb.getString(6), null);
        this._progressBar.waitUntilDone();
        boolean bl = false;
        if (this._progressBar.hasUserCancelled()) {
            int n = JOptionPane.showConfirmDialog(component, DirOptionsArb.getString(17), DirOptionsArb.getString(18), 0);
            if (n == 0) {
                Iterator iterator = this._copiedFiles.iterator();
                while (iterator.hasNext()) {
                    URLFileSystem.delete((URL)iterator.next());
                    iterator.remove();
                }
            }
            bl = true;
        }
        if (this._selectedFiles.size() > 0 && !bl) {
            JOptionPane.showMessageDialog(component, DirOptionsArb.getString(19), DirOptionsArb.getString(20), 0);
        }
    }

    public void _fileTypeBtn_actionPerformed(ActionEvent actionEvent) {
        FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel;
        JMutableTreeNode jMutableTreeNode = this.getNearestDirectory();
        String string = jMutableTreeNode.getModel().getText();
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        FileTypeIncludeFilter fileTypeIncludeFilter = nodeData.getFileTypeFilter();
        FileTypeIncludeFilter fileTypeIncludeFilter2 = new FileTypeIncludeFilter();
        if (fileTypeIncludeFilter != null) {
            fileTypeIncludeFilter.copyTo(fileTypeIncludeFilter2);
        }
        if ((fileTypeIncludeFilterPanel = new FileTypeIncludeFilterPanel(fileTypeIncludeFilter2)).showDialog(this, string) && (fileTypeIncludeFilter == null || !fileTypeIncludeFilter.equals(fileTypeIncludeFilter2))) {
            this.saveFilter(fileTypeIncludeFilter2, 0);
            if (fileTypeIncludeFilter2.getApplyToDirectory() == 0) {
                Enumeration<TreeNode> enumeration = this._rootNode.children();
                while (enumeration.hasMoreElements()) {
                    this.applyFilter((JMutableTreeNode)enumeration.nextElement(), fileTypeIncludeFilter2, 0, true);
                }
            } else {
                this.applyFilter(jMutableTreeNode, fileTypeIncludeFilter2, 0, true);
            }
        }
    }

    public void _addBtn_actionPerformed(ActionEvent actionEvent) {
        URL[] uRLArray;
        URLChooser uRLChooser = null;
        if (this._lastURLDirectory == null) {
            uRLChooser = DialogUtil.newURLChooser();
            DialogUtil.initURLChooser(uRLChooser, this._context);
        } else {
            uRLChooser = DialogUtil.newURLChooser(this._lastURLDirectory);
        }
        uRLChooser.setSelectionScope(2);
        int n = uRLChooser.showOpenDialog(this, DirOptionsArb.getString(12));
        if (n == 0 && (uRLArray = uRLChooser.getSelectedURLs()) != null) {
            this.populateTree(uRLArray);
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
            this._removeBtn.setEnabled(true);
        }
        if (this._tree.getSelectionCount() == 0) {
            this._tree.setSelectionRow(0);
        }
    }

    public void _removeBtn_actionPerformed(ActionEvent actionEvent) {
        TreePath treePath = this._tree.getSelectionPath();
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        jMutableTreeNode.removeFromParent();
        this._treeModel.reload(this._rootNode);
        if (this._tree.getRowCount() == 0) {
            this._removeBtn.setEnabled(false);
        }
    }

    public void _dirFilterBtn_actionPerformed(ActionEvent actionEvent) {
        DirectoryExcludeFilterPanel directoryExcludeFilterPanel;
        JMutableTreeNode jMutableTreeNode = this.getNearestDirectory();
        String string = jMutableTreeNode.getModel().getText();
        NodeData nodeData = (NodeData)jMutableTreeNode.getUserObject();
        DirectoryExcludeFilter directoryExcludeFilter = nodeData.getDirectoryFilter();
        DirectoryExcludeFilter directoryExcludeFilter2 = new DirectoryExcludeFilter();
        if (directoryExcludeFilter != null) {
            directoryExcludeFilter.copyTo(directoryExcludeFilter2);
        }
        if ((directoryExcludeFilterPanel = new DirectoryExcludeFilterPanel()).showDialog(this, directoryExcludeFilter2, string) && (directoryExcludeFilter == null || !directoryExcludeFilter.equals(directoryExcludeFilter2))) {
            this.saveFilter(directoryExcludeFilter2, 1);
            if (directoryExcludeFilter2.getApplyToDirectory() == 0) {
                Enumeration<TreeNode> enumeration = this._rootNode.children();
                while (enumeration.hasMoreElements()) {
                    this.applyFilter((JMutableTreeNode)enumeration.nextElement(), directoryExcludeFilter2, 1, true);
                }
            } else {
                this.applyFilter(jMutableTreeNode, directoryExcludeFilter2, 1, true);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        if (treePath == null) {
            this._fileTypeBtn.setEnabled(false);
            this._dirFilterBtn.setEnabled(false);
            this._removeBtn.setEnabled(false);
        } else {
            this._fileTypeBtn.setEnabled(true);
            this._dirFilterBtn.setEnabled(true);
            this._removeBtn.setEnabled(true);
        }
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)treePath.getLastPathComponent();
        if (!jMutableTreeNode.isLeaf()) {
            1 var4_4 = new 1(this, jMutableTreeNode);
            SwingUtilities.invokeLater(var4_4);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    private String getPackage(URL uRL) {
        String string;
        block14: {
            string = "";
            try {
                TextNode textNode;
                TextBuffer textBuffer;
                Node node = NodeFactory.findOrCreate(uRL);
                if (!(node instanceof TextNode) || (textBuffer = (textNode = (TextNode)node).acquireTextBuffer()) == null) break block14;
                textBuffer.readLock();
                try {
                    JavaLexer javaLexer = new JavaLexer();
                    javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
                    javaLexer.setPosition(0);
                    javaLexer.setSkipComments(true);
                    LexerToken lexerToken = javaLexer.createLexerToken();
                    int n = javaLexer.lex(lexerToken);
                    if (n == 125) {
                        FastStringBuffer fastStringBuffer = new FastStringBuffer();
                        boolean bl = false;
                        block10: while (true) {
                            switch (javaLexer.lex(lexerToken)) {
                                case 4: {
                                    if (bl) {
                                        fastStringBuffer.append('.');
                                        bl = false;
                                    }
                                    int n2 = lexerToken.getStartOffset();
                                    int n3 = lexerToken.getEndOffset() - n2;
                                    fastStringBuffer.append(textBuffer.getChars(n2, n3));
                                    continue block10;
                                }
                                case 43: {
                                    bl = true;
                                    continue block10;
                                }
                            }
                            break;
                        }
                        fastStringBuffer.append("/");
                        string = fastStringBuffer.toString();
                    }
                }
                finally {
                    textBuffer.readUnlock();
                    textNode.releaseTextBuffer();
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (string.length() == 0) {
            return null;
        }
        return string.replace('.', '/');
    }

    static void mav$addChildrenFromFileSystem(DirectoryOptionsPanel directoryOptionsPanel, JMutableTreeNode jMutableTreeNode) {
        directoryOptionsPanel.addChildrenFromFileSystem(jMutableTreeNode);
    }

    static DefaultTreeModel ra$_treeModel(DirectoryOptionsPanel directoryOptionsPanel) {
        return directoryOptionsPanel._treeModel;
    }

    public final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryOptionsPanel.this._dirFilterBtn_actionPerformed(actionEvent);
        }
    }

    public final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryOptionsPanel.this._fileTypeBtn_actionPerformed(actionEvent);
        }
    }

    public final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryOptionsPanel.this._removeBtn_actionPerformed(actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryOptionsPanel.this._addBtn_actionPerformed(actionEvent);
        }
    }

    public final class 2
    extends JMutableTreeNode {
        public boolean isLeaf() {
            return this.allowsChildren ^ true;
        }

        public 2(JTreeCellData jTreeCellData, boolean bl) {
            super(jTreeCellData, bl);
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ JMutableTreeNode v$node;
        final /* synthetic */ DirectoryOptionsPanel this$0;

        public void run() {
            Ide.getWaitCursor().show();
            try {
                if (this.v$node.getChildCount() == 0) {
                    DirectoryOptionsPanel.mav$addChildrenFromFileSystem(this.this$0, this.v$node);
                    DirectoryOptionsPanel.ra$_treeModel(this.this$0).reload(this.v$node);
                }
            }
            finally {
                Ide.getWaitCursor().hide();
            }
        }

        public 1(DirectoryOptionsPanel directoryOptionsPanel, JMutableTreeNode jMutableTreeNode) {
            this.v$node = jMutableTreeNode;
            this.this$0 = directoryOptionsPanel;
        }
    }

    private static class NodeData {
        private URL _url;
        private FileTypeIncludeFilter _fileTypeFilter;
        private DirectoryExcludeFilter _directoryFilter;

        public NodeData(URL uRL, FileTypeIncludeFilter fileTypeIncludeFilter, DirectoryExcludeFilter directoryExcludeFilter) {
            this._url = uRL;
            this._fileTypeFilter = fileTypeIncludeFilter;
            this._directoryFilter = directoryExcludeFilter;
        }

        public NodeData(URL uRL) {
            this(uRL, null, null);
        }

        public URL getURL() {
            return this._url;
        }

        public FileTypeIncludeFilter getFileTypeFilter() {
            return this._fileTypeFilter;
        }

        public void setFileTypeFilter(FileFilter fileFilter) {
            this._fileTypeFilter = (FileTypeIncludeFilter)fileFilter;
        }

        public DirectoryExcludeFilter getDirectoryFilter() {
            return this._directoryFilter;
        }

        public void setDirectoryFilter(FileFilter fileFilter) {
            this._directoryFilter = (DirectoryExcludeFilter)fileFilter;
        }
    }
}

