/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.filter.DirectoryExcludeFilter;
import oracle.ide.dialogs.filter.FileFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;

public class FileTypeIncludeFilter
extends DirectoryExcludeFilter
implements Copyable,
FileFilter {
    private ArrayList _userAddedExtensions;
    private boolean _includeAllFiles;
    private ArrayList _selectedExtensions;
    private CheckBoxListModel _listModel;
    private ArrayList _allSelectedFilters;

    void $init$() {
        this._userAddedExtensions = new ArrayList();
        this._includeAllFiles = true;
        this._selectedExtensions = new ArrayList();
        this._listModel = new CheckBoxListModel();
        this._allSelectedFilters = new ArrayList();
    }

    public FileTypeIncludeFilter() {
        this.$init$();
    }

    public void populateListModel() {
        if (this._listModel.getSize() > 0) {
            return;
        }
        IdeSettings ideSettings = Ide.getSettings();
        DocumentExtensions documentExtensions = (DocumentExtensions)ideSettings.getData("document-extensions-options");
        ArrayList<String> arrayList = new ArrayList<String>(25);
        Collection collection = documentExtensions.getDocuments();
        for (DocumentExtensions.DocRecord docRecord : collection) {
            List list = docRecord.getExtensions();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                DocumentExtensions.ExtInfo extInfo = (DocumentExtensions.ExtInfo)list.get(n2);
                String string = extInfo.getExtension();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    TextPair textPair = new TextPair(string);
                    this.parseFilterText(textPair);
                    FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), extInfo.isLocked());
                    this._listModel.addElement(filterInfo, null, true, false, textPair.getDisplayText());
                }
                ++n2;
            }
        }
        Iterator iterator = null;
        iterator = this._userAddedExtensions.iterator();
        while (iterator.hasNext()) {
            TextPair textPair = new TextPair((String)iterator.next());
            this.parseFilterText(textPair);
            if (this._listModel.findElementByText(textPair.getDisplayText()) != -1) {
                iterator.remove();
                continue;
            }
            FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
            this._listModel.addElement(filterInfo, null, true, false, textPair.getDisplayText());
        }
        for (String string : this._selectedExtensions) {
            int n = this._listModel.findElementByText(string);
            if (n == -1) continue;
            this._listModel.setElementSelected(n);
        }
        this._listModel.sort();
    }

    public ArrayList getUserAddedExtensions() {
        return this._userAddedExtensions;
    }

    public void setUserAddedExtensions(ArrayList arrayList) {
        this._userAddedExtensions = arrayList;
    }

    public CheckBoxListModel getListModel() {
        return this._listModel;
    }

    public void setListModel(CheckBoxListModel checkBoxListModel) {
        this._listModel = checkBoxListModel;
    }

    public boolean getIncludeAllFiles() {
        return this._includeAllFiles;
    }

    public void setIncludeAllFiles(boolean bl) {
        this._includeAllFiles = bl;
    }

    public List getList() {
        if (this._includeAllFiles) {
            return null;
        }
        return this._allSelectedFilters;
    }

    public static boolean equals(FileTypeIncludeFilter fileTypeIncludeFilter, FileTypeIncludeFilter fileTypeIncludeFilter2) {
        if (!DirectoryExcludeFilter.equals(fileTypeIncludeFilter, fileTypeIncludeFilter2)) {
            return false;
        }
        if (fileTypeIncludeFilter.getIncludeAllFiles() != fileTypeIncludeFilter2.getIncludeAllFiles()) {
            return false;
        }
        if (!fileTypeIncludeFilter.getUserAddedExtensions().equals(fileTypeIncludeFilter2.getUserAddedExtensions())) {
            return false;
        }
        if (!fileTypeIncludeFilter.getList().equals(fileTypeIncludeFilter2.getList())) {
            return false;
        }
        return fileTypeIncludeFilter.getListModel().equals(fileTypeIncludeFilter2.getListModel());
    }

    public void clearAllSelectedFilters() {
        this._allSelectedFilters.clear();
    }

    public void setSelectedFilters() {
        List list = this._listModel.getSelectionList();
        if (list != null) {
            for (FilterInfo filterInfo : list) {
                this._allSelectedFilters.add(filterInfo.getURLFilter());
            }
        }
        this._selectedExtensions.clear();
        int n = this._listModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (this._listModel.isElementSelected(n2)) {
                this._selectedExtensions.add(this._listModel.findTextForElement(n2));
            }
            ++n2;
        }
        List list2 = this.parseUserDefinedFilterString();
        this._allSelectedFilters.addAll(list2);
    }

    public void removeUserDefinedValueFromList(int n) {
        String string = this._listModel.findTextForElement(n);
        if (string.startsWith("*.") && !WildcardURLFilter.hasWildcard(string.substring(2))) {
            string = string.substring(1);
        }
        this._userAddedExtensions.remove(string);
        this._listModel.removeElementByIndex(n);
    }

    public boolean addUserDefinedValueToList(String string) {
        TextPair textPair = new TextPair(string);
        this.parseFilterText(textPair);
        if (this._userAddedExtensions.contains(textPair.getFilterText())) {
            return false;
        }
        this._userAddedExtensions.add(textPair.getFilterText());
        FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
        this._listModel.addElement(filterInfo, null, true, true, textPair.getDisplayText());
        this._listModel.sort();
        return true;
    }

    public ArrayList getSelectedExtensions() {
        return this._selectedExtensions;
    }

    public void setSelectedExtensions(ArrayList arrayList) {
        this._selectedExtensions = arrayList;
        int n = this._selectedExtensions.size();
        int n2 = 0;
        while (n2 < n) {
            TextPair textPair = new TextPair((String)this._selectedExtensions.get(n2));
            this.parseFilterText(textPair);
            FilterInfo filterInfo = new FilterInfo(textPair.getFilterText(), false);
            this._allSelectedFilters.add(filterInfo.getURLFilter());
            ++n2;
        }
    }

    private void parseFilterText(TextPair textPair) {
        if (textPair.getFilterText().startsWith("*.") && !WildcardURLFilter.hasWildcard(textPair.getFilterText().substring(2))) {
            textPair.setDisplayText(textPair.getFilterText());
            textPair.setFilterText(textPair.getFilterText().substring(1));
        } else if (textPair.getFilterText().startsWith(".") && !WildcardURLFilter.hasWildcard(textPair.getFilterText())) {
            textPair.setDisplayText("*" + textPair.getFilterText());
        } else {
            textPair.setDisplayText(textPair.getFilterText());
        }
    }

    public boolean isListElementLocked(int n) {
        FilterInfo filterInfo = (FilterInfo)this._listModel.getUserObjectAt(n);
        return filterInfo.isSystemDefined();
    }

    public Object copyTo(Object object) {
        FileTypeIncludeFilter fileTypeIncludeFilter = object != null ? (FileTypeIncludeFilter)object : new FileTypeIncludeFilter();
        this.copyToImpl(fileTypeIncludeFilter);
        return fileTypeIncludeFilter;
    }

    protected final void copyToImpl(FileTypeIncludeFilter fileTypeIncludeFilter) {
        fileTypeIncludeFilter.setIncludeAllFiles(this.getIncludeAllFiles());
        fileTypeIncludeFilter.setRecurseDirectories(this.getRecurseDirectories());
        fileTypeIncludeFilter.setApplyToDirectory(this.getApplyToDirectory());
        fileTypeIncludeFilter.setUserDefinedExclusions(this.getUserDefinedExclusions());
        ModelUtil.deepCopy((List)this._userAddedExtensions, (List)fileTypeIncludeFilter._userAddedExtensions);
        ModelUtil.deepCopy((List)this._allSelectedFilters, (List)fileTypeIncludeFilter._allSelectedFilters);
        ModelUtil.deepCopy((List)this._selectedExtensions, (List)fileTypeIncludeFilter._selectedExtensions);
        if (this._listModel != null) {
            this._listModel.copyTo(fileTypeIncludeFilter._listModel);
        }
    }

    public static class FilterInfo {
        private URLFilter _urlFilter;
        private boolean _systemDefined;

        public FilterInfo(String string, boolean bl) {
            this._urlFilter = DirectoryExcludeFilter.createURLFilter(string, 0);
            this._systemDefined = bl;
        }

        public URLFilter getURLFilter() {
            return this._urlFilter;
        }

        public boolean isSystemDefined() {
            return this._systemDefined;
        }
    }

    private static class TextPair {
        String _filterText;
        String _displayText;

        public TextPair(String string) {
            this._filterText = string;
        }

        public String getFilterText() {
            return this._filterText;
        }

        public void setFilterText(String string) {
            this._filterText = string;
        }

        public String getDisplayText() {
            return this._displayText;
        }

        public void setDisplayText(String string) {
            this._displayText = string;
        }
    }
}

