/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;

public class FileTypeIncludeFilterPanel
extends JPanel
implements ListSelectionListener {
    private JLabel _listPanelLbl;
    private CheckBoxListPanel _listPanel;
    private FileTypeIncludeFilter _filter;
    private JLabel _otherLbl;
    private JTextField _otherFld;
    private JRadioButton _selectedDirRB;
    private JRadioButton _allDirRB;
    private ButtonGroup _buttonGroup;
    private JCheckBox _recurseCB;
    private JButton _addToListBtn;
    private JButton _removeFromListBtn;
    private JRadioButton _allTypesRB;
    private JRadioButton _selectedTypesRB;
    private ButtonGroup _typeButtonGroup;
    private static final String HELP_TOPIC = "f1_idedfiletypestoexclude_html";

    void $init$() {
        this._listPanelLbl = new JLabel();
        this._otherLbl = new JLabel();
        this._otherFld = new JTextField();
        this._selectedDirRB = new JRadioButton();
        this._allDirRB = new JRadioButton();
        this._buttonGroup = new ButtonGroup();
        this._recurseCB = new JCheckBox();
        this._addToListBtn = new JButton();
        this._removeFromListBtn = new JButton();
        this._allTypesRB = new JRadioButton();
        this._selectedTypesRB = new JRadioButton();
        this._typeButtonGroup = new ButtonGroup();
    }

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter fileTypeIncludeFilter) {
        this.$init$();
        this._filter = fileTypeIncludeFilter;
        this.initPanel(true);
    }

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter fileTypeIncludeFilter, boolean bl) {
        this.$init$();
        this._filter = fileTypeIncludeFilter;
        this.initPanel(bl);
    }

    private void initPanel(boolean bl) {
        ResourceUtils.resButton(this._allTypesRB, DialogsArb.getString(32));
        ResourceUtils.resButton(this._selectedTypesRB, DialogsArb.getString(33));
        ResourceUtils.resButton(this._allDirRB, DialogsArb.getString(22));
        ResourceUtils.resLabel(this._otherLbl, this._otherFld, DialogsArb.getString(26));
        ResourceUtils.resButton(this._recurseCB, DialogsArb.getString(24));
        ResourceUtils.resButton(this._addToListBtn, DialogsArb.getString(28));
        this._addToListBtn.setEnabled(false);
        this._addToListBtn.addActionListener(new 3());
        ResourceUtils.resButton(this._removeFromListBtn, DialogsArb.getString(29));
        this._removeFromListBtn.setEnabled(false);
        this._removeFromListBtn.addActionListener(new 2());
        this._otherFld.getDocument().addDocumentListener(new 1());
        this._listPanel = new CheckBoxListPanel(this._filter.getListModel());
        this._listPanel.getScrollPane().getViewport().setViewSize(new Dimension(100, 200));
        ResourceUtils.resLabel(this._listPanelLbl, this._listPanel.getList(), DialogsArb.getString(34));
        this._listPanel.addButton(this._removeFromListBtn);
        this._listPanel.layoutButtons();
        this.setLayout(new GridBagLayout());
        this._typeButtonGroup.add(this._allTypesRB);
        this._typeButtonGroup.add(this._selectedTypesRB);
        this.add((Component)this._allTypesRB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._allTypesRB.setSelected(true);
        this.add((Component)this._selectedTypesRB, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker(this._selectedTypesRB, new Component[]{this._listPanel.getList(), this._listPanel.getSelectAllButton(), this._listPanel.getDeselectAllButton(), this._otherFld, this._recurseCB, this._allDirRB, this._selectedDirRB});
        this.add((Component)this._listPanelLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._listPanel, new GridBagConstraints(0, 3, 3, 4, 1.0, 1.0, 17, 1, new Insets(0, 5, 15, 0), 0, 0));
        this.add((Component)this._otherLbl, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._otherFld, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._addToListBtn, new GridBagConstraints(2, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        if (bl) {
            this._buttonGroup.add(this._selectedDirRB);
            this._buttonGroup.add(this._allDirRB);
            this._allDirRB.setSelected(true);
            this.add((Component)this._allDirRB, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            this._recurseCB.setSelected(true);
            this.add((Component)this._selectedDirRB, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this._recurseCB, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        }
        this._listPanel.getList().addListSelectionListener(this);
        this._listPanel.getList().setSelectionMode(0);
    }

    public boolean showDialog(Component component, String string) {
        if (this._filter == null) {
            this._filter = new FileTypeIncludeFilter();
        }
        ResourceUtils.resButton(this._selectedDirRB, DialogsArb.format(21, string));
        JEWTDialog jEWTDialog = this.createDialog(component);
        if (jEWTDialog == null) {
            return false;
        }
        if (jEWTDialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    public boolean showDialog(Component component) {
        JEWTDialog jEWTDialog = this.createDialog(component);
        if (jEWTDialog == null) {
            return false;
        }
        if (jEWTDialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    protected JEWTDialog createDialog(Component component) {
        this._filter.clearAllSelectedFilters();
        this._filter.populateListModel();
        this.loadFrom(this._filter);
        HelpSystem.getHelpSystem().registerTopic(this, HELP_TOPIC);
        JEWTDialog jEWTDialog = DialogUtil.createJEWTDialogOwnedBy(component);
        if (jEWTDialog == null) {
            return null;
        }
        jEWTDialog.setCenterOver(component);
        jEWTDialog.setContent((Component)this);
        jEWTDialog.setInitialFocus((Component)this._listPanel.getList());
        jEWTDialog.setTitle(DialogsArb.getString(27));
        jEWTDialog.setButtonMask(7);
        jEWTDialog.setResizable(true);
        jEWTDialog.setPreferredSize(new Dimension(400, 500));
        return jEWTDialog;
    }

    private void loadFrom(FileTypeIncludeFilter fileTypeIncludeFilter) {
        if (fileTypeIncludeFilter.getIncludeAllFiles()) {
            this._allTypesRB.setSelected(true);
        } else {
            this._selectedTypesRB.setSelected(true);
        }
        this._recurseCB.setSelected(fileTypeIncludeFilter.getRecurseDirectories());
        if (fileTypeIncludeFilter.getApplyToDirectory() == 1) {
            this._selectedDirRB.setSelected(true);
            this._allDirRB.setSelected(false);
        } else {
            this._selectedDirRB.setSelected(false);
            this._allDirRB.setSelected(true);
        }
        String string = fileTypeIncludeFilter.getUserDefinedExclusions();
        if (ModelUtil.hasLength((String)string)) {
            this._otherFld.setText(string);
            this._addToListBtn.setEnabled(true);
        } else {
            this._addToListBtn.setEnabled(false);
        }
    }

    private void commitTo(FileTypeIncludeFilter fileTypeIncludeFilter) {
        fileTypeIncludeFilter.setIncludeAllFiles(this._allTypesRB.isSelected());
        fileTypeIncludeFilter.setRecurseDirectories(this._recurseCB.isSelected());
        int n = this._selectedDirRB.isSelected() ? 1 : 0;
        fileTypeIncludeFilter.setApplyToDirectory(n);
        fileTypeIncludeFilter.setUserDefinedExclusions(this._otherFld.getText());
        fileTypeIncludeFilter.setSelectedFilters();
    }

    private void _addToListBtn_actionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this._otherFld.getText(), ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (this._filter.addUserDefinedValueToList(string)) continue;
            JOptionPane.showMessageDialog(this, DialogsArb.format(30, string), DialogsArb.getString(31), 0);
        }
        this._otherFld.setText("");
        this._addToListBtn.setEnabled(false);
    }

    private void _removeFromListBtn_actionPerformed(ActionEvent actionEvent) {
        int n = this._listPanel.getList().getSelectedIndex();
        this._filter.removeUserDefinedValueFromList(n);
        n = Math.min(n, this._listPanel.getList().getModel().getSize() - 1);
        this._listPanel.getList().setSelectedIndex(n);
        this._listPanel.getList().requestFocus();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this._listPanel.getList().getSelectedIndex();
        if (n < 0 || n > this._listPanel.getList().getModel().getSize() - 1) {
            return;
        }
        if (this._filter.isListElementLocked(n)) {
            this._removeFromListBtn.setEnabled(false);
        } else {
            this._removeFromListBtn.setEnabled(true);
        }
    }

    static void mav$_addToListBtn_actionPerformed(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel, ActionEvent actionEvent) {
        fileTypeIncludeFilterPanel._addToListBtn_actionPerformed(actionEvent);
    }

    static void mav$_removeFromListBtn_actionPerformed(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel, ActionEvent actionEvent) {
        fileTypeIncludeFilterPanel._removeFromListBtn_actionPerformed(actionEvent);
    }

    static JButton ra$_addToListBtn(FileTypeIncludeFilterPanel fileTypeIncludeFilterPanel) {
        return fileTypeIncludeFilterPanel._addToListBtn;
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileTypeIncludeFilterPanel.mav$_addToListBtn_actionPerformed(FileTypeIncludeFilterPanel.this, actionEvent);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileTypeIncludeFilterPanel.mav$_removeFromListBtn_actionPerformed(FileTypeIncludeFilterPanel.this, actionEvent);
        }
    }

    public final class 1
    implements DocumentListener {
        public void insertUpdate(DocumentEvent documentEvent) {
            FileTypeIncludeFilterPanel.ra$_addToListBtn(FileTypeIncludeFilterPanel.this).setEnabled(documentEvent.getDocument().getLength() > 0);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FileTypeIncludeFilterPanel.ra$_addToListBtn(FileTypeIncludeFilterPanel.this).setEnabled(documentEvent.getDocument().getLength() > 0);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

