/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.MenuElement;
import oracle.ide.Context;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockableView;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.GraphicsUtils;

public final class DockUtil {
    private static final boolean SMART_BEHAVIOR = true;

    public static void showDockableWindow(DockableView dockableView) {
        dockableView.show();
        DockStation dockStation = DockStation.getDockStation();
        dockStation.activateDockable(dockableView);
    }

    public static void hideDockableWindow(DockableView dockableView) {
        if (GraphicsUtils.isAncestorOfFocusedComponent(dockableView.getGUI())) {
            EditorManager editorManager = EditorManager.getEditorManager();
            editorManager.activateCurrentEditorFrame();
        }
        dockableView.close();
    }

    public static void toggleDockableWindow(DockableView dockableView) {
        if (dockableView.isVisible()) {
            DockUtil.hideDockableWindow(dockableView);
        } else {
            DockUtil.showDockableWindow(dockableView);
        }
    }

    public static void smartToggleDockableWindow(DockableView dockableView, Context context) {
        Object object;
        EventObject eventObject;
        boolean bl = true;
        if (context != null && (eventObject = context.getEvent()) != null && (object = eventObject.getSource()) != null && !(object instanceof MenuElement)) {
            bl = false;
        }
        if (bl) {
            DockUtil.toggleDockableWindow(dockableView);
        } else if (!dockableView.isVisible()) {
            DockUtil.showDockableWindow(dockableView);
        } else {
            Component component = dockableView.getGUI();
            if (GraphicsUtils.isAncestorOfFocusedComponent(component)) {
                DockUtil.hideDockableWindow(dockableView);
            } else {
                DockStation dockStation = DockStation.getDockStation();
                dockStation.activateDockable(dockableView);
            }
        }
    }
}

