/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.docking;

import java.awt.Component;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableEvent;
import oracle.ide.docking.DockableListener;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.Site;
import oracle.ide.docking.TitleChangeEvent;
import oracle.ide.docking.TitleChangeListener;
import oracle.ide.layout.Layout;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.ViewId;
import oracle.ide.util.BitField;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class DockableWindow
extends DockableView {
    private ArrayList titleChangeListener;
    private Site site;
    private int type;

    void $init$() {
        this.titleChangeListener = new ArrayList(2);
        this.site = new Site();
        this.type = 0;
    }

    static {
        DockStation dockStation = DockStation.getDockStation();
        if (dockStation != null) {
            dockStation.addDockableListener(new ShowHideTranslator(), null);
        }
    }

    protected DockableWindow() {
        this.$init$();
    }

    protected DockableWindow(String string) {
        this(Ide.getMainWindow().getIdeMainWindowView(), string);
    }

    protected DockableWindow(View view, String string) {
        this.$init$();
        this.setOwner(view);
        this.setId(string);
        Layouts.getLayouts().addView(new ViewId(string), this);
    }

    protected DockableWindow(IdeMainWindow ideMainWindow, String string) {
        this(string);
    }

    protected Dockable getCachedDockable() {
        ViewId viewId = new ViewId(this.getId());
        return DockStation.getDockStation().getDockable(viewId);
    }

    public void close() {
        Dockable dockable = this.getCachedDockable();
        if (dockable != null) {
            DockStation.getDockStation().close(dockable);
        }
    }

    public void show() {
        this.setDockableVisible(true);
    }

    public boolean isVisible() {
        boolean bl = false;
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = this.getCachedDockable();
        if (dockable != null) {
            int n = dockStation.getDockableStatus(dockable);
            bl = BitField.isSet(n, 32);
        }
        return bl;
    }

    public void setDockableVisible(boolean bl) {
        DockStation.getDockStation().setDockableVisible(this.getId(), bl);
    }

    public void updateTitle(Object object) {
        this.fireTitleChangeListener();
    }

    public Icon getTabIcon() {
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getUniqueName() {
        return this.getId();
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public JComponent getHostedComponent() {
        JComponent jComponent = null;
        try {
            jComponent = (JComponent)this.getGUI();
        }
        catch (Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)((Object)Ide.getMainWindow()), (Throwable)throwable);
        }
        return jComponent;
    }

    public DropTargetListener getTabDropListener() {
        return null;
    }

    public String getMenuTitle() {
        return this.getTabName();
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public void saveLayout(PropertyAccess propertyAccess) {
    }

    public void loadLayout(PropertyAccess propertyAccess) {
    }

    public void addTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.titleChangeListener.add(titleChangeListener);
    }

    public void removeTitleChangeListener(TitleChangeListener titleChangeListener) {
        this.titleChangeListener.remove(titleChangeListener);
    }

    public void stateChange(int n) {
        switch (n) {
            case 1: {
                Ide.getMainWindow().registerView(this);
                break;
            }
            case 2: {
                Ide.getMainWindow().unregisterView(this);
                break;
            }
            case 3: {
                Ide.getMainWindow().unregisterView(this);
                this.fireViewClosed();
            }
        }
    }

    protected void fireTitleChangeListener() {
        TitleChangeEvent titleChangeEvent = new TitleChangeEvent(this);
        int n = 0;
        while (n < this.titleChangeListener.size()) {
            TitleChangeListener titleChangeListener = (TitleChangeListener)this.titleChangeListener.get(n);
            titleChangeListener.titleChange(titleChangeEvent);
            ++n;
        }
    }

    private void _stateChange(int n) {
        this.stateChange(n);
    }

    protected void dockableHidden(DockableEvent dockableEvent) {
        this._stateChange(2);
        if (BitField.isSet(dockableEvent.getContext(), 16)) {
            this._stateChange(3);
        }
    }

    protected void dockableShown(DockableEvent dockableEvent) {
        this._stateChange(1);
    }

    public static class ShowHideTranslator
    implements DockableListener {
        public void dockableHidden(DockableEvent dockableEvent) {
            Dockable dockable = dockableEvent.getSource();
            if (dockable instanceof DockableWindow) {
                DockableWindow dockableWindow = (DockableWindow)dockable;
                dockableWindow.dockableHidden(dockableEvent);
            }
        }

        public void dockableShown(DockableEvent dockableEvent) {
            Dockable dockable = dockableEvent.getSource();
            if (dockable instanceof DockableWindow) {
                DockableWindow dockableWindow = (DockableWindow)dockable;
                dockableWindow.dockableShown(dockableEvent);
            }
        }

        ShowHideTranslator() {
        }
    }
}

