/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutSelector;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutEvent;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.model.DefaultDirtyable;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;

public abstract class Editor
extends View
implements LayoutSelector,
Observer {
    public static final String ATTRIBUTE_SCROLLABLE = "scrollable";
    public static final String ATTRIBUTE_CUSTOM_HORIZONTAL_SCROLLBAR = "custom_horizontal_scrollbar";
    public static final String ATTRIBUTE_CUSTOM_VERTICAL_SCROLLBAR = "custom_vertical_scrollbar";
    public static final String ATTRIBUTE_HORIZONTAL_SCROLLBAR_POLICY = "horizontal_scrollbar_policy";
    public static final String ATTRIBUTE_VERTICAL_SCROLLBAR_POLICY = "vertical_scrollbar_policy";
    public static final String ATTRIBUTE_HORIZONTAL_UNIT_INCREMENT = "horizontal_unit_increment";
    public static final String ATTRIBUTE_VERTICAL_UNIT_INCREMENT = "vertical_unit_increment";
    public static final String ATTRIBUTE_HORIZONTAL_BLOCK_INCREMENT = "horizontal_block_increment";
    public static final String ATTRIBUTE_VERTICAL_BLOCK_INCREMENT = "vertical_block_increment";
    public static final String ATTRIBUTE_BACKGROUND_COLOR = "background_color";
    public static final String ATTRIBUTE_MENU_ID = "menu_id";
    public static final String ATTRIBUTE_OLD_EDITOR = "old_editor";
    private static final String EDITOR_ID = "Editor";
    private static int COUNTER = 0;
    protected static final Border CUSTOM_BORDER = null;
    protected Context _context;
    private final PropertyChangeSupport _listenerList;
    private static final Map _preferredLayoutMap = new HashMap();
    private String _type;
    private String _baseName;
    private final EventListenerList listenerList;

    void $init$() {
        this._listenerList = new PropertyChangeSupport(this);
        this.listenerList = new EventListenerList();
    }

    public abstract void open();

    public Editor() {
        this.$init$();
        this.setOwner(Ide.getMainWindow().getIdeMainWindowView());
    }

    public Component getDefaultFocusComponent() {
        Component component = this.getGUI();
        JComponent jComponent = GraphicsUtils.getFocusableComponentOrChild(component, true);
        return jComponent;
    }

    public String getTitleLabel() {
        Node node;
        Context context = this.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node == null) {
            return "";
        }
        String string = URLFileSystem.getPlatformPathName(node.getURL());
        return DefaultDirtyable.dirtyLabel(node, string);
    }

    public String getTabLabel() {
        Node node;
        Context context = this.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node == null) {
            return "";
        }
        String string = node.getShortLabel();
        return DefaultDirtyable.dirtyLabel(node, string);
    }

    public synchronized Icon getTabIcon() {
        Context context = this.getContext();
        Node node = context != null ? context.getNode() : null;
        return node != null ? node.getIcon() : IdeArb.getIcon(206);
    }

    public String getTabDescription() {
        Context context = this.getContext();
        Node node = context != null ? context.getNode() : null;
        return node != null ? node.getShortLabel() : "";
    }

    public synchronized void setContext(Context context) {
        Node node;
        Node node2;
        context = context == null ? Context.newIdeContext() : new Context(context);
        context.setView(this);
        Context context2 = this.getContext();
        if (context2 != null && (node2 = context2.getNode()) != null) {
            node2.detach(this);
        }
        if ((node = context.getNode()) != null) {
            node.attach(this);
        }
        this._context = context;
        if (node != null) {
            this._context.setNode(node);
        }
        this.setId(this.newId());
    }

    public Node[] getDependentNodes() {
        return null;
    }

    public void editorShown() {
    }

    public void editorHidden() {
    }

    public Controller getController() {
        return EditorManager.getEditorManager();
    }

    public Context getContext(EventObject eventObject) {
        if (this._context != null) {
            this._context.setSelection(this.getSelection());
            this._context.setEvent(eventObject);
        }
        return this._context;
    }

    public ContextMenu getContextMenu() {
        return EditorManager.getEditorManager().getContextMenu();
    }

    public void close() {
        Node node;
        this.deactivate();
        Context context = this.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node != null) {
            node.detach(this);
        }
        super.close();
    }

    public Component getBottomComponent() {
        return null;
    }

    public Object getEditorAttribute(String string) {
        if (string == ATTRIBUTE_HORIZONTAL_SCROLLBAR_POLICY) {
            return new Integer(32);
        }
        if (string == ATTRIBUTE_HORIZONTAL_UNIT_INCREMENT) {
            return new Integer(this.getScrollBarIncrement(true, 0));
        }
        if (string == ATTRIBUTE_HORIZONTAL_BLOCK_INCREMENT) {
            return new Integer(this.getScrollBarIncrement(false, 0));
        }
        if (string == ATTRIBUTE_VERTICAL_SCROLLBAR_POLICY) {
            return new Integer(22);
        }
        if (string == ATTRIBUTE_VERTICAL_UNIT_INCREMENT) {
            return new Integer(this.getScrollBarIncrement(true, 1));
        }
        if (string == ATTRIBUTE_VERTICAL_BLOCK_INCREMENT) {
            return new Integer(this.getScrollBarIncrement(false, 1));
        }
        return null;
    }

    public Component getFixedLeftMargin() {
        return null;
    }

    public Component getFixedRightMargin() {
        return null;
    }

    public Component getFixedTopMargin() {
        return null;
    }

    public Component getFixedBottomMargin() {
        return null;
    }

    public Component getScrollableLeftMargin() {
        return null;
    }

    public Component getScrollableTopMargin() {
        return null;
    }

    public Component getMiniToolbar() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._listenerList.removePropertyChangeListener(propertyChangeListener);
    }

    public void saveSettings(StructuredPropertyAccess structuredPropertyAccess) {
    }

    public void loadSettings(StructuredPropertyAccess structuredPropertyAccess) {
    }

    protected final void firePropertyChangeEvent(String string, Object object, Object object2) {
        this._listenerList.firePropertyChange(string, object, object2);
    }

    private int getScrollBarIncrement(boolean bl, int n) {
        int n2 = 1;
        Component component = this.getGUI();
        if (component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            Container container = component.getParent();
            if (container instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                Rectangle rectangle = jViewport.getVisibleRect();
                n2 = bl ? scrollable.getScrollableUnitIncrement(rectangle, n, 1) : scrollable.getScrollableBlockIncrement(rectangle, n, 1);
            }
        }
        return n2;
    }

    public URL getPreferredLayoutURL() {
        String string = this.getPreferredLayoutBaseName();
        if (string == null) {
            return null;
        }
        Layouts layouts = Layouts.getLayouts();
        IdeLayout ideLayout = layouts.getDesignLayout();
        LayoutData layoutData = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (layoutData == null || ideLayout.findLayout(LayoutData.ra$_url(layoutData)) == null) {
            layoutData = new LayoutData(layouts.buildLayoutURL(string));
            _preferredLayoutMap.put(this.getType(), layoutData);
        }
        if (ideLayout.findLayout(LayoutData.ra$_url(layoutData)) == null) {
            layouts.newDesignLayout(LayoutData.ra$_url(layoutData));
        }
        return LayoutData.ra$_url(layoutData);
    }

    public void setPreferredLayoutURL(URL uRL) {
        LayoutData layoutData = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (layoutData != null && LayoutData.ra$_url(layoutData).equals(uRL)) {
            return;
        }
        _preferredLayoutMap.put(this.getType(), new LayoutData(uRL));
    }

    public void initializeLayout(Layout layout) {
        PreferredLayoutEvent preferredLayoutEvent = new PreferredLayoutEvent(1, this, layout);
        this.firePreferredLayoutEvent(preferredLayoutEvent);
    }

    public void initializeActiveLayout() {
        LayoutData layoutData = (LayoutData)_preferredLayoutMap.get(this.getType());
        if (layoutData != null && !LayoutData.ra$_initialized(layoutData)) {
            PreferredLayoutEvent preferredLayoutEvent = new PreferredLayoutEvent(2, this, null);
            this.firePreferredLayoutEvent(preferredLayoutEvent);
            LayoutData.wa$_initialized(layoutData, true);
        }
    }

    public boolean isReady() {
        return this.owner().isVisible();
    }

    public String getDisplayName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public String getType() {
        if (this._type == null) {
            this._type = this.getClass().getName();
        }
        return this._type;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getPreferredLayoutBaseName() {
        if (this._baseName == null) {
            this._baseName = "Editing";
        }
        return this._baseName;
    }

    public void setPreferredLayoutBaseName(String string) {
        this._baseName = string;
    }

    public void addPreferredLayoutListener(PreferredLayoutListener preferredLayoutListener) {
        this.listenerList.add(PreferredLayoutListener.class, preferredLayoutListener);
    }

    public void removePreferredLayoutListener(PreferredLayoutListener preferredLayoutListener) {
        this.listenerList.remove(PreferredLayoutListener.class, preferredLayoutListener);
    }

    private void firePreferredLayoutEvent(PreferredLayoutEvent preferredLayoutEvent) {
        PreferredLayoutListener[] preferredLayoutListenerArray = (PreferredLayoutListener[])this.listenerList.getListeners(PreferredLayoutListener.class);
        int n = preferredLayoutListenerArray.length - 1;
        while (n >= 0) {
            PreferredLayoutListener preferredLayoutListener = preferredLayoutListenerArray[n];
            switch (preferredLayoutEvent.getEventID()) {
                case 1: {
                    preferredLayoutListener.onInitializeLayout(preferredLayoutEvent);
                    break;
                }
                case 2: {
                    preferredLayoutListener.onPreferredLayoutActivate(preferredLayoutEvent);
                }
            }
            --n;
        }
    }

    protected String newId() {
        return EDITOR_ID + ++COUNTER;
    }

    private static final class LayoutData {
        private final URL _url;
        private boolean _initialized;

        public LayoutData(URL uRL) {
            this._url = uRL;
        }

        static boolean ra$_initialized(LayoutData layoutData) {
            return layoutData._initialized;
        }

        static void wa$_initialized(LayoutData layoutData, boolean bl) {
            layoutData._initialized = bl;
        }

        static URL ra$_url(LayoutData layoutData) {
            return layoutData._url;
        }
    }
}

