/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.awt.Window;
import java.net.URL;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.dialogs.ExceptionDialog;

public final class EditorUtil {
    private EditorUtil() {
    }

    public static Editor openExplicitEditorInFrame(Class clazz, Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        Editor editor = editorManager.openEditorInFrame(clazz, context);
        EditorUtil.setExplicit(editor);
        return editor;
    }

    public static Editor openExplicitDefaultEditorInFrame(Node node) {
        Editor editor = EditorUtil.openDefaultEditorInFrame(node);
        EditorUtil.setExplicit(editor);
        return editor;
    }

    public static void openExplicitDefaultEditorInFrame(URL uRL) {
        Editor editor = EditorUtil.openDefaultEditorInFrame(uRL);
        EditorUtil.setExplicit(editor);
    }

    private static void setExplicit(Editor editor) {
        if (editor != null) {
            EditorManager.getEditorManager().setExplicit(editor, true);
        }
    }

    public static Editor openDefaultEditorInFrameExternal(URL uRL) {
        Node node;
        try {
            node = NodeFactory.findOrCreate(uRL);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)exception);
            Editor editor = null;
            return editor;
        }
        if (!Ide.addToMiscellaneousFolder(node)) {
            return null;
        }
        Context context = Context.newIdeContext(node);
        context.setWorkspace(null);
        context.setProject(null);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(URL uRL) {
        try {
            Node node = NodeFactory.findOrCreate(uRL);
            Editor editor = EditorUtil.openDefaultEditorInFrame(node);
            return editor;
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)exception);
            return null;
        }
    }

    public static Editor openDefaultEditorInFrame(Element element) {
        Context context = Context.newIdeContext(element);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(Node node) {
        Context context = Context.newIdeContext(node);
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Editor openDefaultEditorInFrame(Node node, Context context) {
        Context context2 = EditorUtil.findNodeInContext(node, context);
        if (context2 == null) {
            context2 = context;
        }
        EditorManager editorManager = EditorManager.getEditorManager();
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
        return editorManager.openEditor(openEditorOptions);
    }

    public static Context findNodeInContext(Element element, Context context) {
        Context context2 = new Context(element);
        Project project = context.getProject();
        if (project != null) {
            if (project.containsChild(element)) {
                context2.setProject(project);
                context2.setWorkspace(context.getWorkspace());
                return context2;
            }
            List list = DependencyConfiguration.getInstance(project).getDependencyList();
            if (list != null) {
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    Dependable dependable = (Dependable)list.get(n2);
                    Element element2 = dependable.getSource();
                    if (element2.mayHaveChildren() && element2 instanceof Project && (project = (Project)element2).containsChild(element)) {
                        context2.setProject(project);
                        context2.setWorkspace((Workspace)dependable.getSourceOwner());
                        return context2;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }
}

