/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.editor;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.ModelUtil;

public class RecentFile {
    private URL _workspaceURL;
    private URL _projectURL;
    private URL _nodeURL;
    private String _editor;
    private boolean _explicit;

    public RecentFile() {
    }

    public RecentFile(Context context) {
        this.loadFromContext(context);
    }

    public Context getContext() {
        Context context = null;
        Node node = this._getNode();
        if (node != null) {
            Context context2 = Context.newIdeContext(node);
            Project project = this._getProject();
            context2.setProject(project);
            Workspace workspace = this._getWorkspace();
            context2.setWorkspace(workspace);
            context = context2;
        }
        return context;
    }

    public void setExplicit(boolean bl) {
        this._explicit = bl;
    }

    public boolean isExplicit() {
        return this._explicit;
    }

    public boolean equals(Object object) {
        RecentFile recentFile;
        URL uRL;
        URL uRL2;
        boolean bl = false;
        if (object == this) {
            bl = true;
        } else if (object instanceof RecentFile && RecentFile.areEqual(uRL2 = this.getNodeURL(), uRL = (recentFile = (RecentFile)object).getNodeURL())) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        Node node = this._getNode();
        int n = node != null ? node.hashCode() : super.hashCode();
        return n;
    }

    public boolean isSameNode(Context context) {
        boolean bl = false;
        Node node = context.getNode();
        if (node != null) {
            URL uRL = node.getURL();
            URL uRL2 = this.getNodeURL();
            bl = RecentFile.areEqual(uRL2, uRL);
        }
        return bl;
    }

    private static boolean areEqual(URL uRL, URL uRL2) {
        boolean bl = uRL == null || uRL2 == null ? false : (uRL == uRL2 ? true : ModelUtil.areEqual((Object)uRL.getPath(), (Object)uRL2.getPath()) && ModelUtil.areEqual((Object)uRL.getProtocol(), (Object)uRL2.getProtocol()) && ModelUtil.areEqual((Object)uRL.getUserInfo(), (Object)uRL2.getUserInfo()) && uRL.getPort() == uRL2.getPort() && ModelUtil.areEqual((Object)uRL.getQuery(), (Object)uRL2.getQuery()) && ModelUtil.areEqual((Object)uRL.getRef(), (Object)uRL2.getRef()));
        return bl;
    }

    private void loadFromContext(Context context) {
        Project project = context.getProject();
        Workspace workspace = context.getWorkspace();
        Node node = context.getNode();
        this._setProject(project);
        this._setWorkspace(workspace);
        this._setNode(node);
    }

    private static Node getNode(URL uRL) {
        Node node = null;
        if (uRL != null) {
            try {
                node = NodeFactory.findOrCreate(uRL);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return node;
    }

    private Workspace _getWorkspace() {
        Workspace workspace = null;
        URL uRL = this.getWorkspaceURL();
        Node node = RecentFile.getNode(uRL);
        if (node instanceof Workspace) {
            workspace = (Workspace)node;
        }
        return workspace;
    }

    private void _setWorkspace(Workspace workspace) {
        this._workspaceURL = workspace == null ? null : workspace.getURL();
    }

    private Project _getProject() {
        Project project = null;
        URL uRL = this.getProjectURL();
        Node node = RecentFile.getNode(uRL);
        if (node instanceof Project) {
            project = (Project)node;
        }
        return project;
    }

    private void _setProject(Project project) {
        this._projectURL = project == null ? null : project.getURL();
    }

    private Node _getNode() {
        URL uRL = this.getNodeURL();
        Node node = null;
        try {
            node = RecentFile.getNode(uRL);
        }
        catch (Exception exception) {
            System.err.println("RecentFile._getNode() fails for " + uRL);
        }
        return node;
    }

    private void _setNode(Node node) {
        this._nodeURL = node == null ? null : node.getURL();
    }

    boolean isValid() {
        return this._nodeURL != null;
    }

    public boolean isValidNode() {
        Node node;
        boolean bl = false;
        if (this.isValid() && (node = this._getNode()) != null) {
            bl = true;
        }
        return bl;
    }

    public URL getWorkspaceURL() {
        return this._workspaceURL;
    }

    public void setWorkspaceURL(URL uRL) {
        this._workspaceURL = uRL;
    }

    public URL getProjectURL() {
        return this._projectURL;
    }

    public void setProjectURL(URL uRL) {
        this._projectURL = uRL;
    }

    public URL getNodeURL() {
        return this._nodeURL;
    }

    public void setNodeURL(URL uRL) {
        this._nodeURL = uRL;
    }

    public String getEditor() {
        return this._editor;
    }

    public void setEditor(String string) {
        this._editor = string;
    }
}

