/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.DataContainer;

public final class ExplorerContext {
    private static final String TNODES = "ExplorerContext.TNODES";
    private static final String EXPLORER_TYPE = "ExplorerContext.EXPLORER_TYPE";

    private ExplorerContext() {
    }

    public static TNode[] getTNodes(Context context) {
        TNode[] tNodeArray;
        if (context != null && (tNodeArray = (TNode[])context.getProperty(TNODES)) != null) {
            return tNodeArray;
        }
        return null;
    }

    public static void setTNodes(Context context, TNode[] tNodeArray) {
        if (context != null) {
            context.setProperty(TNODES, tNodeArray);
        }
    }

    public static Class getExplorerType(Context context) {
        if (context != null) {
            return (Class)context.getProperty(EXPLORER_TYPE);
        }
        return null;
    }

    public static void setExplorerType(Context context, Class clazz) {
        if (context != null) {
            context.setProperty(EXPLORER_TYPE, clazz);
        }
    }

    public static TNode getSingleTNode(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        return tNodeArray != null && tNodeArray.length == 1 ? tNodeArray[0] : null;
    }

    public static TNode getFirstTNode(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        return tNodeArray != null && tNodeArray.length > 0 ? tNodeArray[0] : null;
    }

    public static boolean hasNonSiblingTNodes(Context context) {
        TNode[] tNodeArray = ExplorerContext.getTNodes(context);
        if (tNodeArray == null || tNodeArray.length <= 1) {
            return false;
        }
        int n = 0;
        TNode tNode = (TNode)tNodeArray[n++].getParent();
        while (n < tNodeArray.length) {
            if (tNodeArray[n].getParent() != tNode) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static List storeExpansionState(TNode tNode, TreeExplorer treeExplorer) {
        JTree jTree = treeExplorer.getJTree();
        Enumeration<TreePath> enumeration = jTree.getExpandedDescendants(new TreePath(tNode.getPath()));
        TreeSet<TreePath> treeSet = new TreeSet<TreePath>(new TreePathComparator());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath = enumeration.nextElement();
                treeSet.add(treePath);
            }
        }
        Iterator iterator = treeSet.iterator();
        ArrayList<ExpandInfo> arrayList = new ArrayList<ExpandInfo>();
        while (iterator.hasNext()) {
            TreePath treePath = (TreePath)iterator.next();
            String string = ExplorerContext.convertTreePathToString(treePath);
            ExpandInfo expandInfo = new ExpandInfo(string);
            arrayList.add(expandInfo);
            TNode tNode2 = (TNode)treePath.getLastPathComponent();
            if (!(tNode2.getData() instanceof DataContainer)) continue;
            DataContainer dataContainer = (DataContainer)tNode2.getData();
            expandInfo._url = dataContainer.getURL();
        }
        return arrayList;
    }

    public static void restoreExpansionState(TNode tNode, TreeExplorer treeExplorer, List list) {
        ArrayList arrayList = new ArrayList(list.size());
        ExplorerContext.checkExpansionState(tNode, list, 0, arrayList);
        int n = 0;
        while (n < arrayList.size()) {
            TreePath treePath = (TreePath)arrayList.get(n);
            treeExplorer.getJTree().expandPath(treePath);
            ++n;
        }
    }

    private static String convertTreePathToString(TreePath treePath) {
        String string = "";
        Object[] objectArray = treePath.getPath();
        int n = 0;
        while (n < objectArray.length) {
            TNode tNode = (TNode)objectArray[n];
            string = string + tNode.getData().getLongLabel() + ",";
            ++n;
        }
        return string;
    }

    private static void checkExpansionState(TNode tNode, List list, int n, List list2) {
        TreePath treePath = new TreePath(tNode.getPath());
        String string = ExplorerContext.convertTreePathToString(treePath);
        if (!ExplorerContext.wasExpanded(string, list, n)) {
            return;
        }
        tNode.getOwner().open(tNode);
        Enumeration enumeration = tNode.getChildTNodes();
        list2.add(treePath);
        ++n;
        while (enumeration.hasMoreElements()) {
            tNode = (TNode)enumeration.nextElement();
            if (n >= list.size()) continue;
            ExplorerContext.checkExpansionState(tNode, list, n, list2);
        }
    }

    private static boolean wasExpanded(String string, List list, int n) {
        int n2 = n;
        while (n2 < list.size()) {
            ExpandInfo expandInfo = (ExpandInfo)list.get(n2);
            if (string.equals(expandInfo._nodePath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class ExpandInfo {
        public URL _url;
        public String _nodePath;

        public ExpandInfo() {
        }

        public ExpandInfo(String string) {
            this(string, null);
        }

        public ExpandInfo(String string, URL uRL) {
            this._url = uRL;
            this._nodePath = string;
        }
    }

    public static class TreePathComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            if (object == object2) {
                return 0;
            }
            int n2 = ((TreePath)object).getPathCount();
            if (n2 < (n = ((TreePath)object2).getPathCount())) {
                return -1;
            }
            return 1;
        }

        TreePathComparator() {
        }
    }
}

