/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;

public class IconOverlayCache {
    private static IconOverlayCache _instance;
    private final Map _overlayCache;
    private final Map _dirtyOverlayElements;
    private final Set _overlayConsumers;
    private final Collection _consumerChangeListeners;

    void $init$() {
        this._overlayCache = new WeakHashMap();
        this._dirtyOverlayElements = new WeakHashMap();
        this._overlayConsumers = new HashSet();
        this._consumerChangeListeners = new ArrayList();
    }

    public static final IconOverlayCache getInstance() {
        if (_instance == null) {
            _instance = new IconOverlayCache();
        }
        return _instance;
    }

    public void registerOverlayConsumer(IconOverlayConsumer iconOverlayConsumer) {
        this._overlayConsumers.add(iconOverlayConsumer);
        ChangeListener[] changeListenerArray = this._consumerChangeListeners.toArray(new ChangeListener[0]);
        if (changeListenerArray.length <= 0) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        int n = changeListenerArray.length - 1;
        while (n >= 0) {
            changeListenerArray[n].stateChanged(changeEvent);
            --n;
        }
    }

    public void deregisterOverlayConsumer(IconOverlayConsumer iconOverlayConsumer) {
        this._overlayConsumers.remove(iconOverlayConsumer);
        ChangeListener[] changeListenerArray = this._consumerChangeListeners.toArray(new ChangeListener[0]);
        if (changeListenerArray.length <= 0) {
            return;
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        int n = changeListenerArray.length - 1;
        while (n >= 0) {
            changeListenerArray[n].stateChanged(changeEvent);
            --n;
        }
    }

    public synchronized void fireOverlaysChanged() {
        EventQueue.invokeLater(new 1());
    }

    public synchronized void putOverlay(String string, Element element, IconOverlay iconOverlay) {
        OverlayItem overlayItem = (OverlayItem)this._overlayCache.get(element);
        if (overlayItem == null) {
            overlayItem = new OverlayItem(string, iconOverlay, null);
            this._overlayCache.put(element, overlayItem);
        } else {
            OverlayItem.mav$addOverlay(overlayItem, string, iconOverlay);
        }
        this._dirtyOverlayElements.put(element, null);
    }

    public synchronized IconOverlay getOverlay(String string, Element element) {
        OverlayItem overlayItem = (OverlayItem)this._overlayCache.get(element);
        if (overlayItem != null) {
            return OverlayItem.mav$getOverlay(overlayItem, string);
        }
        return null;
    }

    public synchronized void removeOverlay(String string, Element element) {
        OverlayItem overlayItem = (OverlayItem)this._overlayCache.get(element);
        if (overlayItem != null) {
            OverlayItem.mav$removeOverlay(overlayItem, string);
        }
        this._dirtyOverlayElements.put(element, null);
    }

    public synchronized void clearOverlays(String string) {
        Iterator iterator = this._overlayCache.keySet().iterator();
        while (iterator.hasNext()) {
            this.removeOverlay(string, (Element)iterator.next());
        }
    }

    public synchronized Element[] getElementKeys(String string) {
        return this._overlayCache.keySet().toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getRendererIcon(Element element, Icon icon) {
        if (icon == null) {
            return icon;
        }
        OverlayItem overlayItem = this.getOverlayItem(element);
        if (overlayItem == null) {
            return icon;
        }
        OverlayItem overlayItem2 = overlayItem;
        synchronized (overlayItem2) {
            Icon icon2 = OverlayItem.mav$getOverlayIcon(overlayItem, icon);
            return icon2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRendererToolTipText(Element element, String string) {
        OverlayItem overlayItem = this.getOverlayItem(element);
        if (overlayItem == null) {
            return string;
        }
        OverlayItem overlayItem2 = overlayItem;
        synchronized (overlayItem2) {
            if (!OverlayItem.mav$hasOverlay(overlayItem)) {
                String string2 = string;
                return string2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><p>");
            stringBuffer.append(string);
            Iterator iterator = OverlayItem.mav$getOverlays(overlayItem);
            while (iterator.hasNext()) {
                String string3;
                Displayable displayable;
                IconOverlay iconOverlay = (IconOverlay)iterator.next();
                if (iconOverlay == null || (displayable = iconOverlay.getDisplayable()) == null || (string3 = displayable.getToolTipText()) == null) continue;
                stringBuffer.append("<br>");
                stringBuffer.append(string3);
            }
            stringBuffer.append("</p></html>");
            String string4 = stringBuffer.toString();
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRendererShortLabel(Element element, String string) {
        OverlayItem overlayItem = this.getOverlayItem(element);
        if (overlayItem == null) {
            return string;
        }
        OverlayItem overlayItem2 = overlayItem;
        synchronized (overlayItem2) {
            if (!OverlayItem.mav$hasOverlay(overlayItem)) {
                String string2 = string;
                return string2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            Iterator iterator = OverlayItem.mav$getOverlays(overlayItem);
            while (iterator.hasNext()) {
                String string3;
                Displayable displayable;
                IconOverlay iconOverlay = (IconOverlay)iterator.next();
                if (iconOverlay == null || (displayable = iconOverlay.getDisplayable()) == null || (string3 = displayable.getShortLabel()) == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(string3);
            }
            String string4 = stringBuffer.toString();
            return string4;
        }
    }

    void addConsumerChangeListener(ChangeListener changeListener) {
        this._consumerChangeListeners.add(changeListener);
    }

    void removeConsumerChangeListener(ChangeListener changeListener) {
        this._consumerChangeListeners.remove(changeListener);
    }

    Set getOverlayConsumers() {
        return Collections.unmodifiableSet(this._overlayConsumers);
    }

    static final Collection getVisibleNodes(JTree jTree) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Rectangle rectangle = jTree.getVisibleRect();
        int n = jTree.getClosestRowForLocation(rectangle.x, rectangle.y);
        if (n != -1) {
            int n2 = jTree.getClosestRowForLocation(rectangle.x, rectangle.y + rectangle.height);
            if (n2 == -1) {
                n2 = n;
            }
            int n3 = n;
            while (n3 <= n2) {
                TreePath treePath = jTree.getPathForRow(n3);
                if (treePath != null) {
                    arrayList.add(treePath.getLastPathComponent());
                }
                ++n3;
            }
        }
        return arrayList;
    }

    private void fireOverlaysChanged(IconOverlayConsumer iconOverlayConsumer) {
        JTree jTree = iconOverlayConsumer.getJTree();
        if (!(jTree.getModel() instanceof DefaultTreeModel)) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)jTree.getModel();
        for (TreeNode treeNode : IconOverlayCache.getVisibleNodes(jTree)) {
            Element element = iconOverlayConsumer.getElement(treeNode);
            if (element == null || !this._dirtyOverlayElements.containsKey(element)) continue;
            defaultTreeModel.nodeChanged(treeNode);
        }
    }

    private OverlayItem getOverlayItem(Element element) {
        return element != null ? (OverlayItem)this._overlayCache.get(element) : null;
    }

    public IconOverlayCache() {
        this.$init$();
    }

    static Set ra$_overlayConsumers(IconOverlayCache iconOverlayCache) {
        return iconOverlayCache._overlayConsumers;
    }

    static void mav$fireOverlaysChanged(IconOverlayCache iconOverlayCache, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayCache.fireOverlaysChanged(iconOverlayConsumer);
    }

    static Map ra$_dirtyOverlayElements(IconOverlayCache iconOverlayCache) {
        return iconOverlayCache._dirtyOverlayElements;
    }

    public final class 1
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Iterator iterator = IconOverlayCache.ra$_overlayConsumers(IconOverlayCache.this).iterator();
            while (iterator.hasNext()) {
                IconOverlayCache.mav$fireOverlaysChanged(IconOverlayCache.this, (IconOverlayConsumer)iterator.next());
            }
            IconOverlayCache iconOverlayCache = IconOverlayCache.this;
            synchronized (iconOverlayCache) {
                IconOverlayCache.ra$_dirtyOverlayElements(IconOverlayCache.this).clear();
            }
        }
    }

    private static final class OverlayItem {
        private LinkedHashMap _overlays = new LinkedHashMap();
        private Icon _baseIcon;
        private Icon _icon;

        private OverlayItem(String string, IconOverlay iconOverlay) {
            this.addOverlay(string, iconOverlay);
        }

        private synchronized void addOverlay(String string, IconOverlay iconOverlay) {
            if (this._overlays == null) {
                this._overlays = new LinkedHashMap();
            }
            this._overlays.put(string, iconOverlay);
            this._icon = null;
        }

        private synchronized void removeOverlay(String string) {
            if (this._overlays != null) {
                this._overlays.remove(string);
                if (this._overlays.isEmpty()) {
                    this._overlays = null;
                }
            }
            this._icon = null;
        }

        private synchronized Icon getOverlayIcon(Icon icon) {
            if (this._overlays == null || this._overlays.isEmpty()) {
                return icon;
            }
            if (this._icon == null || icon != this._baseIcon) {
                this._baseIcon = icon;
                Icon[] iconArray = new Icon[this._overlays.size() + 1];
                iconArray[0] = icon;
                int n = 1;
                Iterator iterator = this.getOverlays();
                while (iterator.hasNext()) {
                    Displayable displayable;
                    IconOverlay iconOverlay = (IconOverlay)iterator.next();
                    if (iconOverlay == null || (displayable = iconOverlay.getDisplayable()) == null) continue;
                    iconArray[n++] = displayable.getIcon();
                }
                this._icon = new OverlayIcon(iconArray);
            }
            return this._icon;
        }

        private synchronized boolean hasOverlay() {
            return this._overlays != null && this._overlays.size() > 0;
        }

        private synchronized IconOverlay getOverlay(String string) {
            if (this._overlays != null) {
                return (IconOverlay)this._overlays.get(string);
            }
            return null;
        }

        private synchronized Iterator getOverlays() {
            if (this._overlays == null) {
                return Collections.EMPTY_LIST.iterator();
            }
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this._overlays.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(this._overlays.get(iterator.next()));
            }
            return arrayList.iterator();
        }

        static boolean mav$hasOverlay(OverlayItem overlayItem) {
            return overlayItem.hasOverlay();
        }

        static Iterator mav$getOverlays(OverlayItem overlayItem) {
            return overlayItem.getOverlays();
        }

        static Icon mav$getOverlayIcon(OverlayItem overlayItem, Icon icon) {
            return overlayItem.getOverlayIcon(icon);
        }

        static void mav$removeOverlay(OverlayItem overlayItem, String string) {
            overlayItem.removeOverlay(string);
        }

        static IconOverlay mav$getOverlay(OverlayItem overlayItem, String string) {
            return overlayItem.getOverlay(string);
        }

        OverlayItem(String string, IconOverlay iconOverlay, 1 var3_3) {
            this(string, iconOverlay);
        }

        static void mav$addOverlay(OverlayItem overlayItem, String string, IconOverlay iconOverlay) {
            overlayItem.addOverlay(string, iconOverlay);
        }

        public final class 1 {
        }
    }
}

