/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Element;
import oracle.javatools.util.NamedTimer;

public abstract class IconOverlayTracker {
    private static final long THREAD_DELAY_TIME = 500L;
    private final int _overlayBatchSize;
    private final Map _nodeWatchers;
    private final Map _pendingNodes;
    private final Map _validOverlayElements;
    private final Object _timerLock;
    private Timer _timer;
    private TimerTask _updateTask;
    private IconOverlayCache _overlayCache;
    private ChangeListener _consumerChangeListener;
    private boolean _started;
    private boolean _exited;
    private IdeAdapter _ideListener;
    private final String _infoTypeId;
    private final ChangeListener _viewChangeListener;

    void $init$() {
        this._nodeWatchers = new HashMap();
        this._pendingNodes = new HashMap();
        this._validOverlayElements = new WeakHashMap();
        this._timerLock = new Object();
        this._viewChangeListener = new 6();
    }

    public IconOverlayTracker(String string, IconOverlayCache iconOverlayCache) {
        this(string, iconOverlayCache, 10);
    }

    public IconOverlayTracker(String string, IconOverlayCache iconOverlayCache, int n) {
        this.$init$();
        this._infoTypeId = string;
        this._overlayCache = iconOverlayCache;
        this._overlayBatchSize = n;
        this._consumerChangeListener = new 5();
        this._overlayCache.addConsumerChangeListener(this._consumerChangeListener);
        Iterator iterator = this._overlayCache.getOverlayConsumers().iterator();
        while (iterator.hasNext()) {
            this.registerOverlayConsumer((IconOverlayConsumer)iterator.next());
        }
    }

    public IconOverlayCache getOverlayCache() {
        return this._overlayCache;
    }

    protected abstract boolean isControlled(Element var1);

    protected abstract IconOverlay[] getOverlays(Element[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element[] getValidElements() {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        linkedHashSet.addAll(Arrays.asList(this._overlayCache.getElementKeys(this._infoTypeId)));
        Map map = this._validOverlayElements;
        synchronized (map) {
            linkedHashSet.addAll(this._validOverlayElements.keySet());
        }
        return linkedHashSet.toArray(new Element[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOverlayConsumer(IconOverlayConsumer iconOverlayConsumer) {
        this.startTracking();
        Map map = this._nodeWatchers;
        synchronized (map) {
            if (this._nodeWatchers.containsKey(iconOverlayConsumer)) {
                return;
            }
            NodeWatcher nodeWatcher = new NodeWatcher(iconOverlayConsumer, null);
            NodeWatcher.mav$addVisibleNodeListener(nodeWatcher, this._viewChangeListener);
            this._nodeWatchers.put(iconOverlayConsumer, nodeWatcher);
        }
        Map map2 = this._pendingNodes;
        synchronized (map2) {
            this._pendingNodes.put(iconOverlayConsumer, null);
        }
        this.repaintConsumerOverlays(iconOverlayConsumer, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterOverlayConsumer(IconOverlayConsumer iconOverlayConsumer) {
        this.startTracking();
        Map map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(iconOverlayConsumer)) {
                return;
            }
            NodeWatcher nodeWatcher = (NodeWatcher)this._nodeWatchers.get(iconOverlayConsumer);
            NodeWatcher.mav$removeVisibleNodeListener(nodeWatcher, this._viewChangeListener);
            this._nodeWatchers.remove(iconOverlayConsumer);
            NodeWatcher.mav$performCleanup(nodeWatcher);
        }
        Map map2 = this._pendingNodes;
        synchronized (map2) {
            this._pendingNodes.remove(iconOverlayConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateOverlay(Element element) {
        this.startTracking();
        Map map = this._validOverlayElements;
        synchronized (map) {
            if (this.isControlled(element)) {
                this._validOverlayElements.remove(element);
            }
        }
    }

    public void validateOverlays() {
        Element[] elementArray = this._overlayCache.getElementKeys(this._infoTypeId);
        int n = 0;
        while (n < elementArray.length) {
            this.validateOverlay(elementArray[n]);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintOverlays() {
        HashSet hashSet;
        this.startTracking();
        Map map = this._nodeWatchers;
        synchronized (map) {
            hashSet = new HashSet(this._nodeWatchers.keySet());
        }
        this.repaintConsumerOverlays(hashSet, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking() {
        if (!this._started) {
            return;
        }
        Ide.removeIdeListener(this._ideListener);
        this._overlayCache.removeConsumerChangeListener(this._consumerChangeListener);
        this._ideListener = null;
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            this._exited = true;
        }
        4 var1_2 = new 4();
        Object object2 = this._timerLock;
        synchronized (object2) {
            this.getTimer().schedule((TimerTask)var1_2, 0L);
        }
    }

    private void startTracking() {
        if (this._started) {
            return;
        }
        this._started = true;
        this._ideListener = new 3();
        Ide.addIdeListener(this._ideListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(Collection collection, long l) {
        Map map = this._pendingNodes;
        synchronized (map) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.repaintConsumerOverlaysImpl((IconOverlayConsumer)iterator.next());
            }
        }
        this.scheduleUpdateTask(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repaintConsumerOverlays(IconOverlayConsumer iconOverlayConsumer, long l) {
        Map map = this._pendingNodes;
        synchronized (map) {
            this.repaintConsumerOverlaysImpl(iconOverlayConsumer);
        }
        this.scheduleUpdateTask(l);
    }

    private void repaintConsumerOverlaysImpl(IconOverlayConsumer iconOverlayConsumer) {
        if (!this._pendingNodes.containsKey(iconOverlayConsumer)) {
            return;
        }
        this._pendingNodes.put(iconOverlayConsumer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdateTask(long l) {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._exited) {
                return;
            }
            if (this._updateTask != null) {
                this._updateTask.cancel();
            }
            this._updateTask = new 2();
            try {
                this.getTimer().schedule(this._updateTask, l);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer getTimer() {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timer == null) {
                this._timer = new NamedTimer("IconOverlayTracker Timer");
            }
        }
        return this._timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingNodes() {
        Collection collection;
        while ((collection = this.getPendingNodeBatch()) != null) {
            Map map = this._validOverlayElements;
            synchronized (map) {
                for (Element element : collection) {
                    this._validOverlayElements.put(element, null);
                }
            }
            List<IconOverlay> list = Arrays.asList(this.getOverlays(collection.toArray(new Element[0])));
            EventQueue.invokeLater(new 1(this, collection, list));
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPendingNodeBatch() {
        IconOverlayConsumer iconOverlayConsumer;
        while ((iconOverlayConsumer = this.findPendingConsumer()) != null) {
            Map map = this._pendingNodes;
            synchronized (map) {
                List list = (List)this._pendingNodes.get(iconOverlayConsumer);
                if (list != null) {
                    int n = Math.min(list.size(), this._overlayBatchSize);
                    ArrayList arrayList = new ArrayList(n);
                    int n2 = 0;
                    while (n2 < n) {
                        arrayList.add(list.remove(0));
                        ++n2;
                    }
                    ArrayList arrayList2 = arrayList;
                    return arrayList2;
                }
            }
            this.updateQueue(iconOverlayConsumer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IconOverlayConsumer findPendingConsumer() {
        Map map = this._pendingNodes;
        synchronized (map) {
            for (Object k : this._pendingNodes.keySet()) {
                List list = (List)this._pendingNodes.get(k);
                if (list != null && list.size() <= 0) continue;
                IconOverlayConsumer iconOverlayConsumer = (IconOverlayConsumer)k;
                return iconOverlayConsumer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateQueue(IconOverlayConsumer iconOverlayConsumer) {
        Collection collection;
        Map map = this._nodeWatchers;
        synchronized (map) {
            if (!this._nodeWatchers.containsKey(iconOverlayConsumer)) {
                return;
            }
            NodeWatcher nodeWatcher = (NodeWatcher)this._nodeWatchers.get(iconOverlayConsumer);
            collection = NodeWatcher.mav$getVisibleNodes(nodeWatcher);
        }
        LinkedList<Element> linkedList = new LinkedList<Element>();
        Map map2 = this._validOverlayElements;
        synchronized (map2) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Element element = iconOverlayConsumer.getElement(iterator.next());
                if (element == null || !this.isControlled(element) || this._validOverlayElements.containsKey(element)) continue;
                linkedList.add(element);
            }
        }
        Map map3 = this._pendingNodes;
        synchronized (map3) {
            if (!this._pendingNodes.containsKey(iconOverlayConsumer)) {
                return;
            }
            this._pendingNodes.put(iconOverlayConsumer, linkedList);
        }
    }

    static void mav$repaintConsumerOverlays(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer, long l) {
        iconOverlayTracker.repaintConsumerOverlays(iconOverlayConsumer, l);
    }

    static Map ra$_nodeWatchers(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._nodeWatchers;
    }

    static IconOverlayCache ra$_overlayCache(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._overlayCache;
    }

    static void mav$registerOverlayConsumer(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayTracker.registerOverlayConsumer(iconOverlayConsumer);
    }

    static void mav$deregisterOverlayConsumer(IconOverlayTracker iconOverlayTracker, IconOverlayConsumer iconOverlayConsumer) {
        iconOverlayTracker.deregisterOverlayConsumer(iconOverlayConsumer);
    }

    static ChangeListener ra$_viewChangeListener(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._viewChangeListener;
    }

    static Object ra$_timerLock(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._timerLock;
    }

    static Timer mav$getTimer(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker.getTimer();
    }

    static String ra$_infoTypeId(IconOverlayTracker iconOverlayTracker) {
        return iconOverlayTracker._infoTypeId;
    }

    static void mav$processPendingNodes(IconOverlayTracker iconOverlayTracker) {
        iconOverlayTracker.processPendingNodes();
    }

    public final class 6
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            IconOverlayTracker.mav$repaintConsumerOverlays(IconOverlayTracker.this, (IconOverlayConsumer)changeEvent.getSource(), 500L);
        }
    }

    public final class 5
    implements ChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stateChanged(ChangeEvent changeEvent) {
            Map map = IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this);
            synchronized (map) {
                HashSet<Object> hashSet = new HashSet(IconOverlayTracker.ra$_overlayCache(IconOverlayTracker.this).getOverlayConsumers());
                hashSet.removeAll(IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).keySet());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    IconOverlayTracker.mav$registerOverlayConsumer(IconOverlayTracker.this, (IconOverlayConsumer)iterator.next());
                }
                hashSet = new HashSet(IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).keySet());
                hashSet.removeAll(IconOverlayTracker.ra$_overlayCache(IconOverlayTracker.this).getOverlayConsumers());
                Iterator iterator2 = hashSet.iterator();
                while (iterator2.hasNext()) {
                    IconOverlayTracker.mav$deregisterOverlayConsumer(IconOverlayTracker.this, (IconOverlayConsumer)iterator2.next());
                }
            }
        }
    }

    public final class 4
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this);
            synchronized (map) {
                for (NodeWatcher nodeWatcher : IconOverlayTracker.ra$_nodeWatchers(IconOverlayTracker.this).values()) {
                    NodeWatcher.mav$removeVisibleNodeListener(nodeWatcher, IconOverlayTracker.ra$_viewChangeListener(IconOverlayTracker.this));
                    NodeWatcher.mav$performCleanup(nodeWatcher);
                }
            }
            Object object = IconOverlayTracker.ra$_timerLock(IconOverlayTracker.this);
            synchronized (object) {
                IconOverlayTracker.mav$getTimer(IconOverlayTracker.this).cancel();
            }
            this.timerStopped();
        }

        private void timerStopped() {
            IconOverlayTracker.this.validateOverlays();
            EventQueue.invokeLater(new 1());
        }

        public final class 1
        implements Runnable {
            public final void run() {
                IconOverlayCache iconOverlayCache = IconOverlayTracker.this.getOverlayCache();
                if (iconOverlayCache == null) {
                    return;
                }
                iconOverlayCache.clearOverlays(IconOverlayTracker.ra$_infoTypeId(IconOverlayTracker.this));
                iconOverlayCache.fireOverlaysChanged();
            }
        }
    }

    public final class 3
    extends IdeAdapter {
        public void mainWindowClosing(IdeEvent ideEvent) {
            IconOverlayTracker.this.stopTracking();
            Ide.removeIdeListener(this);
        }
    }

    public final class 2
    extends TimerTask {
        public void run() {
            try {
                IconOverlayTracker.mav$processPendingNodes(IconOverlayTracker.this);
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Collection v$nodes;
        private final /* synthetic */ Collection v$overlays;
        final /* synthetic */ IconOverlayTracker this$0;

        public final void run() {
            IconOverlayCache iconOverlayCache = this.this$0.getOverlayCache();
            if (iconOverlayCache == null) {
                return;
            }
            Iterator iterator = this.v$nodes.iterator();
            Iterator iterator2 = this.v$overlays.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                IconOverlay iconOverlay = (IconOverlay)iterator2.next();
                if (element == null) continue;
                if (iconOverlay == null) {
                    iconOverlayCache.removeOverlay(IconOverlayTracker.ra$_infoTypeId(this.this$0), element);
                    continue;
                }
                iconOverlayCache.putOverlay(IconOverlayTracker.ra$_infoTypeId(this.this$0), element, iconOverlay);
            }
            iconOverlayCache.fireOverlaysChanged();
        }

        public 1(IconOverlayTracker iconOverlayTracker, Collection collection, Collection collection2) {
            this.v$overlays = collection2;
            this.v$nodes = collection;
            this.this$0 = iconOverlayTracker;
        }
    }

    private final class NodeWatcher {
        private final JTree _tree;
        private final Object _source;
        private final ChangeListener _scrollListener;
        private final TreeModelListener _modelListener;
        private final TreeExpansionListener _nodeListener;
        private final ParentListener _parentListener;
        private Collection _nodes;
        private Collection _listeners;
        private boolean _cleanup;

        void $init$() {
            this._scrollListener = new ScrollPaneListener(null);
            this._modelListener = new NodeModelListener(null);
            this._nodeListener = new NodeUserListener(null);
            this._parentListener = new ParentListener(null);
            this._nodes = new ArrayList();
            this._listeners = new ArrayList();
        }

        private NodeWatcher(IconOverlayConsumer iconOverlayConsumer) {
            this.$init$();
            this._tree = iconOverlayConsumer.getJTree();
            this._source = iconOverlayConsumer;
            this._tree.addAncestorListener(this._parentListener);
            if (this.isComponentVisible(this._tree)) {
                EventQueue.invokeLater(new 3());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addVisibleNodeListener(ChangeListener changeListener) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(changeListener);
                this._listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeVisibleNodeListener(ChangeListener changeListener) {
            Collection collection = this._listeners;
            synchronized (collection) {
                this._listeners.remove(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection getVisibleNodes() {
            Collection collection = this._nodes;
            synchronized (collection) {
                ArrayList arrayList = new ArrayList(this._nodes);
                return arrayList;
            }
        }

        private void performCleanup() {
            this._cleanup = true;
            EventQueue.invokeLater(new 2());
        }

        private final void updateVisibleNodes() {
            EventQueue.invokeLater(new 1());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void setVisibleNodes(Collection collection) {
            Collection collection2 = this._nodes;
            synchronized (collection2) {
                boolean bl = Arrays.equals(this._nodes.toArray(), collection.toArray()) ^ true;
                this._nodes = collection;
                if (!bl) {
                    return;
                }
            }
            ChangeEvent changeEvent = new ChangeEvent(this._source);
            ChangeListener[] changeListenerArray = null;
            Collection collection3 = this._listeners;
            synchronized (collection3) {
                changeListenerArray = this._listeners.toArray(new ChangeListener[0]);
            }
            int n = changeListenerArray.length - 1;
            while (n >= 0) {
                changeListenerArray[n].stateChanged(changeEvent);
                --n;
            }
        }

        private final void addInternalListeners() {
            if (this._cleanup) {
                return;
            }
            this.removeInternalListenersImpl();
            this.addInternalListenersImpl();
            this.updateVisibleNodes();
        }

        private final void removeInternalListeners() {
            this.removeInternalListenersImpl();
            this.setVisibleNodes(new ArrayList());
        }

        private final void addInternalListenersImpl() {
            this._tree.getModel().addTreeModelListener(this._modelListener);
            this._tree.addTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this._tree.getParent();
            jViewport.addChangeListener(this._scrollListener);
        }

        private final void removeInternalListenersImpl() {
            this._tree.getModel().removeTreeModelListener(this._modelListener);
            this._tree.removeTreeExpansionListener(this._nodeListener);
            if (!(this._tree.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this._tree.getParent();
            jViewport.removeChangeListener(this._scrollListener);
        }

        private final JTree getTree() {
            return this._tree;
        }

        private final boolean isComponentVisible(Component component) {
            while (component != null) {
                if (!component.isVisible()) {
                    return false;
                }
                if (component instanceof Window) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }

        static Collection mav$getVisibleNodes(NodeWatcher nodeWatcher) {
            return nodeWatcher.getVisibleNodes();
        }

        static void mav$removeVisibleNodeListener(NodeWatcher nodeWatcher, ChangeListener changeListener) {
            nodeWatcher.removeVisibleNodeListener(changeListener);
        }

        static void mav$performCleanup(NodeWatcher nodeWatcher) {
            nodeWatcher.performCleanup();
        }

        NodeWatcher(IconOverlayConsumer iconOverlayConsumer, 1 var3_3) {
            this(iconOverlayConsumer);
        }

        static void mav$addVisibleNodeListener(NodeWatcher nodeWatcher, ChangeListener changeListener) {
            nodeWatcher.addVisibleNodeListener(changeListener);
        }

        static void mav$addInternalListeners(NodeWatcher nodeWatcher) {
            nodeWatcher.addInternalListeners();
        }

        static JTree ra$_tree(NodeWatcher nodeWatcher) {
            return nodeWatcher._tree;
        }

        static ParentListener ra$_parentListener(NodeWatcher nodeWatcher) {
            return nodeWatcher._parentListener;
        }

        static void mav$removeInternalListeners(NodeWatcher nodeWatcher) {
            nodeWatcher.removeInternalListeners();
        }

        static void mav$setVisibleNodes(NodeWatcher nodeWatcher, Collection collection) {
            nodeWatcher.setVisibleNodes(collection);
        }

        static JTree mav$getTree(NodeWatcher nodeWatcher) {
            return nodeWatcher.getTree();
        }

        static void mav$updateVisibleNodes(NodeWatcher nodeWatcher) {
            nodeWatcher.updateVisibleNodes();
        }

        public final class 3
        implements Runnable {
            public final void run() {
                NodeWatcher.mav$addInternalListeners(NodeWatcher.this);
            }
        }

        public final class 2
        implements Runnable {
            public final void run() {
                NodeWatcher.ra$_tree(NodeWatcher.this).removeAncestorListener(NodeWatcher.ra$_parentListener(NodeWatcher.this));
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
            }
        }

        public final class 1
        implements Runnable {
            public final void run() {
                NodeWatcher.mav$setVisibleNodes(NodeWatcher.this, IconOverlayCache.getVisibleNodes(NodeWatcher.ra$_tree(NodeWatcher.this)));
            }
        }

        private final class ParentListener
        implements AncestorListener {
            public final void ancestorAdded(AncestorEvent ancestorEvent) {
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
                NodeWatcher.mav$addInternalListeners(NodeWatcher.this);
            }

            public final void ancestorMoved(AncestorEvent ancestorEvent) {
            }

            public final void ancestorRemoved(AncestorEvent ancestorEvent) {
                NodeWatcher.mav$removeInternalListeners(NodeWatcher.this);
            }

            private ParentListener() {
            }

            ParentListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class ScrollPaneListener
        implements ChangeListener {
            private Rectangle _r;

            void $init$() {
                this._r = null;
            }

            public final void stateChanged(ChangeEvent changeEvent) {
                Rectangle rectangle = NodeWatcher.mav$getTree(NodeWatcher.this).getVisibleRect();
                if (this._r != null && rectangle.equals(this._r)) {
                    return;
                }
                this._r = rectangle;
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private ScrollPaneListener() {
                this.$init$();
            }

            ScrollPaneListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class NodeModelListener
        implements TreeModelListener {
            public final void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public final void treeNodesInserted(TreeModelEvent treeModelEvent) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeStructureChanged(TreeModelEvent treeModelEvent) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private NodeModelListener() {
            }

            NodeModelListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        private final class NodeUserListener
        implements TreeExpansionListener {
            public final void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            public final void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                NodeWatcher.mav$updateVisibleNodes(NodeWatcher.this);
            }

            private NodeUserListener() {
            }

            NodeUserListener(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }
    }
}

