/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayConsumer;
import oracle.ide.model.Element;

public class IconOverlayTreeCellRenderer
implements TreeCellRenderer {
    private final IconOverlayConsumer _overlayConsumer;
    private final DefaultTreeCellRenderer _renderer;

    public IconOverlayTreeCellRenderer(IconOverlayConsumer iconOverlayConsumer, DefaultTreeCellRenderer defaultTreeCellRenderer) {
        this._overlayConsumer = iconOverlayConsumer;
        this._renderer = defaultTreeCellRenderer;
    }

    public IconOverlayConsumer getOverlayConsumer() {
        return this._overlayConsumer;
    }

    public DefaultTreeCellRenderer getCellRenderer() {
        return this._renderer;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this._renderer.setText("");
        this._renderer.setToolTipText("");
        this._renderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        IconOverlayCache iconOverlayCache = this._overlayConsumer.getOverlayCache();
        if (iconOverlayCache == null) {
            return this._renderer;
        }
        Element element = this._overlayConsumer.getElement(object);
        if (element == null) {
            return this._renderer;
        }
        Icon icon = this._renderer.getIcon();
        if (icon == null) {
            icon = bl3 ? this._renderer.getLeafIcon() : (bl2 ? this._renderer.getOpenIcon() : this._renderer.getClosedIcon());
        }
        this._renderer.setIcon(iconOverlayCache.getRendererIcon(element, icon));
        String string = this._renderer.getText();
        this._renderer.setText(iconOverlayCache.getRendererShortLabel(element, string));
        String string2 = this._renderer.getToolTipText();
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        this._renderer.setToolTipText(iconOverlayCache.getRendererToolTipText(element, string2));
        return this._renderer;
    }
}

