/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.ExtensionHook;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;

public class HashStructureHook
extends ExtensionHook {
    private final HashStructure _hash;
    private final V _visitor;
    private static final String TEXT_KEY = "#text";

    void $init$() {
        this._hash = HashStructure.newInstance();
        this._visitor = new V(this._hash, null);
    }

    public void start(ElementStartContext elementStartContext) {
        this._visitor.start(elementStartContext);
        elementStartContext.registerVisitorFactory((ElementVisitorFactory)this._visitor);
    }

    public void end(ElementEndContext elementEndContext) {
        this._visitor.end(elementEndContext);
    }

    public final HashStructure getHashStructure() {
        return this._hash;
    }

    public HashStructureHook() {
        this.$init$();
    }

    private final class V
    extends ElementVisitor
    implements ElementVisitorFactory {
        private final LinkedList _stack;
        private HashStructure _parent;
        private URI _currentSourceURI;

        void $init$() {
            this._stack = new LinkedList();
            this._currentSourceURI = null;
        }

        private V(HashStructure hashStructure) {
            this.$init$();
            this._parent = hashStructure;
        }

        public ElementVisitor getVisitor(ElementName elementName) {
            return this;
        }

        public void start(ElementStartContext elementStartContext) {
            URI uRI = elementStartContext.getExtensionSourceURI();
            if (!uRI.equals(this._currentSourceURI)) {
                this._stack.clear();
                this._currentSourceURI = uRI;
            }
            HashStructure hashStructure = this._stack.isEmpty() ? this._parent : HashStructure.newInstance();
            Collection collection = elementStartContext.getAttributeNames();
            if (collection != null) {
                for (String string : collection) {
                    String string2 = elementStartContext.getAttributeValue(string);
                    if (string2 == null) continue;
                    String string3 = string2.trim();
                    if (string3.startsWith("uri:")) {
                        String string4 = string3.substring(4);
                        URI uRI2 = URIFactory.newURI((String)string4);
                        if (uRI2 == null) continue;
                        try {
                            URL uRL = VirtualFileSystem.getVirtualFileSystem().toURL(uRI2);
                            hashStructure.putURL(string, uRL);
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.log((ElementContext)elementStartContext, Level.WARNING, "Malformed URL exception for attribute '" + string + "' using path='" + string4 + "'.");
                        }
                        continue;
                    }
                    hashStructure.putString(string, string3);
                }
            }
            if (!this._stack.isEmpty()) {
                ElementName elementName = elementStartContext.getElementName();
                String string = elementName.getLocalName();
                if (this._parent.containsKey(string)) {
                    Object object = this._parent.getObject(string);
                    if (object instanceof ListStructure) {
                        ListStructure listStructure = (ListStructure)object;
                        listStructure.add((Object)hashStructure);
                    } else {
                        ListStructure listStructure = ListStructure.newInstance();
                        listStructure.add(object);
                        listStructure.add((Object)hashStructure);
                        this._parent.putListStructure(string, listStructure);
                    }
                } else {
                    this._parent.putHashStructure(string, hashStructure);
                }
            }
            this._stack.addLast(this._parent);
            this._parent = hashStructure;
        }

        public void end(ElementEndContext elementEndContext) {
            String string;
            String string2 = elementEndContext.getText();
            if (string2 != null && string2.length() > 0 && !this._parent.containsKey(HashStructureHook.TEXT_KEY) && (string = string2.trim()).length() > 0) {
                this._parent.putString(HashStructureHook.TEXT_KEY, string);
            }
            this._parent = (HashStructure)this._stack.removeLast();
        }

        V(HashStructure hashStructure, 1 var3_3) {
            this(hashStructure);
        }

        public final class 1 {
        }
    }
}

