/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.JARExtensionSource;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;

public abstract class URLPathHandler
extends ElementVisitor {
    private static String DIRPATH = "Library-dirpath";

    public void start(ElementStartContext elementStartContext) {
        try {
            JARExtensionSource jARExtensionSource = (JARExtensionSource)elementStartContext.getScopeData().get("extSource");
            elementStartContext.getScopeData().put(DIRPATH, this.getDirPath(jARExtensionSource.getURI().toURL()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected URL getDirPath(URL uRL) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = uRL;
        if (JarUtil.isJarURL(uRL)) {
            uRL2 = JarUtil.getJarFileURL(uRL);
        }
        return URLFileSystem.isDirectory(uRL2) ? uRL2 : URLFileSystem.getParent(uRL2);
    }

    protected URL getDirPath(ElementContext elementContext) {
        return (URL)elementContext.getScopeData().get(DIRPATH);
    }

    protected void getURLPaths(URLPath uRLPath, String string, URL uRL) {
        string.trim();
        if (string.startsWith("http") || string.startsWith("https")) {
            uRLPath.add(URLFactory.newURL(string));
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = string2 = stringTokenizer.nextToken().trim();
                String string4 = null;
                String string5 = "!" + File.separator;
                int n = string2.indexOf(string5);
                if (n > 0) {
                    string3 = string2.substring(0, n);
                    string4 = string2.substring(n + string5.length());
                    if (File.separatorChar != '/') {
                        string4 = string4.replace(File.separatorChar, '/');
                    }
                } else {
                    String string6;
                    n = string2.lastIndexOf(46);
                    if (n >= 0 && ("zip".equals(string6 = string2.substring(n + 1).toLowerCase()) || "jar".equals(string6))) {
                        string4 = "";
                    }
                }
                URL uRL2 = this.relativePath(string3) ? URLFactory.newURL(uRL, string3) : URLFactory.newURL(string3);
                uRL2 = string4 != null ? URLFactory.newJarURL(uRL2, string4) : URLFactory.newURL(uRL2, "");
                uRLPath.add(uRL2);
            }
        }
    }

    private boolean relativePath(String string) {
        return !string.startsWith("/") && string.length() > 2 && string.charAt(1) != ':';
    }
}

