/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback;

import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.feedback.NullFeedbackManager;
import oracle.ide.feedback.shared.Feedback;
import oracle.javatools.jndi.Names;

public abstract class FeedbackManager {
    private static final String FEEDBACK_MANAGER_NAME = "ide/feedback-manager";
    private static FeedbackManager _nullManager;

    public abstract void addActionPerformedFeedback(IdeAction var1, Context var2);

    public abstract void addFeedback(String var1, Context var2);

    public abstract void addFeedback(Feedback var1);

    public abstract void reportException(String var1, Throwable var2);

    public abstract boolean isOn();

    public static FeedbackManager getFeedbackManager() {
        FeedbackManager feedbackManager = (FeedbackManager)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME);
        if (feedbackManager == null) {
            return FeedbackManager.getNullFeedbackManager();
        }
        return feedbackManager;
    }

    private static FeedbackManager getNullFeedbackManager() {
        if (_nullManager == null) {
            _nullManager = new NullFeedbackManager();
        }
        return _nullManager;
    }

    public static void setFeedbackManager(FeedbackManager feedbackManager) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)FEEDBACK_MANAGER_NAME, (Object)feedbackManager);
    }

    protected final void writeFeedback(DataOutputStream dataOutputStream, Feedback feedback) throws IOException {
        feedback.write(dataOutputStream);
    }
}

