/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.feedback.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Feedback {
    private long _timestamp = System.currentTimeMillis();

    protected abstract void writeImpl(DataOutputStream var1) throws IOException;

    protected abstract void readImpl(DataInputStream var1) throws IOException;

    protected abstract void dumpImpl(PrintStream var1);

    protected Feedback() {
    }

    public final void write(DataOutputStream dataOutputStream) throws IOException {
        Class<?> clazz = this.getClass();
        String string = clazz.getName();
        dataOutputStream.writeUTF(string);
        dataOutputStream.writeLong(this._timestamp);
        this.writeImpl(dataOutputStream);
    }

    public static final Feedback read(ClassLoader classLoader, DataInputStream dataInputStream) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        String string = dataInputStream.readUTF();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            Feedback feedback = (Feedback)clazz.newInstance();
            feedback._timestamp = dataInputStream.readLong();
            feedback.readImpl(dataInputStream);
            Feedback feedback2 = feedback;
            return feedback2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Failed to load " + string);
            classNotFoundException.printStackTrace();
            throw classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Failed to load " + string);
            instantiationException.printStackTrace();
            throw instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Failed to load " + string);
            illegalAccessException.printStackTrace();
            throw illegalAccessException;
        }
        catch (IOException iOException) {
            System.err.println("Failed to load " + string);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public final void dump(PrintStream printStream) {
        this.dumpImpl(printStream);
    }
}

