/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryXMLDataNode;
import oracle.ide.gallery.RootGalleryFolder;

public final class GalleryAddinUtil {
    private GalleryAddinUtil() {
    }

    public static void usage() {
        System.out.println("GalleryAddinUtil loader version 9i");
        System.out.println("Usage:  GalleryAddinUtil <gallery.xml> <gallery entry properties file>");
        System.out.println("");
        System.exit(0);
    }

    public static void legacyLoadGalleryItems(URL uRL, URL uRL2) {
        GalleryAddinUtil.loadGalleryItems(uRL, uRL2, "NumItems", "Item");
    }

    public static void loadGalleryItems(URL uRL, URL uRL2) {
        GalleryAddinUtil.loadGalleryItems(uRL, uRL2, "NumItems.Add", "Add.Item");
    }

    private static void loadGalleryItems(URL uRL, URL uRL2, String string, String string2) {
        try {
            Properties properties = new Properties();
            properties.load(uRL2.openStream());
            GalleryXMLDataNode galleryXMLDataNode = new GalleryXMLDataNode(uRL);
            RootGalleryFolder rootGalleryFolder = (RootGalleryFolder)galleryXMLDataNode.getData();
            String string3 = properties.getProperty(string);
            if (string3 == null) {
                return;
            }
            int n = Integer.parseInt(string3.toString().trim());
            int n2 = 0;
            while (n2 < n) {
                String string4 = properties.getProperty(string2 + n2 + ".category");
                String string5 = properties.getProperty(string2 + n2 + ".folder");
                String string6 = properties.getProperty(string2 + n2 + ".class");
                String string7 = properties.getProperty(string2 + n2 + ".name");
                String string8 = properties.getProperty(string2 + n2 + ".description");
                String string9 = properties.getProperty(string2 + n2 + ".resclass");
                String string10 = properties.getProperty(string2 + n2 + ".unsorted");
                String string11 = properties.getProperty(string2 + n2 + ".iconFile");
                boolean bl = string10 != null ? Boolean.valueOf(string10) : false;
                String[] stringArray = GalleryAddinUtil.getPropertyArray(properties, string2 + n2, ".numParams", ".param");
                String[] stringArray2 = GalleryAddinUtil.getPropertyArray(properties, string2 + n2, ".numTechnologyKeys", ".technologyKey");
                if (string5 == null || string5.trim().length() == 0) {
                    System.out.println("WARNING: property " + string2 + n2 + ".folder not specified");
                } else {
                    ElementInfo elementInfo = new ElementInfo(string4, string5, string6, stringArray, string7, string8, string11, bl);
                    if (string9 != null && string9.length() != 0) {
                        elementInfo.setResClass(string9);
                    }
                    elementInfo.setTechnologyKeys(stringArray2);
                    GalleryFolder galleryFolder = rootGalleryFolder.createFolder(elementInfo.getPath());
                    GalleryElement galleryElement = elementInfo.createElement();
                    galleryFolder.add(galleryElement);
                }
                ++n2;
            }
            galleryXMLDataNode.markDirty(true);
            galleryXMLDataNode.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void removeGalleryItems(URL uRL, URL uRL2) {
        try {
            Properties properties = new Properties();
            properties.load(uRL2.openStream());
            GalleryXMLDataNode galleryXMLDataNode = new GalleryXMLDataNode(uRL);
            RootGalleryFolder rootGalleryFolder = (RootGalleryFolder)galleryXMLDataNode.getData();
            String string = properties.getProperty("NumItems.Remove");
            if (string == null) {
                return;
            }
            int n = Integer.parseInt(string.toString().trim());
            int n2 = 0;
            while (n2 < n) {
                String string2 = properties.getProperty("Remove.Item" + n2 + ".category");
                String string3 = properties.getProperty("Remove.Item" + n2 + ".folder");
                if (string3 != null) {
                    String string4 = properties.getProperty("Remove.Item" + n2 + ".name");
                    String string5 = properties.getProperty("Remove.Item" + n2 + ".class");
                    ElementInfo elementInfo = new ElementInfo(string2, string3, string5, null, string4);
                    GalleryFolder galleryFolder = rootGalleryFolder.getFolder(elementInfo.getPath());
                    if (string4 == null && string5 == null) {
                        if (galleryFolder.size() <= 0) {
                            rootGalleryFolder.remove(galleryFolder);
                        } else {
                            System.out.println("WARNING: NOT removing folder [" + string3 + "] since it is not empty.");
                        }
                    } else if (galleryFolder == null) {
                        System.out.println("WARNING: Could not find folder named: " + string3);
                    } else {
                        GalleryElement galleryElement = galleryFolder.getGalleryElement(string4);
                        if (galleryElement == null) {
                            System.out.println("WARNING: Could not find element: " + string4);
                        } else if (string5 == null || galleryElement.getWizardClass().equals(string5)) {
                            galleryFolder.remove(galleryElement);
                        }
                    }
                }
                ++n2;
            }
            galleryXMLDataNode.markDirty(true);
            galleryXMLDataNode.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static String[] getPropertyArray(Properties properties, String string, String string2, String string3) {
        String string4 = properties.getProperty(string + string2, "0");
        int n = Integer.parseInt(string4);
        if (n == 0) {
            return null;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = properties.getProperty(string + string3 + n2);
            ++n2;
        }
        return stringArray;
    }

    private static URL getFileURL(String string) {
        URL uRL = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("ERROR: URL [" + uRL.toString() + "] is not valid");
            }
        } else {
            System.err.println("ERROR: File [" + string + "] does not exist");
        }
        return uRL;
    }

    private static void abort(String string) {
        System.err.println("ERROR: " + string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            GalleryAddinUtil.usage();
        }
        System.out.println("Deprecated: Gallery definitions need to be defined in extension manifest");
        URL uRL = GalleryAddinUtil.getFileURL(stringArray[0]);
        URL uRL2 = GalleryAddinUtil.getFileURL(stringArray[1]);
        if (uRL == null || uRL2 == null) {
            GalleryAddinUtil.abort("Invalid Command Line Arguments Given");
            GalleryAddinUtil.usage();
        }
        GalleryAddinUtil.loadGalleryItems(uRL, uRL2);
        GalleryAddinUtil.legacyLoadGalleryItems(uRL, uRL2);
        GalleryAddinUtil.removeGalleryItems(uRL, uRL2);
        System.exit(0);
    }
}

