/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Image;
import java.net.URL;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.resource.GalleryArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;

public final class GalleryElement
implements Comparable,
Element {
    private String _name;
    private String[] _wizardParams;
    private String _iconFile;
    private String _wizClass;
    private boolean _unsorted;
    private String _description;
    private String[] _technologyKeys;
    private transient Wizard _wizard;
    private transient TechId[] _techIds;
    private transient Icon _icon;
    private transient Icon _disabledIcon;
    private String _resClass;
    private static final boolean _debug = Boolean.getBoolean("ObjectGallery.debug");

    public GalleryElement() {
        this(null);
    }

    public GalleryElement(Wizard wizard) {
        this._wizard = wizard;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean bl) {
        this._unsorted = bl;
    }

    public void setWizardClass(String string) {
        this._wizClass = string;
    }

    public String getWizardClass() {
        return this._wizClass;
    }

    public Wizard getWizard() {
        String string;
        if (this._wizard == null && (string = this.getWizardClass()) != null) {
            this._wizard = WizardManager.getInstance().getWizard(string);
        }
        return this._wizard;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public String[] getWizardParameters() {
        return this._wizardParams;
    }

    public void setWizardParameters(String[] stringArray) {
        this._wizardParams = stringArray;
    }

    public void setIconFile(String string) {
        this._iconFile = string;
    }

    public String getIconFile() {
        return this._iconFile;
    }

    public String[] getTechnologyKeys() {
        return this._technologyKeys;
    }

    public void setTechnologyKeys(String[] stringArray) {
        this._technologyKeys = stringArray;
    }

    public String getResClass() {
        return this._resClass;
    }

    public void setResClass(String string) {
        this._resClass = string;
    }

    public Object getData() {
        return this;
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public String getShortLabel() {
        String string;
        String string2 = this.getWizardName();
        Wizard wizard = this.getWizard();
        if (wizard != null) {
            string = wizard.getShortLabel();
            if (!(ModelUtil.hasLength((String)string) || ModelUtil.hasLength((String)(string = wizard.getLongLabel())) || ModelUtil.hasLength((String)(string = wizard.getToolTipText())))) {
                string = string2;
            }
        } else {
            string = string2;
        }
        return string;
    }

    public String getLongLabel() {
        String string = this._description;
        if (!ModelUtil.hasLength((String)string)) {
            String string2 = this.getWizardName();
            Wizard wizard = this.getWizard();
            if (wizard != null) {
                string = wizard.getLongLabel();
                if (!(ModelUtil.hasLength((String)string) || ModelUtil.hasLength((String)(string = wizard.getToolTipText())) || ModelUtil.hasLength((String)(string = wizard.getShortLabel())))) {
                    string = string2;
                }
            } else {
                string = GalleryArb.format(16, string2, this.getWizardClass());
            }
        } else if (this._resClass != null) {
            return this.getString(string);
        }
        return string;
    }

    public String getToolTipText() {
        String string;
        String string2 = this.getWizardName();
        Wizard wizard = this.getWizard();
        if (wizard != null) {
            string = wizard.getToolTipText();
            if (!(ModelUtil.hasLength((String)string) || ModelUtil.hasLength((String)(string = wizard.getLongLabel())) || ModelUtil.hasLength((String)(string = wizard.getShortLabel())))) {
                string = string2;
            }
        } else {
            string = string2;
        }
        if (_debug) {
            string = string + " (" + this.getWizardClass() + ")";
        }
        return string;
    }

    void setIcon(Icon icon) {
        this._icon = icon;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            Wizard wizard;
            ImageIcon imageIcon;
            URL uRL;
            if (this._iconFile != null && (uRL = ClassLoader.getSystemResource(this._iconFile)) != null && ((imageIcon = new ImageIcon(uRL)).getImageLoadStatus() & 8) != 0) {
                this._icon = imageIcon;
            }
            if (this._icon == null && (wizard = this.getWizard()) != null) {
                try {
                    this._icon = wizard.getIcon();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this._icon;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public int compareTo(Object object) {
        if (object instanceof GalleryFolder) {
            return 1;
        }
        if (object instanceof GalleryElement) {
            GalleryElement galleryElement = (GalleryElement)object;
            if (this.getUnsorted() != galleryElement.getUnsorted()) {
                return this.getUnsorted() ? -1 : 1;
            }
            if (this.getUnsorted() && galleryElement.getUnsorted()) {
                return 0;
            }
            return GalleryFolder.COLLATOR.compare(this.getShortLabel(), galleryElement.getShortLabel());
        }
        return GalleryFolder.COLLATOR.compare(this.getShortLabel(), object.toString());
    }

    protected String getWizardDescription() {
        return this.getLongLabel();
    }

    protected String getWizardName() {
        Wizard wizard;
        if (this._name == null && (wizard = this.getWizard()) != null) {
            this._name = wizard.getShortLabel();
        }
        return this._name;
    }

    protected boolean isAvailable(Context context) {
        return ObjectGallery.isWizardAvailable(this.getWizard(), context);
    }

    protected Icon getDisabledIcon() {
        if (this._disabledIcon == null) {
            Icon icon = this.getIcon();
            if (icon instanceof ImageIcon) {
                Image image = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
                this._disabledIcon = new ImageIcon(image);
            } else {
                this._disabledIcon = icon;
            }
        }
        return this._disabledIcon;
    }

    boolean isInScope(TechnologyScope technologyScope) {
        if (technologyScope == null) {
            return false;
        }
        TechId[] techIdArray = this.getTechIds();
        if (techIdArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < techIdArray.length) {
            TechId techId = techIdArray[n];
            if (techId == null || !techId.isInScope(technologyScope)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TechId[] getTechIds() {
        if (this._techIds == null) {
            if (this._technologyKeys != null) {
                this._techIds = new TechId[this._technologyKeys.length];
                int n = 0;
                while (n < this._technologyKeys.length) {
                    this._techIds[n] = TechnologyRegistry.getInstance().getTechId(this._technologyKeys[n]);
                    ++n;
                }
            } else {
                this._techIds = new TechId[0];
            }
        }
        return this._techIds;
    }

    private String getString(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this._resClass);
            String string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

