/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.io.PrintStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.model.Attributes;
import oracle.ide.model.DefaultAttributes;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.ModelUtil;

public class GalleryFolder
implements Comparable,
Folder {
    protected static final Collator COLLATOR = Collator.getInstance();
    private String _name;
    private List _children = new ArrayList(10);
    private boolean _unsorted;
    private transient boolean _expanded;

    public GalleryFolder() {
    }

    public GalleryFolder(String string) {
        this();
        this._name = string;
    }

    public List getList() {
        List list = this.getChildrenDirectly();
        return new ArrayList(list);
    }

    public void setList(List list) {
        List list2 = this.getChildrenDirectly();
        list2.clear();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof Element)) continue;
                this.add((Element)e);
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public boolean getUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean bl) {
        this._unsorted = bl;
    }

    public GalleryFolder getFolder(String string) {
        return this.findFolder(string, false);
    }

    public GalleryFolder createFolder(String string) {
        GalleryFolder galleryFolder = this.getFolder(string);
        if (galleryFolder == null) {
            galleryFolder = new GalleryFolder(string);
            this.add(galleryFolder);
        }
        return galleryFolder;
    }

    public GalleryFolder getGalleryFolder(String string) {
        try {
            GalleryFolder galleryFolder = this.findFolder(string);
            return galleryFolder;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public GalleryElement getGalleryElement(String string) {
        List list = this.getChildrenDirectly();
        for (Element element : list) {
            String string2;
            if (element instanceof GalleryFolder) {
                GalleryElement galleryElement = ((GalleryFolder)element).getGalleryElement(string);
                if (galleryElement == null) continue;
                return galleryElement;
            }
            if (!(element instanceof GalleryElement) || (string2 = element.getShortLabel()) == null || !ModelUtil.areEqual((Object)string2, (Object)string)) continue;
            return (GalleryElement)element;
        }
        return null;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        List list = this.getChildrenDirectly();
        return list.iterator();
    }

    public Attributes getAttributes() {
        return DefaultAttributes.EMPTY_ATTRIBUTES;
    }

    public boolean canAdd(Element element) {
        return false;
    }

    public boolean add(Element element) {
        List list = this.getChildrenDirectly();
        return list.add(element);
    }

    public boolean canRemove(Element element) {
        return false;
    }

    public boolean remove(Element element) {
        List list = this.getChildrenDirectly();
        return list.remove(element);
    }

    public void removeAll() {
        List list = this.getChildrenDirectly();
        list.clear();
    }

    public boolean containsChild(Element element) {
        List list = this.getChildrenDirectly();
        return list.contains(element);
    }

    public int size() {
        List list = this.getChildrenDirectly();
        return list.size();
    }

    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this._name;
    }

    public String getToolTipText() {
        return this._name;
    }

    public Icon getIcon() {
        return null;
    }

    public String toString() {
        return this.getLongLabel();
    }

    public Object getData() {
        return this;
    }

    public int compareTo(Object object) {
        if (object instanceof GalleryElement) {
            return -1;
        }
        if (object instanceof GalleryFolder) {
            GalleryFolder galleryFolder = (GalleryFolder)object;
            if (this.getUnsorted() != galleryFolder.getUnsorted()) {
                return this.getUnsorted() ? -1 : 1;
            }
            if (this.getUnsorted() && galleryFolder.getUnsorted()) {
                return 0;
            }
            return GalleryFolder.compareImpl(this.getShortLabel(), galleryFolder.getShortLabel());
        }
        return GalleryFolder.compareImpl(this.getShortLabel(), object.toString());
    }

    private static int compareImpl(String string, String string2) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        return COLLATOR.compare(string, string2);
    }

    public int getSize() {
        return this.size();
    }

    public Object getElementAt(int n) {
        List list = this.getChildrenDirectly();
        return list.get(n);
    }

    protected boolean isExpanded() {
        return this._expanded;
    }

    protected void setExpanded(boolean bl) {
        this._expanded = bl;
    }

    protected List getChildrenDirectly() {
        return this._children;
    }

    protected void setChildrenDirectly(List list) {
        this._children = list;
    }

    protected GalleryElement[] getElementChildren() {
        Collection collection = this.getChildrenByClass(GalleryElement.class);
        return collection.toArray(new GalleryElement[collection.size()]);
    }

    protected GalleryFolder[] getFolderChildren() {
        Collection collection = this.getChildrenByClass(GalleryFolder.class);
        return collection.toArray(new GalleryFolder[collection.size()]);
    }

    protected GalleryFolder findFolder(String string) {
        return this.findFolder(string, true);
    }

    boolean addElement(ElementInfo elementInfo) {
        GalleryElement galleryElement = this.getGalleryElement(elementInfo.getName());
        if (galleryElement == null) {
            galleryElement = elementInfo.createElement();
            this.add(galleryElement);
            return true;
        }
        return false;
    }

    boolean removeElement(ElementInfo elementInfo) {
        GalleryElement galleryElement = elementInfo.createElement();
        if ((galleryElement = this.getGalleryElement(galleryElement.getShortLabel())) != null) {
            this.remove(galleryElement);
            return true;
        }
        return false;
    }

    boolean isInScope(TechnologyScope technologyScope) {
        if (technologyScope == null) {
            return false;
        }
        for (Object e : this.getChildrenDirectly()) {
            if (!(e instanceof GalleryFolder ? ((GalleryFolder)e).isInScope(technologyScope) : e instanceof GalleryElement && ((GalleryElement)e).isInScope(technologyScope))) continue;
            return true;
        }
        return false;
    }

    boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        for (Object e : this.getChildrenDirectly()) {
            if (!(e instanceof GalleryFolder ? ((GalleryFolder)e).isAvailable(context) : e instanceof GalleryElement && ((GalleryElement)e).isAvailable(context))) continue;
            return true;
        }
        return false;
    }

    void debugLogTechnologies(PrintStream printStream, String string, Map map) {
        Object[] objectArray = this.getElementChildren();
        if (objectArray.length > 0) {
            printStream.println();
            printStream.println(string + ":");
            Arrays.sort(objectArray);
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                String[] stringArray = ((GalleryElement)object).getTechnologyKeys();
                String string2 = GalleryFolder.getTechnologyString(stringArray);
                printStream.println("  " + ((GalleryElement)object).getShortLabel() + " [" + string2 + "]");
                ArrayList<String> arrayList = (ArrayList<String>)map.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    map.put(string2, arrayList);
                }
                arrayList.add(string + ": " + ((GalleryElement)object).getShortLabel());
                ++n;
            }
        }
        Object[] objectArray2 = this.getFolderChildren();
        Arrays.sort(objectArray2);
        int n = 0;
        while (n < objectArray2.length) {
            Object object = objectArray2[n];
            String string3 = ((GalleryFolder)object).getShortLabel();
            String string4 = string != null ? string + " -> " + string3 : string3;
            ((GalleryFolder)object).debugLogTechnologies(printStream, string4, map);
            ++n;
        }
    }

    private static String getTechnologyString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "<none>";
        }
        Arrays.sort(stringArray);
        TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
        TreeSet<TechId> treeSet = new TreeSet<TechId>();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            TechId techId;
            String string2 = stringArray[n];
            string = string + string2;
            if (n < stringArray.length - 1) {
                string = string + " + ";
            }
            if ((techId = technologyRegistry.getTechId(string2)) != null) {
                TechId[] techIdArray = technologyRegistry.getDependenciesFor(techId);
                int n2 = 0;
                while (n2 < techIdArray.length) {
                    TechId techId2 = techIdArray[n2];
                    if (techId2 != null) {
                        treeSet.add(techId2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (!treeSet.isEmpty()) {
            string = string + " (depends on ";
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                TechId techId = (TechId)iterator.next();
                string = string + techId.getKey();
                if (!iterator.hasNext()) continue;
                string = string + " + ";
            }
            string = string + ")";
        }
        return string;
    }

    private Collection getChildrenByClass(Class clazz) {
        List list = this.getChildrenDirectly();
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            if (clazz != null && !clazz.isAssignableFrom(e.getClass())) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private GalleryFolder findFolder(String string, boolean bl) {
        GalleryFolder[] galleryFolderArray = this.getFolderChildren();
        int n = 0;
        while (n < galleryFolderArray.length) {
            GalleryFolder galleryFolder;
            GalleryFolder galleryFolder2 = galleryFolderArray[n];
            if (galleryFolder2.getShortLabel().equals(string)) {
                return galleryFolder2;
            }
            if (bl && (galleryFolder = galleryFolder2.findFolder(string, bl)) != null) {
                return galleryFolder;
            }
            ++n;
        }
        return null;
    }
}

