/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.ArrayList;
import java.util.Collections;
import javax.ide.util.MissingIconException;
import javax.ide.wizard.spi.WizardCategory;
import javax.ide.wizard.spi.WizardInfo;
import javax.swing.ImageIcon;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.JavaxIdeWizard;

final class JavaxIdeElementInfo
extends ElementInfo {
    private final WizardInfo _wizardInfo;

    JavaxIdeElementInfo(WizardInfo wizardInfo) {
        this._wizardInfo = wizardInfo;
    }

    public String getName() {
        return this._wizardInfo.getLabel();
    }

    public String getDescription() {
        return this._wizardInfo.getToolTip();
    }

    public String[] getPath() {
        if (this._wizardInfo.getCategory() == WizardCategory.NONE) {
            return new String[]{"General"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        WizardCategory wizardCategory = this._wizardInfo.getCategory();
        while (wizardCategory != WizardCategory.NONE) {
            arrayList.add(wizardCategory.getLabel());
            wizardCategory = wizardCategory.getParent();
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public GalleryElement createElement() {
        GalleryElement galleryElement = new GalleryElement(new JavaxIdeWizard(this._wizardInfo));
        galleryElement.setWizardClass("oracle.ide.gallery.JavaxIdeWizard");
        galleryElement.setName(this.getName());
        galleryElement.setDescription(this.getDescription());
        try {
            ImageIcon imageIcon = new ImageIcon(this._wizardInfo.getIcon().getURL());
            galleryElement.setIcon(imageIcon);
        }
        catch (MissingIconException missingIconException) {
            missingIconException.printStackTrace();
        }
        galleryElement.setUnsorted(false);
        galleryElement.setWizardParameters(new String[0]);
        galleryElement.setTechnologyKeys(new String[0]);
        return galleryElement;
    }
}

